/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationQuery;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5047\u671f\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/my/userVacation"})
public class UserVacationController {
    private static final Logger log = LoggerFactory.getLogger(UserVacationController.class);
    private final UserVacationService userVacationService;
    private final UdcUtil udcUtil;

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/paging"})
    @UdcNameClass
    public TwOutputUtil<PagingVO<UserVacationVO>> paging(UserVacationQuery query) {
        PagingVO paging = this.userVacationService.page(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public TwOutputUtil save(UserVacationPayload payload) {
        this.userVacationService.save(payload);
        return TwOutputUtil.ok();
    }

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406\u67e5\u8be2")
    @GetMapping(value={"/query/{id}"})
    public TwOutputUtil query(@PathVariable Long id) {
        return TwOutputUtil.ok(this.userVacationService.queryById(id));
    }

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public TwOutputUtil delete(Long[] ids) {
        this.userVacationService.delete(ids);
        return TwOutputUtil.ok();
    }

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406-\u6279\u91cf\u4fee\u6539\u6709\u6548\u671f")
    @PostMapping(value={"/update/expirationDate/batch"})
    public TwOutputUtil updateExpirationBatch(@RequestBody List<UserVacationPayload> payloadList) {
        this.userVacationService.updateExpirationBatch(payloadList);
        return TwOutputUtil.ok();
    }

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406-\u672c\u4eba\u53ef\u7528\u5047\u671f")
    @GetMapping(value={"/available"})
    @UdcNameClass
    public TwOutputUtil available() {
        Long loginUserId = GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.userVacationService.getAvailableVacation(loginUserId, null));
    }

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406-\u67e5\u8be2\u5458\u5de5\u53ef\u7528\u5269\u4f59\u5047\u671f")
    @GetMapping(value={"/available/{userId}"})
    @UdcNameClass
    public TwOutputUtil available(@PathVariable Long userId) {
        return TwOutputUtil.ok(this.userVacationService.getAvailableVacation(userId, null));
    }

    @ApiModelProperty(value="\u5047\u671f\u7ba1\u7406\u5bfc\u51fa")
    @GetMapping(value={"/exportExcel"})
    public void exportExcel(UserVacationQuery query, HttpServletResponse response) throws IOException {
        List list = this.userVacationService.list(query);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = this.udcUtil.translateList(list);
            String sheetName = "\u5047\u671f\u7ba1\u7406\u5bfc\u51fa";
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), UserVacationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
            ExcelUtil.excelHelper(sheet, UserVacationVO.class, null);
            sheet.doWrite(list);
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/tmpDownload"})
    public void tmpDownload(HttpServletResponse response) {
        this.userVacationService.tmpDownload(response);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/batchImport"}, consumes={"multipart/form-data"})
    public TwOutputUtil<String> batchImport(MultipartFile file, Boolean force) {
        return TwOutputUtil.ok(this.userVacationService.importBatch(file, force));
    }

    public UserVacationController(UserVacationService userVacationService, UdcUtil udcUtil) {
        this.userVacationService = userVacationService;
        this.udcUtil = udcUtil;
    }
}

