/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TMoneyTransferQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TMoneyTransferService;
import com.elitesland.tw.tw5.api.prd.my.vo.TMoneyTransferVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TMoneyTransferConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TMoneyTransferDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TMoneyTransferDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TMoneyTransferRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TMoneyTransferServiceImpl
extends BaseServiceImpl
implements TMoneyTransferService {
    private static final Logger log = LoggerFactory.getLogger(TMoneyTransferServiceImpl.class);
    private final TMoneyTransferRepo tMoneyTransferRepo;
    private final TMoneyTransferDAO tMoneyTransferDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService roleService;
    private final FileUtil fileUtil;
    private final BookAccountService bookAccountService;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    public PagingVO<TMoneyTransferVO> queryPaging(TMoneyTransferQuery query) {
        PagingVO<TMoneyTransferVO> tMoneyTransferVOPagingVO = this.tMoneyTransferDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)tMoneyTransferVOPagingVO.getRecords())) {
            ArrayList accountList = new ArrayList();
            List collectionAccountList = tMoneyTransferVOPagingVO.stream().filter(p -> StringUtils.hasText((String)p.getCollectionAccount())).map(s -> Long.valueOf(s.getCollectionAccount())).collect(Collectors.toList());
            List transferAccountList = tMoneyTransferVOPagingVO.stream().filter(p -> StringUtils.hasText((String)p.getTransferAccount())).map(s -> Long.valueOf(s.getTransferAccount())).collect(Collectors.toList());
            accountList.addAll(collectionAccountList);
            accountList.addAll(transferAccountList);
            Map bookAccountVOMap = this.bookAccountService.queryByIdList(accountList);
            tMoneyTransferVOPagingVO.stream().forEach(p -> this.translate((TMoneyTransferVO)p, bookAccountVOMap));
        }
        return tMoneyTransferVOPagingVO;
    }

    public List<TMoneyTransferVO> queryListDynamic(TMoneyTransferQuery query) {
        List<TMoneyTransferVO> tMoneyTransferVOS = this.tMoneyTransferDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(tMoneyTransferVOS)) {
            ArrayList accountList = new ArrayList();
            List collectionAccountList = tMoneyTransferVOS.stream().filter(p -> StringUtils.hasText((String)p.getCollectionAccount())).map(s -> Long.valueOf(s.getCollectionAccount())).collect(Collectors.toList());
            List transferAccountList = tMoneyTransferVOS.stream().filter(p -> StringUtils.hasText((String)p.getTransferAccount())).map(s -> Long.valueOf(s.getTransferAccount())).collect(Collectors.toList());
            accountList.addAll(collectionAccountList);
            accountList.addAll(transferAccountList);
            Map bookAccountVOMap = this.bookAccountService.queryByIdList(accountList);
            tMoneyTransferVOS.stream().forEach(p -> this.translate((TMoneyTransferVO)p, bookAccountVOMap));
        }
        return tMoneyTransferVOS;
    }

    public TMoneyTransferVO queryByKey(Long key) {
        TMoneyTransferDO entity = this.tMoneyTransferRepo.findById(key).orElseGet(TMoneyTransferDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TMoneyTransferVO vo = TMoneyTransferConvert.INSTANCE.toVo(entity);
        ArrayList<Long> accountList = new ArrayList<Long>();
        accountList.add(Long.valueOf(vo.getCollectionAccount()));
        accountList.add(Long.valueOf(vo.getTransferAccount()));
        Map bookAccountVOMap = this.bookAccountService.queryByIdList(accountList);
        this.translate(vo, bookAccountVOMap);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TMoneyTransferVO insert(TMoneyTransferPayload payload) {
        String transferNo = this.generateSeqNum("MONEY_TRANSFER", new String[0]);
        payload.setTransferNo(transferNo);
        TMoneyTransferDO entityDo = TMoneyTransferConvert.INSTANCE.toDo(payload);
        TMoneyTransferDO save = (TMoneyTransferDO)this.tMoneyTransferRepo.save(entityDo);
        this.moneyTransferProc(save);
        return TMoneyTransferConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public TMoneyTransferVO update(TMoneyTransferPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TMoneyTransferDO entity = this.tMoneyTransferRepo.findById(payload.getId()).orElseGet(TMoneyTransferDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TMoneyTransferDO entityDo = TMoneyTransferConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TMoneyTransferConvert.INSTANCE.toVo((TMoneyTransferDO)this.tMoneyTransferRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TMoneyTransferPayload payload) {
        TMoneyTransferDO entity = this.tMoneyTransferRepo.findById(payload.getId()).orElseGet(TMoneyTransferDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tMoneyTransferDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tMoneyTransferDAO.deleteSoft(keys);
        }
    }

    private void moneyTransferProc(TMoneyTransferDO tMoneyTransferDO) {
        ProcessInfo processInfo = new ProcessInfo();
        if (this.workflow_enabled.booleanValue()) {
            String applyResName = this.cacheUtil.getUserName(tMoneyTransferDO.getApplicantUserId());
            HashMap variables = this.dealWorkFlowVariables();
            String procInstName = applyResName + "-" + tMoneyTransferDO.getApplicantTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "-" + tMoneyTransferDO.getTransferMoney() + "-\u8d44\u91d1\u5212\u6b3e\u6d41\u7a0b";
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.ACC_MONEY_TRANSFER.name(), (String)procInstName, (String)("" + tMoneyTransferDO.getId()), (HashMap)variables), new Long[0]);
        }
        TMoneyTransferPayload payload = new TMoneyTransferPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(tMoneyTransferDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        this.transactionUtilService.executeWithRunnable(() -> this.tMoneyTransferDAO.updateByKeyDynamic(payload));
    }

    public HashMap dealWorkFlowVariables() {
        HashMap<String, List> variables = new HashMap<String, List>();
        variables.put("Activity_078sb1w", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_MANAGER.getCode()));
        variables.put("Activity_1w917wj", this.roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));
        variables.put("Activity_18nv388", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CASHIER.getCode()));
        return variables;
    }

    private void translate(TMoneyTransferVO vo, Map<Long, List<BookAccountVO>> bookAccountVOMap) {
        if (StringUtils.hasText((String)vo.getFileCodes())) {
            vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
        }
        if (!CollectionUtils.isEmpty(bookAccountVOMap)) {
            if (bookAccountVOMap.containsKey(Long.valueOf(vo.getCollectionAccount()))) {
                vo.setCollectionAccountDesc(bookAccountVOMap.get(Long.valueOf(vo.getCollectionAccount())).get(0).getAccountNo());
            }
            if (bookAccountVOMap.containsKey(Long.valueOf(vo.getTransferAccount()))) {
                vo.setTransferAccountDesc(bookAccountVOMap.get(Long.valueOf(vo.getTransferAccount())).get(0).getAccountNo());
            }
        }
    }

    public TMoneyTransferServiceImpl(TMoneyTransferRepo tMoneyTransferRepo, TMoneyTransferDAO tMoneyTransferDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, CacheUtil cacheUtil, PrdSystemRoleService roleService, FileUtil fileUtil, BookAccountService bookAccountService) {
        this.tMoneyTransferRepo = tMoneyTransferRepo;
        this.tMoneyTransferDAO = tMoneyTransferDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
        this.roleService = roleService;
        this.fileUtil = fileUtil;
        this.bookAccountService = bookAccountService;
    }
}

