/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgDimensionPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgDimensionQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgDimensionService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDimensionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgDimensionConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgDimensionDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdOrgDimensionServiceImpl
implements PrdOrgDimensionService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgDimensionServiceImpl.class);
    private final PrdOrgDimensionDAO dao;
    private final PrdOrgOrganizationService service;

    @Transactional
    public PrdOrgDimensionVO insert(PrdOrgDimensionPayload payload) {
        if (payload.getDefaultFlag() == 0) {
            this.updateDefaultFlag();
        }
        payload.setVersionId(Long.valueOf(0L));
        PrdOrgDimensionDO ado = PrdOrgDimensionConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        return PrdOrgDimensionConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdOrgDimensionPayload payload) {
        if (payload.getDefaultFlag() == 0) {
            this.updateDefaultFlag();
        }
        return this.dao.updateByKeyDynamic(payload);
    }

    private void updateDefaultFlag() {
        this.dao.updateDefaultFlag();
    }

    @Transactional
    public Long updateStatus(Long id, Integer status) {
        if (id != null && status != null) {
            PrdOrgDimensionDO pdo;
            if (status == 1 && (pdo = this.dao.queryByKey(id)).getDefaultFlag() == 0) {
                throw TwException.error("", "\u9ed8\u8ba4\u7ef4\u5ea6\u4e0d\u53ef\u5173\u95ed");
            }
        } else {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38");
        }
        this.dao.updateStatus(id, status);
        return 0L;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        for (int i = 0; i < keys.size(); ++i) {
            Long dimensionId = keys.get(i);
            List<PrdOrgOrganizationRefDO> list = this.dao.queryOrgList(dimensionId);
            PrdOrgDimensionDO pdo = this.dao.queryByKey(dimensionId);
            if (pdo.getDefaultFlag() == 0) {
                throw TwException.error("", "\u9ed8\u8ba4\u7ef4\u5ea6\u53ca\u5b58\u5728\u4e0b\u5c5e\u7ec4\u7ec7\u4e0d\u53ef\u5220\u9664");
            }
            for (PrdOrgOrganizationRefDO refDo : list) {
                if (this.service.deleteSoft(dimensionId, refDo.getOrgId())) continue;
                throw TwException.error("", "\u9ed8\u8ba4\u7ef4\u5ea6\u53ca\u5b58\u5728\u4e0b\u5c5e\u7ec4\u7ec7\u4e0d\u53ef\u5220\u9664");
            }
            this.dao.deleteSoft(dimensionId);
        }
        return true;
    }

    public List<PrdOrgDimensionVO> queryList() {
        PrdOrgDimensionQuery query = new PrdOrgDimensionQuery();
        query.setVersionId(Long.valueOf(0L));
        return this.dao.queryList(query);
    }

    public PrdOrgDimensionVO queryByVersionId(Long versionId) {
        return this.dao.queryByVersionId(versionId);
    }

    public PrdOrgDimensionServiceImpl(PrdOrgDimensionDAO dao, PrdOrgOrganizationService service) {
        this.dao = dao;
        this.service = service;
    }
}

