/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.identity.controller;

import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/api/crm/businessSupplierInfo"})
public class BusinessSupplierInfoController {
    private static final Logger log = LoggerFactory.getLogger(BusinessSupplierInfoController.class);
    private final BusinessSupplierInfoService businessSupplierInfoService;

    @PostMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f-\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody BusinessSupplierInfoPayload payload) {
        return TwOutputUtil.ok(this.businessSupplierInfoService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f-\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody BusinessSupplierInfoPayload payload) {
        return TwOutputUtil.ok(this.businessSupplierInfoService.update(payload));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<BusinessSupplierInfoVO>> queryList(BusinessSupplierInfoQuery query) {
        return TwOutputUtil.ok(this.businessSupplierInfoService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.businessSupplierInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/activeSupplier"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f-\u4f9b\u5e94\u5546\u72b6\u6001\u4fee\u6539")
    public TwOutputUtil activeSupplier(Long partnerId, String partnerName, String supplierStatus) {
        this.businessSupplierInfoService.updateSupplierStatus(partnerId, partnerName, supplierStatus);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/activeSupplier/check"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f-\u4f9b\u5e94\u5546\u6fc0\u6d3b\u68c0\u9a8c true\u901a\u8fc7 false\u4e0d\u901a\u8fc7")
    public TwOutputUtil activeSupplierCheck(Long bookId) {
        Boolean res = this.businessSupplierInfoService.activeSupplierCheck(bookId);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"/activeSupplier/checkWithChange"})
    @ApiOperation(value="\u4e1a\u52a1\u4f19\u4f34-\u4f9b\u5e94\u5546\u4fe1\u606f-\u4f9b\u5e94\u5546\u6fc0\u6d3b\u68c0\u9a8c true\u901a\u8fc7 false\u4e0d\u901a\u8fc7")
    public TwOutputUtil activeSupplierCheckWithChange(Long bookId) {
        Boolean res = this.businessSupplierInfoService.activeSupplierCheckWithChange(bookId);
        return TwOutputUtil.ok(res);
    }

    public BusinessSupplierInfoController(BusinessSupplierInfoService businessSupplierInfoService) {
        this.businessSupplierInfoService = businessSupplierInfoService;
    }
}

