/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdActivityCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdScheduleAttendeesPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdScheduleRepeatPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxScheduleAttendeesPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdActivityCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdActivityCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarAbleVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdActivityCalendarConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdActivityCalendarDAO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdActivityCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdActivityCalendarRepo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PrdActivityCalendarServiceImpl
extends BaseServiceImpl
implements PrdActivityCalendarService {
    private static final Logger log = LoggerFactory.getLogger(PrdActivityCalendarServiceImpl.class);
    private final PrdActivityCalendarRepo prdActivityCalendarRepo;
    private final PrdActivityCalendarDAO prdActivityCalendarDAO;
    private final CrmActActivityService activityService;
    private final PrdScheduleService scheduleService;
    private final PrdCalendarService calendarService;
    private final CacheUtil cacheUtil;
    private final QyWxCommunicationService wxService;
    private final PrdSystemRoleService roleService;

    public PagingVO<PrdActivityCalendarVO> queryPaging(PrdActivityCalendarQuery query) {
        CrmActActivityQuery actActivityQuery = new CrmActActivityQuery();
        this.activityService.paging(actActivityQuery);
        return this.prdActivityCalendarDAO.queryPaging(query);
    }

    public List<PrdActivityCalendarVO> queryListDynamic(PrdActivityCalendarQuery query) {
        return this.prdActivityCalendarDAO.queryListDynamic(query);
    }

    public PrdActivityCalendarVO queryByKey(Long key) {
        PrdActivityCalendarDO entity = this.prdActivityCalendarRepo.findById(key).orElseGet(PrdActivityCalendarDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdActivityCalendarVO vo = PrdActivityCalendarConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdActivityCalendarVO insert(PrdActivityCalendarPayload payload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (!ObjectUtils.isEmpty((Object)payload.getParticipantsList())) {
            String participants = payload.getParticipantsList().stream().map(Object::toString).collect(Collectors.joining(","));
            payload.setParticipants(participants);
        }
        PrdActivityCalendarDO entityDo = PrdActivityCalendarConvert.INSTANCE.toDo(payload);
        List prdCalendarVOList = this.calendarService.queryByUser(loginUserId);
        PrdCalendarVO prdCalendarVO = (PrdCalendarVO)prdCalendarVOList.get(0);
        PrdSchedulePayload schedulePayload = new PrdSchedulePayload();
        if (!ObjectUtils.isEmpty((Object)payload.getId())) {
            PrdActivityCalendarDO entity = this.prdActivityCalendarRepo.findById(payload.getId()).orElseGet(PrdActivityCalendarDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
            PrdScheduleVO prdScheduleVO = this.scheduleService.queryDetail(entity.getScheduleId());
            schedulePayload.setQyWxScheduleId(prdScheduleVO.getQyWxScheduleId());
            schedulePayload.setId(entity.getScheduleId());
        }
        schedulePayload.setStartTime(entityDo.getStartTime());
        schedulePayload.setEndTime(entityDo.getEndTime());
        schedulePayload.setLocation(entityDo.getLocation());
        schedulePayload.setTitle(entityDo.getTitle());
        schedulePayload.setCalId(prdCalendarVO.getId());
        PrdScheduleRepeatPayload repeatPayload = new PrdScheduleRepeatPayload();
        repeatPayload.setRepeatInterval(Integer.valueOf(1));
        schedulePayload.setRepeat(repeatPayload);
        schedulePayload.setAllDay(Integer.valueOf(0));
        schedulePayload.setIsRepeat(Integer.valueOf(0));
        schedulePayload.setCalId(prdCalendarVO.getId());
        ArrayList<PrdScheduleAttendeesPayload> attendances = new ArrayList<PrdScheduleAttendeesPayload>();
        PrdScheduleAttendeesPayload loginPayload = new PrdScheduleAttendeesPayload();
        loginPayload.setUserId(loginUserId);
        attendances.add(loginPayload);
        if (!ObjectUtils.isEmpty((Object)payload.getParticipantsList())) {
            for (Long userId : payload.getParticipantsList()) {
                PrdScheduleAttendeesPayload attendeesPayload = new PrdScheduleAttendeesPayload();
                attendeesPayload.setUserId(userId);
                attendances.add(attendeesPayload);
            }
        }
        if (!ObjectUtils.isEmpty((Object)payload.getManageUserId())) {
            PrdScheduleAttendeesPayload manager = new PrdScheduleAttendeesPayload();
            manager.setUserId(payload.getManageUserId());
            attendances.add(manager);
        }
        schedulePayload.setAttendees(attendances);
        schedulePayload.setCreateUserId(loginUserId);
        PrdScheduleVO prdScheduleVO = this.scheduleService.insertOrUpdate(schedulePayload);
        entityDo.setScheduleId(prdScheduleVO.getId());
        return PrdActivityCalendarConvert.INSTANCE.toVo((PrdActivityCalendarDO)((Object)this.prdActivityCalendarRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdActivityCalendarVO update(PrdActivityCalendarPayload payload) {
        PrdActivityCalendarDO entity = this.prdActivityCalendarRepo.findById(payload.getId()).orElseGet(PrdActivityCalendarDO::new);
        PrdActivityCalendarDO entityDo = PrdActivityCalendarConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdActivityCalendarConvert.INSTANCE.toVo((PrdActivityCalendarDO)((Object)this.prdActivityCalendarRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PrdActivityCalendarPayload payload) {
        PrdActivityCalendarDO entity = this.prdActivityCalendarRepo.findById(payload.getId()).orElseGet(PrdActivityCalendarDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.prdActivityCalendarDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdActivityCalendarDAO.deleteSoft(keys);
        }
    }

    public PrdActivityCalendarAbleVO queryList(PrdActivityCalendarQuery query) {
        PrdActivityCalendarAbleVO prdActivityCalendarAbleVO = new PrdActivityCalendarAbleVO();
        Long loginUserId = GlobalUtil.getLoginUserId();
        List userIds = this.roleService.queryUserIdByRoleCode(RoleEnum.MARKET_RES.getCode());
        Boolean createable = userIds.contains(loginUserId);
        prdActivityCalendarAbleVO.setCreateable(createable);
        CrmActActivityQuery actActivityQuery = new CrmActActivityQuery();
        if (!ObjectUtils.isEmpty((Object)query.getYearMonth())) {
            String dateString = query.getYearMonth() + "-01";
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE;
            LocalDate localDate = LocalDate.parse(dateString, formatter);
            query.setYearMonthDate(localDate);
            actActivityQuery.setYearMonthDate(localDate);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectTime())) {
            actActivityQuery.setProjectTime(query.getProjectTime());
        }
        List actActivityVOList = this.activityService.queryListDynamic(actActivityQuery);
        ArrayList<PrdActivityCalendarVO> actActivityVoList = new ArrayList<PrdActivityCalendarVO>();
        LocalDateTime now = LocalDateTime.now();
        for (CrmActActivityVO activityVO : actActivityVOList) {
            CrmActActivityVO crmActActivityVO = this.activityService.queryByKey(activityVO.getId());
            PrdActivityCalendarVO activityCalendarVO = new PrdActivityCalendarVO();
            activityCalendarVO.setId(activityVO.getId());
            activityCalendarVO.setProjectName(activityVO.getProjectName());
            activityCalendarVO.setStartTime(activityVO.getStartTime().atTime(0, 0, 0));
            activityCalendarVO.setEndTime(activityVO.getEndTime().atTime(23, 59, 59));
            activityCalendarVO.setActivityAddr(activityVO.getActivityAddr());
            activityCalendarVO.setType(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), activityVO.getDetailType()));
            activityCalendarVO.setScale(activityVO.getActivityScale());
            activityCalendarVO.setSourceType("activity");
            activityCalendarVO.setManageUserId(activityVO.getManageUserId());
            activityCalendarVO.setLocation(activityVO.getActivityAddr());
            List memberVOS = crmActActivityVO.getMemberVOS();
            ArrayList<String> participantsNameList = new ArrayList<String>();
            for (PrjProjectMemberVO prjProjectMemberVO : memberVOS) {
                participantsNameList.add(prjProjectMemberVO.getEmployeeName());
            }
            activityCalendarVO.setParticipantsNameList(participantsNameList);
            if (activityCalendarVO.getStartTime().isAfter(now)) {
                activityCalendarVO.setStatus("\u672a\u5f00\u59cb");
            }
            if (activityCalendarVO.getEndTime().isBefore(now)) {
                activityCalendarVO.setStatus("\u5df2\u7ed3\u675f");
            }
            if (activityCalendarVO.getStartTime().isBefore(now) && activityCalendarVO.getEndTime().isAfter(now)) {
                activityCalendarVO.setStatus("\u8fdb\u884c\u4e2d");
            }
            activityCalendarVO.setEditable(Boolean.valueOf(false));
            boolean containsUser = false;
            if (activityVO.getScheduleId() != null) {
                PrdScheduleVO prdScheduleVO = this.scheduleService.queryDetail(activityVO.getScheduleId());
                List attendeesVOS = prdScheduleVO.getAttendeesVOS();
                containsUser = attendeesVOS.stream().anyMatch(attendeesVO -> attendeesVO.getUserId().equals(loginUserId));
            }
            activityCalendarVO.setSync(Boolean.valueOf(containsUser));
            actActivityVoList.add(activityCalendarVO);
        }
        ArrayList<PrdActivityCalendarVO> allCalender = new ArrayList<PrdActivityCalendarVO>(actActivityVoList);
        List<PrdActivityCalendarVO> activityCalendarVOList = this.prdActivityCalendarDAO.queryListDynamic(query);
        activityCalendarVOList.forEach(prdActivityCalendarVO -> {
            prdActivityCalendarVO.setSourceType("appActivity");
            prdActivityCalendarVO.setProjectName(prdActivityCalendarVO.getTitle());
            if (!ObjectUtils.isEmpty((Object)prdActivityCalendarVO.getParticipants())) {
                String[] participantsArray = prdActivityCalendarVO.getParticipants().split(",");
                List participantsList = Arrays.stream(participantsArray).map(Long::parseLong).collect(Collectors.toList());
                prdActivityCalendarVO.setParticipantsList(participantsList);
            }
            if (prdActivityCalendarVO.getStartTime().isAfter(now)) {
                prdActivityCalendarVO.setStatus("\u672a\u5f00\u59cb");
            }
            if (prdActivityCalendarVO.getEndTime().isBefore(now)) {
                prdActivityCalendarVO.setStatus("\u5df2\u7ed3\u675f");
            }
            if (prdActivityCalendarVO.getStartTime().isBefore(now) && prdActivityCalendarVO.getEndTime().isAfter(now)) {
                prdActivityCalendarVO.setStatus("\u8fdb\u884c\u4e2d");
            }
            boolean containsUser = false;
            if (prdActivityCalendarVO.getScheduleId() != null) {
                PrdScheduleVO prdScheduleVO = this.scheduleService.queryDetail(prdActivityCalendarVO.getScheduleId());
                List attendeesVOS = prdScheduleVO.getAttendeesVOS();
                containsUser = attendeesVOS.stream().anyMatch(attendeesVO -> attendeesVO.getUserId().equals(loginUserId));
            }
            prdActivityCalendarVO.setSync(Boolean.valueOf(containsUser));
            prdActivityCalendarVO.setEditable(Boolean.valueOf(prdActivityCalendarVO.getCreateUserId().equals(loginUserId)));
            if (!ObjectUtils.isEmpty((Object)prdActivityCalendarVO.getParticipantsList())) {
                ArrayList<String> participantsNameList = new ArrayList<String>();
                for (Long userId : prdActivityCalendarVO.getParticipantsList()) {
                    String userName = this.cacheUtil.getUserName(userId);
                    participantsNameList.add(userName);
                }
                prdActivityCalendarVO.setParticipantsNameList(participantsNameList);
            }
        });
        allCalender.addAll(activityCalendarVOList);
        allCalender.sort(Comparator.comparing(PrdActivityCalendarVO::getStartTime).reversed());
        prdActivityCalendarAbleVO.setActivityCalendarVOList(allCalender);
        return prdActivityCalendarAbleVO;
    }

    @Transactional
    public void syncSchedule(Long id, String type) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(loginUserId);
        String wecomId = employee.getWecomId();
        if (type.equals("activity")) {
            CrmActActivityVO crmActActivityVO = this.activityService.queryByKey(id);
            Long scheduleId = crmActActivityVO.getScheduleId();
            if (scheduleId != null) {
                ArrayList<QyWxScheduleAttendeesPayload> attendees = new ArrayList<QyWxScheduleAttendeesPayload>();
                QyWxScheduleAttendeesPayload qyWxScheduleAttendeesPayload = new QyWxScheduleAttendeesPayload();
                qyWxScheduleAttendeesPayload.setUserid(wecomId);
                attendees.add(qyWxScheduleAttendeesPayload);
                PrdScheduleVO prdScheduleVO = this.scheduleService.queryDetail(scheduleId);
                QyWxSchedulePayload qyWxSchedulePayload = new QyWxSchedulePayload();
                qyWxSchedulePayload.setSchedule_id(prdScheduleVO.getQyWxScheduleId());
                qyWxSchedulePayload.setAttendees(attendees);
                this.scheduleService.addAttendees(scheduleId, loginUserId);
                this.wxService.addAttendees(qyWxSchedulePayload);
            } else {
                PrdSchedulePayload schedulePayload = new PrdSchedulePayload();
                schedulePayload.setId(scheduleId);
                schedulePayload.setStartTime(crmActActivityVO.getStartTime().atTime(0, 0, 0));
                schedulePayload.setEndTime(crmActActivityVO.getEndTime().atTime(23, 59, 59));
                schedulePayload.setLocation(crmActActivityVO.getActivityAddr());
                schedulePayload.setTitle(crmActActivityVO.getProjectName());
                ArrayList<PrdScheduleAttendeesPayload> attendeesPayloadList = new ArrayList<PrdScheduleAttendeesPayload>();
                PrdScheduleAttendeesPayload attendeesPayload = new PrdScheduleAttendeesPayload();
                attendeesPayload.setUserId(loginUserId);
                attendeesPayloadList.add(attendeesPayload);
                schedulePayload.setAttendees(attendeesPayloadList);
                List prdCalendarVOList = this.calendarService.queryByUser(loginUserId);
                PrdCalendarVO prdCalendarVO = (PrdCalendarVO)prdCalendarVOList.get(0);
                Long calId = prdCalendarVO.getId();
                schedulePayload.setCreateUserId(loginUserId);
                PrdScheduleRepeatPayload repeatPayload = new PrdScheduleRepeatPayload();
                repeatPayload.setRepeatInterval(Integer.valueOf(1));
                schedulePayload.setRepeat(repeatPayload);
                schedulePayload.setAllDay(Integer.valueOf(0));
                schedulePayload.setIsRepeat(Integer.valueOf(0));
                schedulePayload.setCalId(calId);
                PrdScheduleVO prdScheduleVO = this.scheduleService.insertOrUpdate(schedulePayload);
                this.activityService.updateSchedule(id, prdScheduleVO.getId());
            }
        } else {
            PrdActivityCalendarVO activityCalendarVO = this.queryByKey(id);
            Long scheduleId = activityCalendarVO.getScheduleId();
            ArrayList<QyWxScheduleAttendeesPayload> attendees = new ArrayList<QyWxScheduleAttendeesPayload>();
            QyWxScheduleAttendeesPayload qyWxScheduleAttendeesPayload = new QyWxScheduleAttendeesPayload();
            qyWxScheduleAttendeesPayload.setUserid(wecomId);
            attendees.add(qyWxScheduleAttendeesPayload);
            PrdScheduleVO prdScheduleVO = this.scheduleService.queryDetail(scheduleId);
            QyWxSchedulePayload qyWxSchedulePayload = new QyWxSchedulePayload();
            qyWxSchedulePayload.setSchedule_id(prdScheduleVO.getQyWxScheduleId());
            qyWxSchedulePayload.setAttendees(attendees);
            this.scheduleService.addAttendees(scheduleId, loginUserId);
            this.wxService.addAttendees(qyWxSchedulePayload);
        }
    }

    public PrdActivityCalendarServiceImpl(PrdActivityCalendarRepo prdActivityCalendarRepo, PrdActivityCalendarDAO prdActivityCalendarDAO, CrmActActivityService activityService, PrdScheduleService scheduleService, PrdCalendarService calendarService, CacheUtil cacheUtil, QyWxCommunicationService wxService, PrdSystemRoleService roleService) {
        this.prdActivityCalendarRepo = prdActivityCalendarRepo;
        this.prdActivityCalendarDAO = prdActivityCalendarDAO;
        this.activityService = activityService;
        this.scheduleService = scheduleService;
        this.calendarService = calendarService;
        this.cacheUtil = cacheUtil;
        this.wxService = wxService;
        this.roleService = roleService;
    }
}

