package com.elitesland.tw.tw5.server.common.funConfig.controller;

import cn.hutool.extra.expression.ExpressionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessPagePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageSearchJsonQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessPageService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageListVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 页面配置
 *
 * @author duwh
 * @folder 页面配置
 * @date 2023-06-20
 */
@Api(tags = "页面配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessPage")
@Slf4j
public class BusinessPageController {

    private final BusinessPageService businessPageService;

    /**
     * 页面配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PostMapping
    @ApiOperation("页面配置-新增")
    public TwOutputUtil<BusinessPageVO> insert(@RequestBody BusinessPagePayload payload) {
        return TwOutputUtil.ok(businessPageService.insert(payload));
    }

    /**
     * 页面配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping
    @ApiOperation("页面配置-更新")
    public TwOutputUtil<BusinessPageVO> update(@RequestBody BusinessPagePayload payload) {
        return TwOutputUtil.ok(businessPageService.update(payload));
    }

    /**
     * 页面配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping("update")
    @ApiOperation("页面配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessPagePayload payload) {
        return TwOutputUtil.ok(businessPageService.updateByKeyDynamic(payload));
    }

    /**
     * 页面配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("页面配置-主键查询")
    public TwOutputUtil<BusinessPageVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessPageService.queryByKey(key));
    }


    /**
     * 页面配置-根据编号查询
     *
     * @param code 编码
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/getByCode/{code}")
    // @UdcNameClass
    @ApiOperation("页面配置-根据编号查询")
    public TwOutputUtil<BusinessPageVO> getByCode(@PathVariable String code) {
        return TwOutputUtil.ok(businessPageService.getByCode(code));
    }

    @PostMapping("/getJson")
    @ApiOperation("页面配置-获取json配置")
    public TwOutputUtil<BusinessPageVO> getJson(@RequestBody BusinessPageSearchJsonQuery query) {
        return TwOutputUtil.ok(businessPageService.getJson(query));
    }

    @PostMapping("/checkEl")
    @ApiOperation("测试表达式")
    public TwOutputUtil checkEl(@RequestBody BusinessPageSearchJsonQuery query) {
        Object result = ExpressionUtil.eval(query.getElContext(), query.getContextMap());
        return TwOutputUtil.ok(result);
    }

    /**
     * 页面配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("页面配置-分页")
    public TwOutputUtil<PagingVO<BusinessPageListVO>> paging(BusinessPageQuery query) {
        return TwOutputUtil.ok(businessPageService.querySimplePaging(query));
    }

    /**
     * 页面配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("页面配置-查询列表")
    public TwOutputUtil<List<BusinessPageListVO>> queryList(BusinessPageQuery query) {
        return TwOutputUtil.ok(businessPageService.querySimpleListDynamic(query));
    }

    /**
     * 页面配置-查重统计
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/count")
    @ApiOperation("页面配置-查重统计")
    public TwOutputUtil<Long> count(BusinessPageQuery query) {
        return TwOutputUtil.ok(businessPageService.count(query));
    }

    /**
     * 页面配置-删除
     *
     * @param keys 主键id
     * @return result
     * @folder 页面配置
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("页面配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessPageService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

