package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 科目模板管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Entity
@Table(name = "acc_subject_template", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_subject_template", comment = "科目模板管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccSubjectTemplateDO extends BaseModel implements Serializable  {
    /** 模板编号 */
    @Comment("模板编号")
    @Column()
    private String tmplNo;
    /** 模板名称 */
    @Comment("模板名称")
    @Column()
    private String tmplName;
    /** 适用行业 */
    @Comment("适用行业")
    @Column()
    private String tmplIndustry;
    /** 模板状态 */
    @Comment("模板状态")
    @Column()
    private String tmplStatus;
    /** 模板类别 */
    @Comment("模板类别")
    @Column()
    private String tmplClass;
    /** 适用类型 */
    @Comment("适用类型")
    @Column()
    private String tmplType;
    /** 预算控制级别 */
    @Comment("预算控制级别")
    @Column()
    private Integer budgetLevel;
    /** 控制策略 */
    @Comment("控制策略")
    @Column()
    private String controlType;
    /** 可配置字段1 */
    @Comment("可配置字段1")
    @Column()
    private String extStr1;
    /** 可配置字段2 */
    @Comment("可配置字段2")
    @Column()
    private String extStr2;
    /** 可配置字段3 */
    @Comment("可配置字段3")
    @Column()
    private String extStr3;
    /** 可配置字段4 */
    @Comment("可配置字段4")
    @Column()
    private String extStr4;
    /** 可配置字段5 */
    @Comment("可配置字段5")
    @Column()
    private String extStr5;

    public void copy(AccSubjectTemplateDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
