package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 核算-账号功能管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Api(tags = "核算-账号功能管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calAccount")
@Slf4j
public class CalAccountController {

    private final CalAccountService calAccountService;

    /**
     * 核算-账号功能管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("核算-账号功能管理-新增")
    public TwOutputUtil<CalAccountVO> insert(@RequestBody CalAccountPayload payload) {
        return TwOutputUtil.ok(calAccountService.insert(payload));
    }

//    /**
//     * 核算-账号功能管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("核算-账号功能管理-更新")
//    public TwOutputUtil<CalAccountVO> update(@RequestBody CalAccountPayload payload){
//        return TwOutputUtil.ok(calAccountService.update(payload));
//    }

    /**
     * 核算-账号功能管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("核算-账号功能管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CalAccountPayload payload) {
        return TwOutputUtil.ok(calAccountService.updateByKeyDynamic(payload));
    }

    /**
     * 核算-账号功能管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("核算-账号功能管理-主键查询")
    public TwOutputUtil<CalAccountVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calAccountService.queryByKey(key));
    }

    /**
     * 核算-账号功能管理-根据账户类型和主体id查询
     *
     * @param auType 账户类型 类型选择项key：CAL:ACC:TYPE
     * @param auId   主体id
     * @return
     */
    @GetMapping("/queryByAuTypeAndAuId")
    @UdcNameClass
    @ApiOperation("核算-账号功能管理-主键查询")
    public TwOutputUtil<CalAccountVO> queryByAuTypeAndAuId(String auType, Long auId) {
        return TwOutputUtil.ok(calAccountService.queryByAuTypeAndAuId(auType, auId));
    }

    /**
     * 核算-账号功能管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("核算-账号功能管理-分页")
    public TwOutputUtil<PagingVO<CalAccountVO>> paging(CalAccountQuery query) {
        return TwOutputUtil.ok(calAccountService.queryPaging(query));
    }

    /**
     * 核算-账号功能管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("核算-账号功能管理-查询列表")
    public TwOutputUtil<List<CalAccountVO>> queryList(CalAccountQuery query) {
        return TwOutputUtil.ok(calAccountService.queryListDynamic(query));
    }

    /**
     * 核算-账号功能管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("核算-账号功能管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calAccountService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
//

    /**
     * 初始化历史账户
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/initAccount")
    @ApiOperation("初始化历史账户")
    public TwOutputUtil initAccount() {
        calAccountService.initAccount();
        return TwOutputUtil.ok();
    }

}

