package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountTurnoverQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountTurnoverService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountTurnoverVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核算-账户流水记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Api(tags = "核算-账户流水记录管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calAccountTurnover")
@Slf4j
public class CalAccountTurnoverController {

    private final CalAccountTurnoverService calAccountTurnoverService;

    /**
     * 核算-账户流水记录管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("核算-账户流水记录管理-分页")
    public TwOutputUtil<PagingVO<CalAccountTurnoverVO>> paging(CalAccountTurnoverQuery query) {
        return TwOutputUtil.ok(calAccountTurnoverService.queryPaging(query));
    }
//    /**
//     * 核算-账户流水记录管理-新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("核算-账户流水记录管理-新增")
//    public TwOutputUtil<CalAccountTurnoverVO> insert(@RequestBody CalAccountTurnoverPayload payload) {
//        return TwOutputUtil.ok(calAccountTurnoverService.insert(payload));
//    }

//    /**
//     * 核算-账户流水记录管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("核算-账户流水记录管理-更新")
//    public TwOutputUtil<CalAccountTurnoverVO> update(@RequestBody CalAccountTurnoverPayload payload){
//        return TwOutputUtil.ok(calAccountTurnoverService.update(payload));
//    }

//    /**
//     * 核算-账户流水记录管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("核算-账户流水记录管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CalAccountTurnoverPayload payload) {
//        return TwOutputUtil.ok(calAccountTurnoverService.updateByKeyDynamic(payload));
//    }
//
//    /**
//     * 核算-账户流水记录管理-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("核算-账户流水记录管理-主键查询")
//    public TwOutputUtil<CalAccountTurnoverVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(calAccountTurnoverService.queryByKey(key));
//    }
//
//
//    /**
//     * 核算-账户流水记录管理-查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("核算-账户流水记录管理-查询列表")
//    public TwOutputUtil<List<CalAccountTurnoverVO>> queryList(CalAccountTurnoverQuery query) {
//        return TwOutputUtil.ok(calAccountTurnoverService.queryListDynamic(query));
//    }
//
//    /**
//     * 核算-账户流水记录管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("核算-账户流水记录管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        calAccountTurnoverService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}

