package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalWideSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalWideSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalWideSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalWideSettleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalWideSettleConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalWideSettleDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalWideSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalWideSettleRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTurTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 泛用当量结算单管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalWideSettleServiceImpl extends BaseServiceImpl implements CalWideSettleService {

    private final CalWideSettleRepo calWideSettleRepo;
    private final CalWideSettleDAO calWideSettleDAO;
    private final CalResourceService calResourceService;
    //    private final TransactionUtilService transactionUtilService;
    private final FileUtil fileUtil;

    @Override
    public PagingVO<CalWideSettleVO> queryPaging(CalWideSettleQuery query) {
        return calWideSettleDAO.queryPaging(query);
    }

    @Override
    public List<CalWideSettleVO> queryListDynamic(CalWideSettleQuery query) {
        return calWideSettleDAO.queryListDynamic(query);
    }

    @Override
    public CalWideSettleVO queryByKey(Long key) {
        CalWideSettleVO calWideSettleVO = calWideSettleDAO.queryByKey(key);
        calWideSettleVO.setFileDatas(fileUtil.getFileDatas(calWideSettleVO.getFileCodes()));
        return calWideSettleVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CalWideSettleVO insertOrUpdate(CalWideSettlePayload payload) {
        //数据校验
        checkData(payload);
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (payload.getId() == null) {
            String code = generateSeqNum("CAL_WIDE_SETTLE");
            payload.setSettleNo(code);
        } else {
            CalWideSettleVO calWideSettleVO = calWideSettleDAO.queryByKey(payload.getId());
            if (calWideSettleVO.getSettleStatus().equals(CalSettleStatusEnum.FINISH.getCode())) {
                throw TwException.error("", "不支持改状态数据修改");
            }
            loginUserId = calWideSettleVO.getApplyResId();
            payload.setCreateTime(calWideSettleVO.getCreateTime());
            payload.setCreateUserId(calWideSettleVO.getCreateUserId());
        }
        String status = CalSettleStatusEnum.CREATE.getCode();
        if (payload.getIsSubmit() != null && payload.getIsSubmit() == 1) {
            status = CalSettleStatusEnum.FINISH.getCode();
        }
        payload.setApplyResId(loginUserId);

        payload.setSettleStatus(status);
        CalWideSettleDO entityDo = CalWideSettleConvert.INSTANCE.toDo(payload);
        CalWideSettleVO calWideSettleVO = CalWideSettleConvert.INSTANCE.toVo(calWideSettleRepo.save(entityDo));
        //审批通过产生流水记录
        if (status.equals(CalSettleStatusEnum.FINISH.getCode())) {
            //开启事务执行
            calResourceService.wideSettleTurnover(calWideSettleVO);
//            transactionUtilService.executeWithRunnable(() -> {
//                calResourceService.wideSettleTurnover(calWideSettleVO);
//            });
        }
        return calWideSettleVO;
    }

    /**
     * 数据校验
     *
     * @param payload
     */
    void checkData(CalWideSettlePayload payload) {
        if (payload.getSettleDate() == null) {
            throw TwException.error("", "结算期间不可为空");
        }
        if (ObjectUtils.isEmpty(payload.getSettleType())) {
            throw TwException.error("", "结算类型不可为空");
        }
        /** 支出核算主题类型 */
        if (ObjectUtils.isEmpty(payload.getFromSourceType())) {
            throw TwException.error("", "支出核算主题类型不可为空");
        }
        /** 支出核算主题id  */
        if (payload.getFromSourceId() == null) {
            throw TwException.error("", "支出核算主题不可为空");
        }
        /** 支出核算主题 */
        if (ObjectUtils.isEmpty(payload.getFromSourceName())) {
            throw TwException.error("", "支出核算主题名称不可为空");
        }
        /** 收入核算主题类型  */
        if (ObjectUtils.isEmpty(payload.getToSourceType())) {
            throw TwException.error("", "收入核算主题类型不可为空");
        }
        /** 收入核算主题id  */
        if (payload.getToSourceId() == null) {
            throw TwException.error("", "收入核算主题不可为空");
        }
        /** 收入核算主题  */
        if (ObjectUtils.isEmpty(payload.getToSourceName())) {
            throw TwException.error("", "收入核算主题名称不可为空");
        }
        if (payload.getFromSourceType().equals(payload.getToSourceType()) && payload.getFromSourceId().equals(payload.getToSourceId())) {
            throw TwException.error("", "支出、收入核算主体不可相同");
        }
        /** 申请结算当量数  */
        if (payload.getApplySettleEqva() == null) {
            throw TwException.error("", "申请结算当量数不可为空");
        }
        /** 申请结算总额  */
        if (payload.getApplySettleAmt() == null) {
            throw TwException.error("", "申请结算总额不可为空");
        }
        /** 结算单价  */
        if (payload.getSettlePrice() == null) {
            throw TwException.error("", "申请结算单价不可为空");
        }
        List<String> types = Arrays.asList(CalAccTypeEnum.PROJ.getCode(), CalAccTypeEnum.BU.getCode(), CalAccTypeEnum.BU_PROJ.getCode(), CalAccTypeEnum.OPP.getCode());
        if (!types.contains(payload.getFromSourceType())) {
            throw TwException.error("", "不支持的泛用当量交易类型");
        }
        if (!types.contains(payload.getToSourceType())) {
            throw TwException.error("", "不支持的泛用当量交易类型");
        }
        if (payload.getSettleType().equals(CalAccTurTypeEnum.HANDWORK.getCode())) {
            //手工调整不支持项目--BU
            if (payload.getFromSourceType().equals(CalAccTypeEnum.PROJ.getCode()) && payload.getToSourceType().equals(CalAccTypeEnum.BU.getCode())) {
                throw TwException.error("", "不支持的泛用当量交易类型");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(CalWideSettlePayload payload) {

        long result = calWideSettleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<CalWideSettleVO> calWideSettleVOS = calWideSettleDAO.queryByKeys(keys);
            if (calWideSettleVOS.size() > 0) {
                List<CalWideSettleVO> collect = calWideSettleVOS.stream().filter(vo -> !vo.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode())).collect(Collectors.toList());
                if (collect.size() > 0) {
                    throw TwException.error("", "仅支持新建状态删除");
                }
            }
            calWideSettleDAO.deleteSoft(keys);
        }
    }

}
