package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

/**
 * 系统选择项翻译
 *
 * @author
 * @date 2022/11/16
 */
public enum FunctionSelectionEnum {
    //
    SystemCurrCode("SYSTEM_BASIC:CURRENCY", " 币种"),
    SystemLANGUAGE("SYSTEM_BASIC:LANGUAGE", " 语言"),
    SystemCountry("SYSTEM_BASIC:COUNTRY", " 国家"),
    PCD("SYSTEM_BASIC:PCD", "省市区"),
    SystemStatus("SYSTEM_BASIC:STATUS", "系统基础状态"),
    FlowStatus("flow_status", "流程结果状态"),

    ContentType("sys:message_notice:type", "消息类别"),
    ContentBigType("sys:message_notice:big_type", "消息大类"),
    ReleaseSource("sys:message_notice:source", "发布来源"),
    NoticeWay("sys:message_notice:notice_way", "通知方式"),
    TriggerWay("sys:message_notice:trigger_way", "触发方式"),
    MessageTag("sys:message_notice:tags", "消息标签"),
    NoticeScope("sys:message_notice:range", "通知范围"),


    EmployeeResource("org:employee:resource", "资源状态"),

    EmployeeType("org:employee:type", "资源类型"),

    EmployeeInternalType("org:employee:type:internal", "资源内部类型"),

    EmployeeExternalType("org:employee:type:external", "资源外部类型"),

    EmployeeHr("org:employee:personnel", "人事状态"),
    EmployeeCompany("org:manage:company", "公司"),
    EmployeeSex("org:employee:sex", "性别"),
    EmployeeIdType("org:employee:credentials", "证件类型"),
    EmployeeJobs("org:employee:job", "岗位"),

    CrmLeadsStatus("crm:leads_status", "线索状态"),
    CrmLeadsStage("crm:leads_stage", "线索阶段"),
    CrmLeadsSourceType("crm:leads_source_type", "线索来源类型"),
    CrmLeadsCloseReason("crm:leads_close_reason", "线索关闭原因"),
    CrmLeadsDemandProduct("crm:leads_demand_product", "线索需求产品"),
    CrmLeadsBonusDistributeType("crm:leads_bonus_distribute_type", "线索奖金分配类型"),
    CrmLeadsAnnualTurnover("crm:leads_annual_turnover", "线索企业年营业额"),
    CrmLeadsChannel("crm:leads_channel", "线索渠道"),
    CrmLeadsChannelBaidu("crm:leads_channel:SEM_baidu", "线索渠道_SEM百度"),
    CrmLeadsChannel360("crm:leads_channel:SEM_360", "线索渠道_SEM360"),
    CrmLeadsChannelOfflineActivity("crm:leads_channel:offline_activity", "线索渠道_线下活动"),
    CrmLeadsChannelThirdPartyData("crm:leads_channel:thrid_party_data", "线索渠道_三方数据"),


    CrmFollow("crm:follow", "跟进类型"),
    CrmFollowMethod("crm:follow_method", "线索跟进类型"),


    CrmCustomerIndustry("crm:leads_customer_industry", "客户行业"),
    CrmCustomerGrade("crm:customer_grade", "客户级别"),
    CrmCustomerSource("crm:customer_source", "客户来源"),
    CrmCustomerScale("crm:customer_scale", "客户公司规模"),
    CrmCustomerRegion("crm:customer_region", "客户区域"),

    // 客户经营
    CRM_CUST_OPER_TYPE("crm:cust_oper:type", "类型"),


    CrmDistributeReceiveRule("crm:offshoer_distribute_receive_rule", "近海分配领取规则"),
    CrmOffshoreRuleRegain("crm:offshore_rule_regain", "线索收回触发方式"),
    CrmPotentialCustomerStatus("crm:potential_customer_status", "潜在客户状态"),

    CrmPlanDetailType("crm:market_plan:detail_type", "市场计划明细类型"),
    CrmActDynamicType("crm:follow:activity", "市场活动跟进类型"),
    CrmCustRegion("crm:customer_region", " 客户区域"),
    CrmCustProp("crm:company_nature", " 客户性质"),
    CrmProbability("crm:oppo:trans_proba", " 成单概率"),
    CrmSalePhase("crm:oppo:sale_stage", " 销售阶段"),
    CrmOppoLevel("crm:oppo:level", " 商机级别"),
    CrmOppoDifficult("crm:oppo:difficulty_level", " 难度级别"),
    CrmOppoImportance("crm:oppo:Importance", " 重要度级别"),
    CrmOppoCloseReson("crm:closereason:oppo", "商机关闭原因"),
    CrmOppoLoseReson("crm:oppo:lose_reason", "商机丢失原因"),
    CrmOppoRoleType("crm:oppo:role_type", "商机角色类型"),
    CrmOppoStandpoint("crm:oppo:stakeholder", "商机干系人立场"),
    AbAddressType("prd:ab:addr_type", "地址类型表"),
    AbTAX_RATE("TAX_RATE", "税率"),
    AbINV_TYPE("prd:ab:inv_type", "发票类型"),
    AbTYPE("prd:ab:type", "地址簿类型"),
    AbRelate("prd:ab:relate", "相关主档"),
    AbAccount_type("prd:ab:account_type", "账户类型"),
    AbContacts_type("prd:ab:contacts_type", "联系人类型"),

    OrgEmployeeSpecialtyLevel("org:employee:specialtylevel", "专业级别"),
    OrgEmployeeWorkLevel("org:employee:worklevel", "级别"),
    OrgEmployeeSequence("org:employee:workgenre", "类别"),
    OrgEmployeeType("org:employee:worktype", "工种"),
    CrmPeople("crm:people", "人脉"),
    CrmPeopleEducate("crm:people:educate", "学历"),

    VacationType("org:vacation_type", "请假类型"),

    /**
     * 销售合同开始
     */
    SaleConPlatType("salecon:plat_type", "平台合同类型"),
    SaleConStatus("salecon:status", "合同状态"),
    SaleConSourceType("salecon:source_type", "来源类型"),
    SaleConPriceLevel("salecon:price_level", "合同价格评级"),
    //销售小类
    ImpServiceCore("con:sales_class:imp_service_core", "实施服务（核心业务）"),
    PeopleDayService("con:sales_class:people_day_service", "人天服务"),
    OperServiceCore("con:sales_class:oper_service_core", "运维服务（核心业务）"),
    SoftwareHardwareTrade("con:sales_class:software_hardware_trade", "软/硬件贸易（非核心业务）"),
    SoftwareTradeCore("con:sales_class:software_trade_core", "软件贸易（核心业务）"),
    DevelopSoftware("con:sales_class:develop_software", "自研软件"),
    SoftwareMACore("con:sales_class:software_MA_core", "软件&MA（核心业务）"),
    ServiceTradeCore("con:sales_class:service_trade_core", "服务贸易（核心业务）"),
    ConsultingCore("con:sales_class:consulting_core", "咨询业务（核心业务）"),
    DSCore("con:sales_class:DS_core", "开发&服务（核心业务）-暂停使用"),
    ServiceTrade("con:sales_class:service_trade", "服务贸易（非核心业务）-暂停使用"),
    HardwareTradeCore("con:sales_class:hardware_trade_core", "硬件贸易（核心业务）-暂停使用"),
    CloudCore("con:sales_class:cloud_core", "云服务贸易（核心业务）-暂停使用"),
    CloudTrade("con:sales_class:cloud_trade", "云服务贸易（非核心业务）-暂停使用"),
    //采购小类
    DEVELOPMENT("con:purchase_type", "开发＆服务"),
    SOFTWAREMA("con:purchase_type", "软件＆MA"),
    HARDWARE("con:purchase_type", "硬件"),
    IMPLEMENT("con:purchase_type", "实施服务"),
    OPERATIONS("con:purchase_type", "运维服务"),
    SOFTWARE("con:purchase_type", "软件（用于非核心业务）"),
    SYNTHESIS("con:purchase_type", "综合"),
    COOP_TAG("CRM:BUSINESS_PARTNER:COOP_TAG", "合作伙伴标签"),

    /**
     * 销售合同结束
     */

    //行政流程
    RELATED_SIGNET("COM:RELATED_SIGNET", "相关印章"),

    /**
     * 财务
     */
    BUDGET_MODULE_ENABLED("BUDGET:MODULE_ENABLED", "预算启用状态"),

//    // 采购合同产品小类
//    OperationFinancialBudget("purchase:category:operation:financialBudget","财务预算"),
//    OperationTW("purchase:category:operation:tw","TW"),
//    OperationPLM("purchase:category:operation:plm","PLM"),
//    OperationMesScheduling("purchase:category:operation:mesScheduling","MES/APS/排班"),
//    OperationHrperf("purchase:category:operation:hrperf","HR及绩效"),
//    OperationErp("purchase:category:operation:erp","ERP"),
//    OperationBistatement("purchase:category:operation:bistatement","BI&报表"),
//    ImplementFinancialBudget("purchase:category:implement:financialBudget","财务预算"),
//    ImplementOther("purchase:category:implement:other","其他"),
//    ImplementWmstms("purchase:category:implement:wmstms","WMS/TMS"),
//    ImplementTw("purchase:category:implement:tw","TW"),
//    ImplementPlm("purchase:category:implement:plm","PLM"),
//    ImplementMespes("purchase:category:implement:mespes","MES/APS/排班"),
//    ImplementHrPerf("purchase:category:implement:hrPerf","HR及绩效"),
//    ImplementBistatement("purchase:category:implement:bistatement","BI&报表"),
//    ImplementBtb("purchase:category:implement:btb","B2B"),
//    HardwareRetailrms("purchase:category:hardware:retailrms","零售POS/CRM/零售前端/OMS"),
//    HardwareBarcode("purchase:category:hardware:barcode","条码"),
//    HardwareWmstms("purchase:category:hardware:barcode","WMS/TMS"),

    /**
     * Acc模块
     * 1.费用报销
     */
    ACC_REIM_TYPE("ACC:REIM_TYPE", "报销类型"),   // 个人报销/一般日常报销等
    ACC_PAY_MODE("ACC:PAY_MODE", "支付方式"),
    ACC_REIM_PROC_KEY("ACC:REIM_PROC_KEY", "费用报销流程类型"),
    ACC_REIM_STATUS("ACC:REIM_STATUS", "报销单据状态"),


    /**
     * 付款申请单
     */
    PAYMENT_APPLY_TYPE("purchase:payment_type", "付款申请单类型"),

    ASSOCIATION_DOC_TYPE("purchase:doc_type", "关联单据类型"),

    PAYMENT_APPLY_STATUS("purchase:payment_status", "付款申请单类型"),

    // 外部项目预算变更超出风暴区比例
    PMS_BUDGET_CHANGE_EQVA_UP_PERCENT("PMS:BUDGET_CHANGE_EQVA:UP_PERCENT","外部项目当量预算变更超出风暴区比例"),
    // 外部项目金额预算变更超出比例
    PMS_BUDGET_CHANGE_AMT_UP_PERCENT("PMS:BUDGET_CHANGE_AMT:UP_PERCENT","外部项目金额预算变更超出比例"),
    //资源规划角色
    PMS_RESOURCE_PLAN_ROLE("PMS:RESOURCE_PLAN:ROLE", "资源规划角色"),
    // 销售合同-T&M-合同服务价格
    Settlement_Method("settlement_method", "结算方式"),
    Settlement_Period("settlement_period", "结算周期"),
    ACOUNT_SUBJECT("JDE:ACOUNT_SUBJECT","JDE银行账号科目映射"),
    ;
    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    FunctionSelectionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
