package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureDVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityMeasureDDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMeasureDRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 商机成单率计算指标详情
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityMeasureDDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityMeasureDRepo repo;
    private final QCrmOpportunityMeasureDDO qdo = QCrmOpportunityMeasureDDO.crmOpportunityMeasureDDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityMeasureDVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CrmOpportunityMeasureDVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 指标类型
                qdo.indicatorType,
                // 计算指标主表id
                qdo.measureId,
                // 字段选项value
                qdo.fieldOptionValue,
                qdo.fieldOptionValueDesc,
                // 数值区间min
                qdo.numericalValueMin,
                // 数值区间max
                qdo.numericalValueMax,
                // 对应分值
                qdo.score
        )).from(qdo);
    }


    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CrmOpportunityMeasureDVO queryByKey(Long id) {
        JPAQuery<CrmOpportunityMeasureDVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    public List<CrmOpportunityMeasureDVO> queryAll() {
        JPAQuery<CrmOpportunityMeasureDVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据计算指标主表id进行删除
     *
     * @param measureIds 计算指标ids
     * @return 删除的条数
     */
    public Long deleteSoftByMeasureId(List<Long> measureIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.measureId.in(measureIds));
        return update.execute();
    }

    /**
     * 根据id进行逻辑删除
     * @param ids ids
     * @return 删除条数
     */
    public Long deleteSoft(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(ids));
        return update.execute();
    }
}

