package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
* 客户经营-企业基本信息
*
* @author duwh
* @date 2022-12-02
*/
@Entity
@Table(name = "crm_customer_operation_enterprise_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_enterprise_info", comment = "客户经营-企业基本信息")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerOperationEnterpriseInfoDO extends BaseModel  {

    /** 客户经营主键 */
    @Comment("客户经营主键")
    @Column()
    private Long operId;
    /** 启信宝id */
    @Comment("启信宝id")
    @Column()
    private String idQxb;
    /** 企业名称（国家公示) */
    @Comment("企业名称（国家公示)")
    @Column()
    private String name;
    /** formatName */
    @Comment("formatName")
    @Column()
    private String formatName;
    /** 企业类型 */
    @Comment("企业类型")
    @Column()
    private String econKind;
    /** 企业类型代码 */
    @Comment("企业类型代码")
    @Column()
    private String econKindCode;
    /** 注册资本（金额数字+1个空格+万+货币单位） */
    @Comment("注册资本（金额数字+1个空格+万+货币单位）")
    @Column()
    private String registCapi;
    /** currencyUnit */
    @Comment("currencyUnit")
    @Column()
    private String currencyUnit;
    /** typeNew */
    @Comment("typeNew")
    @Column()
    private String typeNew;
    /** 历史名字 */
    @Comment("历史名字")
    @Column()
    private String historyNamesStr;
    /** 地址 */
    @Comment("地址")
    @Column()
    private String address;
    /** 企业注册号 */
    @Comment("企业注册号")
    @Column()
    private String regNo;
    /** 经营范围 */
    @Comment("经营范围")
    @Column()
    private String scope;
    /** 营业开始日期 */
    @Comment("营业开始日期")
    @Column()
    private String termStart;
    /** 营业结束日期 */
    @Comment("营业结束日期")
    @Column()
    private String termEnd;
    /** 所属工商局 */
    @Comment("所属工商局")
    @Column()
    private String belongOrg;
    /** 企业法定代表人 */
    @Comment("企业法定代表人")
    @Column()
    private String operName;
    /** 公司代表人职务 */
    @Comment("公司代表人职务")
    @Column()
    private String title;
    /** 成立日期 */
    @Comment("成立日期")
    @Column()
    private String startDate;
    /** 注销日期 */
    @Comment("注销日期")
    @Column()
    private String endDate;
    /** 核准日期 */
    @Comment("核准日期")
    @Column()
    private String checkDate;
    /** 经营状态（旧字段，不建议使用） */
    @Comment("经营状态（旧字段，不建议使用）")
    @Column()
    private String status;
    /** newStatus */
    @Comment("newStatus")
    @Column()
    private String newStatus;
    /** 组织机构号 */
    @Comment("组织机构号")
    @Column()
    private String orgNo;
    /** 统一社会信用代码 */
    @Comment("统一社会信用代码")
    @Column()
    private String creditNo;
    /** 地区代码 */
    @Comment("地区代码")
    @Column()
    private String districtCode;
    /** 实缴资本 */
    @Comment("实缴资本")
    @Column()
    private String actualCapi;
    /** 企业二级分类 */
    @Comment("企业二级分类")
    @Column()
    private String categoryNew;
    /** 四级行业 */
    @Comment("四级行业")
    @Column()
    private String domain;
    /** 1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业； */
    @Comment("1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业；")
    @Column()
    private String tagsStr;
    /** revokeReason */
    @Comment("revokeReason")
    @Column()
    private String revokeReason;
    /** revokeDate */
    @Comment("revokeDate")
    @Column()
    private String revokeDate;


    /**
     * 1.16 企业简介
     * 企业简介信息
     */
    @Comment("1.16 企业简介")
    @Column()
    private String enterpriseDesc;

    public void copy(CrmCustomerOperationEnterpriseInfoDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
