package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreAdminPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOffshoreService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreAdminVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreMembersVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 16:32
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOffshoreServiceImpl implements CrmOffshoreService {
    private final CrmOffshoreDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ExcelUtil excelUtil;

    //@Transactional
    @Override
    public CrmOffshoreVO saveOne(CrmOffshorePayload payload) {
        CrmOffshoreDO ado = CrmOffshoreConvert.INSTANCE.toDo(payload);
        try{
            if(payload.getId()!=null){
                int num = dao.countLeads(ado.getId());
                ado.setLeadsNum(num);
            }
            ado = dao.save(ado);
        }catch (Exception e){
            throw TwException.error("","近海名称不能重复,已存在名为\""+payload.getOffshoreName()+"\"的近海！");
        }

        return CrmOffshoreConvert.INSTANCE.toVo(ado);
    }

    @Override
    public void dynamicUpdate(CrmOffshorePayload payload) {
        //执行更新
        dao.updateByKeyDynamic(payload);
    }


    @Override
    @Transactional(readOnly = true)
    public List<CrmOffshoreListVO> queryList(CrmOffshoreQuery query) {
        query.setOffshoreNameNotEqual("无近海");
        Specification<CrmOffshoreDO> spec = dao.getSpec(query);
        List<CrmOffshoreDO> all = dao.findAll(spec);
        return all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
    }


    @Transactional(readOnly = true)
    @Override
    public PagingVO paging(CrmOffshoreQuery query) {
        Specification<CrmOffshoreDO> spec = dao.getSpec(query);
        Page<CrmOffshoreDO> all = dao.findAll(spec, query.getPageRequest());
        List<CrmOffshoreDO> content = all.getContent();
        List<CrmOffshoreListVO> collect = content.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
        transferList(collect);
        //类型转化
        all.getTotalPages();
        PagingVO pagingVO= new PagingVO<>(all.getTotalElements(),collect);
        return pagingVO;
    }


    @Transactional
    @Override
    public CrmOffshoreVO queryDetail(Long id) {
        CrmOffshoreDO detail=dao.queryById(id);
        return CrmOffshoreConvert.INSTANCE.toVo(detail);
    }



    private void transferList(List<CrmOffshoreListVO> list) {
        for (CrmOffshoreListVO vo : list) {
            List<CrmOffshoreAdminVO> offshoreAdmins = vo.getOffshoreAdmins();
//            vo.setOffshoreAdminName(cacheUtil.getUserName(vo.getOffshoreAdminId()));

            List<CrmOffshoreMembersVO> offshoreMembers = vo.getOffshoreMembers();

            offshoreMembers.stream().map(e->{
                e.setUserName(cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
            offshoreAdmins.stream().map(e->{
                e.setUserName(cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
        }
    }




    @Override
    @Transactional
    public void importOffshores(MultipartFile file) {

        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("近海数据");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
            List<CrmOffshoreMembersPayload> membersPayloads = new ArrayList<>();
            List<CrmOffshoreAdminPayload> adminPayloads = new ArrayList<>();

            offshorePayload.setOffshoreName(ExcelUtil.getCellFormatValue(row.getCell(1)));
            String offshoreMembersStr = ExcelUtil.getCellFormatValue(row.getCell(2));
            String offshoreAdminsStr = ExcelUtil.getCellFormatValue(row.getCell(3));

            if(StringUtils.hasText(offshoreMembersStr)){
                String[] members = offshoreMembersStr.split(",");
                List<Long> collect = Arrays.stream(members).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> memberUserIds = employeeDAO.queryUserIdByEmployeeNo(collect);
                membersPayloads=memberUserIds.stream().map(e->{
                    CrmOffshoreMembersPayload membersPayload= new CrmOffshoreMembersPayload();
                    membersPayload.setUserId(e);
                    return membersPayload;
                }).collect(Collectors.toList());
                offshorePayload.setOffshoreMembers(membersPayloads);
            }
            if(StringUtils.hasText(offshoreAdminsStr)){
                String[] admins = offshoreAdminsStr.split(",");
                List<Long> collect = Arrays.stream(admins).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> adminUserIds = employeeDAO.queryUserIdByEmployeeNo(collect);
                adminPayloads=adminUserIds.stream().map(e->{
                    CrmOffshoreAdminPayload adminPayload= new CrmOffshoreAdminPayload();
                    adminPayload.setUserId(e);
                    return adminPayload;
                }).collect(Collectors.toList());
                offshorePayload.setOffshoreAdmins(adminPayloads);
            }
            saveOne(offshorePayload);
        }
    }

    @Override
    public void downloadOffshores(HttpServletResponse response, CrmOffshoreQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/offshoreBatch.xlsx");
        PagingVO<CrmOffshoreListVO> paging = paging(query);
        List<CrmOffshoreListVO> records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("近海数据");

            //  excelUtil.generateRangeList(batchProjectSheet, 2, 2, "活动类型", 2, "A"); // 最终客户 数据验证

            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmOffshoreListVO dataPayload : records) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getOffshoreName());// 近海名称
                    excelUtil.setCellValue(row, 3, dataPayload.getLeadsNum());// 线索个数
                    List<CrmOffshoreMembersVO> offshoreMembers = dataPayload.getOffshoreMembers();
                    List<CrmOffshoreAdminVO> offshoreAdmins = dataPayload.getOffshoreAdmins();
                    List<String> collect = offshoreMembers.stream().map(e -> {
                        Long userId = e.getUserId();
                        return cacheUtil.getUserName(userId);
                    }).collect(Collectors.toList());
                    String members = String.join(",", collect);
                    excelUtil.setCellValue(row, 2, members);// 近海成员

                    List<String> adminList = offshoreAdmins.stream().map(e -> {
                        Long userId = e.getUserId();
                        return cacheUtil.getUserName(userId);
                    }).collect(Collectors.toList());
                    String admins = String.join(",", collect);
                    excelUtil.setCellValue(row, 3, admins);// 近海管理员
                    nextRow++;
                }
            }

            String fileName = "近海数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
