package com.elitesland.tw.tw5.server.prd.file.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

/**
 * 附件 文件夹
 *
 * @author duwh
 * @date 2022/09/20
 */
@Entity
@Table(name = "prd_file_folder")
@org.hibernate.annotations.Table(appliesTo = "prd_file_folder", comment = "附件-文件夹")
@Getter
@Setter
@ToString
@Where(clause = "delete_flag = 0")
public class PrdFileFolderDO extends BaseModel implements Serializable {

    @Serial
    private static final long serialVersionUID = -8230836710341227004L;

    /**
     * 文件夹名称
     */
    @Comment("文件夹名称")
    @Column()
    private String name;

    /**
     * 父主键
     */
    @Comment("父主键")
    @Column()
    private Long parentId;


    public void copy(PrdFileFolderDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
