package com.elitesland.tw.tw5.server.prd.humanresources.basebu.callback;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseRegionChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseRegionChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseRegionChangeVO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;


@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "BASE_REGION_CHANGE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PrdBaseRegionChangeCallback implements WorkflowCallBack {


    public final PrdBaseRegionChangeService prdBaseRegionChangeService;

    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {

        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank(businessKey)) {
            throw new BusinessException("获取的businessKey为空");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        Long id = Long.valueOf(businessKey);
        PrdBaseRegionChangeVO prdBaseRegionChangeVO = prdBaseRegionChangeService.get(id);

        PrdBaseRegionChangePayload prdBaseRegionChangePayload = new PrdBaseRegionChangePayload();
        prdBaseRegionChangePayload.setId(id);
        if (prdBaseRegionChangeVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"激活",流程状态改为未提交
                    prdBaseRegionChangePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）

                case INVALID://仅删除流程
                    prdBaseRegionChangePayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    //删除当前版本草稿状态的changeLog
//                    changeService.deleteCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    prdBaseRegionChangePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    prdBaseRegionChangePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdBaseRegionChangePayload.setApprovedTime(LocalDateTime.now());
                    prdBaseRegionChangePayload.setActiveDate(LocalDate.now());
                    // 激活当前版本草稿状态的所有changeLog,合并当前及上一个版本
//                    Map<String, Object> stringObjectMap = changeService.activeCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
//                    PersonResPayload newPayload = JSON.parseObject(stringObjectMap.toString(), PersonResPayload.class);
//                    prdOrgEmployeeService.updateNew(newPayload);
                    // 更新资源库中的 生效日期 base地信息
                    PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
                    prdOrgEmployeePayload.setExtString5(prdBaseRegionChangeVO.getNewBaseRegion());
                    prdOrgEmployeePayload.setUserId(prdBaseRegionChangeVO.getApplyUserId());
                    prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);

                    break;
                case APPROVING:
                    prdBaseRegionChangePayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
            prdBaseRegionChangeService.updateByCondition(prdBaseRegionChangePayload);
        }
        return WorkflowResult.success(null);
    }


}
