package com.elitesland.tw.tw5.server.prd.humanresources.basebu.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseRegionChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBaseRegionChangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseRegionChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseRegionChangeVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao.PrdBaseRegionChangeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBaseRegionChangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.repo.PrdBaseRegionChangeRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdBaseRegionChangeConvert;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @author : WWW
 * @date : 2023-11-1
 * @desc : base地与社保地变更申请Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdBaseRegionChangeServiceImpl implements PrdBaseRegionChangeService {


    private final PrdBaseRegionChangeDao prdBaseRegionChangeDao;

    private final PrdBaseRegionChangeRepo prdBaseRegionChangeRepo;

    private final WorkflowUtil workflowUtil;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final CacheUtil cacheUtil;

    private final PrdMessageConfigService messageConfigService;

    private final PrdSystemRoleService roleService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdBaseRegionChangeVO save(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {
//        prdBaseRegionChangePayload.setApplyState();
        checkData(prdBaseRegionChangePayload);
        // 查询该用户下是否有审批中的该流程
        PrdBaseRegionChangeQuery prdBaseRegionChangeQuery = new PrdBaseRegionChangeQuery();
        prdBaseRegionChangeQuery.setApplyUserId(prdBaseRegionChangePayload.getApplyUserId());
        prdBaseRegionChangeQuery.setProcInstStatus(ProcInstStatus.APPROVING);
        Long count = prdBaseRegionChangeDao.count(prdBaseRegionChangeQuery);
        if (count > 0) {
            throw new BusinessException(HrBaseEnum.FLOW_REPEAT_ERR.getDesc());
        }
        prdBaseRegionChangePayload.setSubmitTime(LocalDateTime.now());
        PrdBaseRegionChangeDO prdBaseRegionChangeDO = new PrdBaseRegionChangeDO();
        prdBaseRegionChangeDO = PrdBaseRegionChangeConvert.INSTANCE.p2d(prdBaseRegionChangePayload);
        PrdBaseRegionChangeDO res = prdBaseRegionChangeRepo.save(prdBaseRegionChangeDO);
        // 开启工作流
        startWorkFlow(res);

        return PrdBaseRegionChangeConvert.INSTANCE.d2v(res);

    }

    public void startWorkFlow(PrdBaseRegionChangeDO res) {
        ProcessInfo processInfo = new ProcessInfo();
        HashMap<String, Object> variables = new HashMap<>();

        // 社保地是否变更
        Boolean isRagionChange = false;
        if (!res.getOldSocialRegion().equals(res.getNewSocialRegion())) {
            isRagionChange = true;
        }
        variables.put("ragionChange", isRagionChange);

        // 平台薪酬负责人 薪酬绩效主管（编码：PLAT_SALARY_MANAGER） 薪酬绩效专员（编码：PLAT_SALARY_SPECIALIST)

        List<Long> xcUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_SALARY_MANAGER.getCode(), RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
        variables.put("Activity_1a4vis6", xcUserIds);
        // BU负责人审批 该登录用户的所在组织的负责人
        // 获取当前登录人所在的组织
        SysOrgBasicDTO org = GlobalUtil.getLoginUser().getOrg();
//        if (null == org) {
//            throw new BusinessException("该用户所在的组织为空");
//        }
        Assert.notNull(res.getBaseBuId(), "baseBuId不能为空");
        // 根据当前组织找组织的负责人
        PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());
        variables.put("Activity_1vt5lvm", List.of(prdOrgOrganizationVO.getManageId()));
        // 平台人事负责人审批 平台人事负责人  角色：HRD（编码：HRD）
        List<Long> pthrUserIds = prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode());
        variables.put("Activity_0l40et8", pthrUserIds);
        // 总部人事专员审批  总部人事专员  角色：员工关系主管,员工关系专员（EMPLOYEE_RELATIONS_SUPERVISOR）
        List<Long> zbhrUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()));
        variables.put("Activity_10xxexy", zbhrUserIds);

        // 发起流程审批
        processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                HrBaseEnum.BASE_REGION_CHANGE.getCode(),
                "G02.Base地与社保公积金缴纳地变更流程-" + cacheUtil.getUserName(res.getApplyUserId()),
                res.getId().toString(),
                variables));

        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();

        // 回写单据的工作流信息
        PrdBaseRegionChangePayload payload = new PrdBaseRegionChangePayload();
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setId(res.getId());
        Long update = prdBaseRegionChangeDao.update(payload);

        // 发通知给人事 平台人力资源总监 平台员工关系主管 平台员工关系专员 平台薪酬绩效主管 平台薪酬绩效专员
        String title = "Base地变更-"+cacheUtil.getUserName(res.getApplyUserId());
        String oldBaseRegion = cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), res.getOldBaseRegion());
        String newBaseRegion = cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), res.getNewBaseRegion());

        String content = "员工"+cacheUtil.getUserName(res.getApplyUserId())+"发起了Base地变更，原Base地:"+oldBaseRegion+"，新Base地为:"+newBaseRegion;
        sendMessage(res.getId(),title,content);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdBaseRegionChangeVO update(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {

        Assert.notNull(prdBaseRegionChangePayload.getId(), "id is null");
        PrdBaseRegionChangeVO res = save(prdBaseRegionChangePayload);
        return res;

    }


    @Override
    public PrdBaseRegionChangeVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdBaseRegionChangeVO res = prdBaseRegionChangeDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdBaseRegionChangeVO> page(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        PagingVO<PrdBaseRegionChangeVO> res = prdBaseRegionChangeDao.page(prdBaseRegionChangeQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdBaseRegionChangeDao.del(ids);
        return res;

    }

    @Override
    public List<PrdBaseRegionChangeVO> getList(PrdBaseRegionChangeQuery prdBaseRegionChangeQuery) {

        List<PrdBaseRegionChangeVO> res = prdBaseRegionChangeDao.getList(prdBaseRegionChangeQuery);
        return res;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {

        Assert.notNull(prdBaseRegionChangePayload.getId());
        Long res = prdBaseRegionChangeDao.update(prdBaseRegionChangePayload);

        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateByBatch(List<PrdBaseRegionChangePayload> prdBaseRegionChangePayload) {
        for (PrdBaseRegionChangePayload payload : prdBaseRegionChangePayload) {
            updateByCondition(payload);
        }
        return true;
    }


    /**
     * 数据校验
     *
     * @param prdBaseRegionChangePayload
     */
    private void checkData(PrdBaseRegionChangePayload prdBaseRegionChangePayload) {

//        if (StringUtils.isBlank(prdBaseRegionChangePayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }

    }

    // 发通知给人事 平台人力资源总监 平台员工关系主管 平台员工关系专员 平台薪酬绩效主管 平台薪酬绩效专员
    public void sendMessage(Long objectId,String messageTitle,String content){
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERM.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERS.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));

        if(!CollectionUtils.isEmpty(list)){
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }
}

