package com.elitesland.tw.tw5.server.prd.humanresources.eval.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置明细表
 */

@Entity
@Table(name = "prd_evaluate_config_dtl")
@org.hibernate.annotations.Table(appliesTo = "prd_evaluate_config_dtl", comment = "评价配置明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdEvaluateConfigDtlDO extends BaseModel {


    /**
     * 配置id
     */
    @Column(name = "config_id", columnDefinition = "bigint(20) comment '配置id'")
    private Long configId;

    /**
     * 评价点id
     */
    @Column(name = "point_id", columnDefinition = "bigint(20) comment '评价点id'")
    private Long pointId;


}

