package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateConfigDtlConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateConfigDtlDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateConfigDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateConfigDtlRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置明细表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdEvaluateConfigDtlServiceImpl implements PrdEvaluateConfigDtlService {


    private final PrdEvaluateConfigDtlDao prdEvaluateConfigDtlDao;

    private final PrdEvaluateConfigDtlRepo prdEvaluateConfigDtlRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateConfigDtlVO save(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload) {

        checkData(prdEvaluateConfigDtlPayload);
        PrdEvaluateConfigDtlDO prdEvaluateConfigDtlDO = new PrdEvaluateConfigDtlDO();
        prdEvaluateConfigDtlDO = PrdEvaluateConfigDtlConvert.INSTANCE.p2d(prdEvaluateConfigDtlPayload);
        PrdEvaluateConfigDtlDO res = prdEvaluateConfigDtlRepo.save(prdEvaluateConfigDtlDO);
        return PrdEvaluateConfigDtlConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateConfigDtlVO update(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload) {

        Assert.notNull(prdEvaluateConfigDtlPayload.getId(), "id is null");
        PrdEvaluateConfigDtlVO res = save(prdEvaluateConfigDtlPayload);
        return res;

    }


    @Override
    public PrdEvaluateConfigDtlVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdEvaluateConfigDtlVO res = prdEvaluateConfigDtlDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdEvaluateConfigDtlVO> page(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        PagingVO<PrdEvaluateConfigDtlVO> res = prdEvaluateConfigDtlDao.page(prdEvaluateConfigDtlQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdEvaluateConfigDtlDao.del(ids);
        return res;

    }

    @Override
    public List<PrdEvaluateConfigDtlVO> getList(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        List<PrdEvaluateConfigDtlVO> res = prdEvaluateConfigDtlDao.getList(prdEvaluateConfigDtlQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdEvaluateConfigDtlPayload
     */
    private void checkData(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload) {

//        if (StringUtils.isBlank(prdEvaluateConfigDtlPayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload) {
        Assert.notNull(prdEvaluateConfigDtlPayload.getId(), "id不能为空");
        Long res = prdEvaluateConfigDtlDao.update(prdEvaluateConfigDtlPayload);
        return res;
    }

    @Override
    @Transactional
    public Long delByConfigId(Long id) {
        Long res = prdEvaluateConfigDtlDao.delByConfigId(id);
        return res;
    }


}

