package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamPointVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;
import java.util.List;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核点
 */

@RestController
@RequestMapping("/api/prdPerformanceExamPoint")
@RequiredArgsConstructor
@Api(value = "绩效考核点", tags = {"绩效考核点"})
public class PrdPerformanceExamPointController{
    
    private final PrdPerformanceExamPointService prdPerformanceExamPointService;
    
    
    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核点")
    public TwOutputUtil<PrdPerformanceExamPointVO> get(@PathVariable Long id) {
    
        PrdPerformanceExamPointVO res = prdPerformanceExamPointService.get(id);
        return TwOutputUtil.ok(res);
        
    }
    
    
    @PostMapping("save")
    @ApiOperation("新增-绩效考核点")
    public TwOutputUtil<Long> save(@RequestBody PrdPerformanceExamPointPayload prdPerformanceExamPointPayload) {
        
        PrdPerformanceExamPointVO res = prdPerformanceExamPointService.save(prdPerformanceExamPointPayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @PostMapping("update")
    @ApiOperation("修改-绩效考核点")
    public TwOutputUtil<Long> update(@RequestBody PrdPerformanceExamPointPayload prdPerformanceExamPointPayload) {
        
        PrdPerformanceExamPointVO res = prdPerformanceExamPointService.update(prdPerformanceExamPointPayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核点")
    public TwOutputUtil<Long> del(Long[] ids) {
    
        Long res = prdPerformanceExamPointService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);
        
    }
    
    
    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核点")
    public TwOutputUtil<PagingVO<PrdPerformanceExamPointVO>> page(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {
        
        PagingVO<PrdPerformanceExamPointVO> res = prdPerformanceExamPointService.page(prdPerformanceExamPointQuery);
        return TwOutputUtil.ok(res);
        
    }
    
    
    
}

