package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity
@Table(name = "person_cert", indexes = {
        @Index(name = "person_index", columnList = "person_id"),
})
@org.hibernate.annotations.Table(appliesTo = "person_cert", comment = "人员-资质证书表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PersonCertDO extends BaseModel {

    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("证书名称")
    @Column(name = "cert_name")
    private String certName;

    @Comment("证书号码")
    @Column(name = "cert_no")
    private String certNo;

    @Comment("证书状态")
    @Column(name = "cert_status")
    private String certStatus;

    @Comment("获得时间")
    @Column(name = "obtain_date")
    private String obtainDate;

    @Comment("有效期类型")
    @Column(name = "valid_type")
    private String validType;

    @Comment("有效期月数")
    @Column(name = "valid_months")
    private Long validMonths;

    @Comment("颁发机构")
    @Column(name = "release_by")
    private String releaseBy;

    @Comment("上次认证时间")
    @Column(name = "last_renew_date")
    private String lastRenewDate;

    @Comment("分数")
    @Column(name = "score")
    private Long score;

    @Comment("等级")
    @Column(name = "grade")
    private String grade;

    @Comment("证书说明")
    @Column(name = "cert_desc")
    private String certDesc;

    @Comment("附件url")
    @Column(name = "cert_codes")
    private String certCodes;

    @Comment("来源类型")
    @Column(name = "source_type")
    private String sourceType;
}
