package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonEduExperiencePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonEduExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonEduExperienceVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonEduExperienceConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonEduExperienceDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonEduExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonEduExperienceRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class PersonEduExperienceServiceImpl implements PersonEduExperienceService {

    private final PersonEduExperienceRepo personEduExperienceRepo;

    private final PersonEduExperienceDAO personEduExperienceDAO;

    @Override
    public void save(PersonEduExperiencePayload save) {
        PersonEduExperienceDO personEduExperienceDO = PersonEduExperienceConvert.INSTANCE.toDo(save);
        personEduExperienceRepo.save(personEduExperienceDO);
    }

    @Override
    public List<PersonEduExperienceVO> findAllByPersonId(Long personId) {
        List<PersonEduExperienceDO> personEduExperienceDOList = personEduExperienceRepo.findAllByPersonId(personId);
        return PersonEduExperienceConvert.INSTANCE.toVos(personEduExperienceDOList);
    }

    @Override
    public void saveAll(List<PersonEduExperienceVO> eduExperienceVOList, Long personId) {
        if (eduExperienceVOList != null) {
            if (eduExperienceVOList.size() == 0) {
                personEduExperienceDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonEduExperienceVO personEduExperienceVO : eduExperienceVOList) {
                    if (personEduExperienceVO.getPersonId() == null) {
                        personEduExperienceVO.setPersonId(personId);
                    }
                }
                personEduExperienceDAO.saveAll(PersonEduExperienceConvert.INSTANCE.toDos(eduExperienceVOList));
            }
        }
    }

    @Override
    public void deleteAllByPersonId(Long personId) {
        personEduExperienceDAO.deleteAllByPersonId(personId);
    }
}
