package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResEntryExitLogPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResEntryExitLogQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEntryExitLogService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEntryExitLogVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.ResEntryExitLogConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.ResEntryExitLogDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.ResEntryExitLogDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class ResEntryExitLogServiceImpl implements ResEntryExitLogService {

    private final ResEntryExitLogDAO resEntryExitLogDAO;

    private final CacheUtil cacheUtil;


    @Override
    public PagingVO<ResEntryExitLogVO> queryPaging(ResEntryExitLogQuery query) {
        PagingVO<ResEntryExitLogVO> entryExitLogVOPagingVO = resEntryExitLogDAO.queryPaging(query);
        List<ResEntryExitLogVO> vos = entryExitLogVOPagingVO.getRecords();
        for (ResEntryExitLogVO vo : vos) {
            vo.setCompanyName(cacheUtil.getCompanyNameByBookId(vo.getBookId()));
        }
        entryExitLogVOPagingVO.setRecords(vos);
        return entryExitLogVOPagingVO;
    }

    @Override
    public void save(ResEntryExitLogPayload payload) {
        ResEntryExitLogDO resEntryExitLogDO = ResEntryExitLogConvert.INSTANCE.toDo(payload);
        resEntryExitLogDAO.save(resEntryExitLogDO);
    }

}
