package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author sunxw
 * @description
 * @Date 2023/12/6
 */
@Entity
@Table(name = "inv_invoice_doc_ref", indexes = {
        @Index(name = "idx_inv_id", columnList = "inv_id"),
        @Index(name = "idx_doc_id", columnList = "doc_id"),
        @Index(name = "idx_doc_dtl_id", columnList = "doc_dtl_id"),
})
@org.hibernate.annotations.Table(appliesTo = "inv_invoice_doc_ref", comment = "发票单据关联表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvInvoiceDocRefDO extends BaseModel implements Serializable {

    @Comment("发票ID")
    @Column(name = "inv_id")
    private Long invId;

    @Comment("关联单据类型 EXPENSE-报销")
    @Column()
    private String docType;

    @Comment("关联单据ID")
    @Column(name = "doc_id")
    private Long docId;

    @Comment("关联单据明细ID")
    @Column(name = "doc_dtl_id")
    private Long docDtlId;

    public void copy(InvInvoiceDocRefDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
