package com.elitesland.tw.tw5.server.prd.inv.repo;


import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 发票主表
 *
 * @author zoey
 * @date 2023-12-05
 */
public interface InvInvoiceRepo extends JpaRepository<InvInvoiceDO, Long>, JpaSpecificationExecutor<InvInvoiceDO> {

    @Query("select max(createTime) from InvInvoiceDO where deleteFlag = 0  and createUserId =?1")
    LocalDateTime getLastCreateTime(Long userId);

    @Query("select id from InvInvoiceDO where deleteFlag = 0  and invoiceNo = ?1 and (invoiceCode=?2 or invoiceCode is null)")
    List<Long> existsItem(String invoiceNo, String invoiceCode);

    @Query("select min(createTime) from InvInvoiceDO where deleteFlag = 0  and createUserId =?1 and inspectionStatus=2")
    LocalDateTime getFirstCheckFailTime(Long userId);
}
