package com.elitesland.tw.tw5.server.prd.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.MonthlyTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.PmsTimesheetExcel;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetExcel;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySelectTypeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsTimesheetProjectVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/my/timesheet")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.PMS_TIME_SHEET)
public class PmsTimesheetController {

    private final PmsTimesheetService pmsTimesheetService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final UdcUtil udcUtil;
    private final PmsProjectService pmsProjectService;

    @GetMapping("/listProject")
    @UdcNameClass
    @ApiOperation("根据项目成员查询所有项目")
    public TwOutputUtil<List<PmsTimesheetProjectVO>> listProject(Long userId, Boolean selectAll) {
        return TwOutputUtil.ok(pmsTimesheetService.listProject(userId, selectAll));
    }

    /**
     * 批量插入 传入id就是编辑
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/batchInsert")
    public TwOutputUtil batchInsert(@RequestBody TimesheetListPayload payload) {
        return TwOutputUtil.ok(pmsTimesheetService.batchInsert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetPayload payload) {
        return TwOutputUtil.ok(pmsTimesheetService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsTimesheetService.queryByKey(key));
    }

    /**
     * 分页
     * 默认按创建时间倒序，前端可通过参数改变排序
     * 管理员、TIME_SHEET_MANAGER查看所有
     * 普通用户只能查看自己填写的
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/paging")
    @UdcNameClass
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.TIME_SHEET_PAGE, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<TimesheetVO>> paging(@RequestBody TimesheetQuery query) {
//        pmsTimesheetService.getPermissionParams(query);
        final PagingVO<TimesheetVO> paging1 = pmsTimesheetService.pagingPermission(query);
        return TwOutputUtil.ok(paging1);
    }

    /**
     * 查询列表
     * 默认按创建时间倒序，前端可通过参数改变排序
     * 管理员、TIME_SHEET_MANAGER查看所有
     * 普通用户只能查看自己填写的
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    public TwOutputUtil<List<TimesheetVO>> queryList(TimesheetQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        //final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        //if (isSystemAdmin) {
        //
        //} else {
        //    // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
        //    List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
        //    if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
        //
        //    } else {
        // 数据权限 只能查自己的
        query.setTsUserId(loginUserId);
        //    }
        //}
        return TwOutputUtil.ok(pmsTimesheetService.queryList(query));
    }

    /**
     * 差旅报销查询工时
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/accReimTimesheetOverview")
    @UdcNameClass
    public TwOutputUtil accReimTimesheetOverview(TimesheetQuery query) {

        return TwOutputUtil.ok(pmsTimesheetService.getAccReimTimesheetOverview(query));
    }

    /**
     * 工时列表变更审批人
     *
     * @param keys
     * @param apprUserId
     * @return
     */
    @PatchMapping("/updateApproving/{apprUserId}")
    public TwOutputUtil updateApprovingUser(@RequestBody List<Long> keys, @PathVariable Long apprUserId) {
        pmsTimesheetService.updateApprovingUser(keys, apprUserId);
        return TwOutputUtil.ok();
    }

    /**
     *
     */
    @GetMapping("/getTimesheetOverview")
    @UdcNameClass
    public TwOutputUtil getTimesheetOverview(TimesheetQuery query) {
        return TwOutputUtil.ok(pmsTimesheetService.getTimesheetOverview(query));
    }

    /**
     * 是否提示
     */
    @GetMapping("/getTimesheetRemind")
    @UdcNameClass
    public TwOutputUtil getTimesheetRemind(TimesheetQuery query) {
        return TwOutputUtil.ok(pmsTimesheetService.getTimesheetRemind(query));
    }


    /**
     * 待审批工时条数
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/approving/count")
    public TwOutputUtil approvingCount(TimesheetQuery query) {
        //if (!StringUtils.hasText(query.getTsStatus())) {
        //    query.setTsStatus("APPROVING");
        //}
        query.setApprUserId(GlobalUtil.getLoginUserId());
        long total = pmsTimesheetService.count(query);
        return TwOutputUtil.ok(total);
    }

    /**
     * 待审批列表-分页
     * 默认按创建时间倒序，前端可通过参数改变排序
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/approving/paging")
    @UdcNameClass
    public TwOutputUtil approvingPaging(TimesheetQuery query) {
        query.setTimesheetIdV4IsNull(true);
        //权限处理
        permissionOpertion(query);

        OrderItem orderItem = OrderItem.desc("workDate");
        query.setOrders(Arrays.asList(orderItem));
        return TwOutputUtil.ok(pmsTimesheetService.paging(query));
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void permissionOpertion(TimesheetQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {

        } else {
            // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
            if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {

            } else {
                // 数据权限 只能查审批人是自己的
                query.setApprUserId(loginUserId);
                if (query.getProjId() != null) {
                    PmsProjectVO pmsProjectVO = pmsProjectService.queryByKeySimple(query.getProjId());
                    //如果是项目经理，能查看项目下的所有任务包
                    if (pmsProjectVO != null && pmsProjectVO.getPmResId().equals(loginUserId)) {
                        query.setApprUserId(null);
                    }
                }
            }
        }
    }

    /**
     * 分组审批分页列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/approving/pagingGroup")
    @UdcNameClass
    public TwOutputUtil approvingPagingGroup(TimesheetQuery query) {
        query.setTimesheetIdV4IsNull(true);
        //权限处理
        permissionOpertion(query);

        return TwOutputUtil.ok(pmsTimesheetService.pagingGroup(query));
    }

    /**
     * 详细审批导出
     *
     * @param query    查询
     * @param response 响应
     * @throws IOException ioexception
     */
    @GetMapping("/approving/exportList")
    public void exportList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "工作日志审批";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        approvingDataFilterQuery(query);
        List<TimesheetVO> list = pmsTimesheetService.queryList(query);
        if (list.size() > 50000) {
            throw TwException.error("500", "导出数据过大，请分批操作，目前导出数量：" + list.size());
        }
        List<PmsTimesheetExcel> excelList = TimesheetConvert.INSTANCE.voPmsListVoExcelExport(list);
        excelList = udcUtil.translateList(excelList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmCustomerOperationVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, TimesheetExcel.class, null);
        //写入
        sheet.doWrite(excelList);

    }

    /**
     * 分组审批列表导出
     *
     * @param query    查询
     * @param response 响应
     * @return {@link TwOutputUtil}
     * @throws IOException ioexception
     */
    @GetMapping("/approving/exportListGroup")
    //@UdcNameClass
    public void exportListGroup(TimesheetQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "工作日志审批";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        approvingDataFilterQuery(query);
        List<TimesheetVO> list = pmsTimesheetService.listGroup(query);
        List<PmsTimesheetExcel> excelList = TimesheetConvert.INSTANCE.voPmsListVoExcelExport(list);
        excelList = udcUtil.translateList(excelList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmCustomerOperationVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, CrmCustomerOperationExcelExport.class, null);
        //写入
        sheet.doWrite(excelList);
    }

    /**
     * 审批excel导出数据封装
     *
     * @param query 查询
     */
    private void approvingDataFilterQuery(TimesheetQuery query) {
//        if (CollectionUtils.isEmpty(query.getWorkDate())) {
//            // 限定只能查2个月内
//            throw TwException.error("", "请选择时间范围");
//            //return;
//        }
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {

        } else {
            // 判断当前登录人是否是系统管理员or 拥有角色【工时审批管理员	TIME_SHEET_APPROVAL_MANAGER】
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
            if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {

            } else {
                // 数据权限 只能查审批人是自己的
                query.setApprUserId(loginUserId);
            }
        }
    }

    /**
     * 撤回 只有审批中的单据才允许撤回
     *
     * @param keys 主键集合
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/revoked")
    public TwOutputUtil revoked(Long[] keys) {
        pmsTimesheetService.revoked(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 运维管理员 - 高级撤回 审批通过的可以撤回
     *
     * @param keys 主键集合 APPROVED_TO_CREATE
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approved/revoked")
    public TwOutputUtil approvedRevoked(Long[] keys) {
        pmsTimesheetService.approvedRevoked(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 审批通过 只有审批中的单据才允许审批通过
     *
     * @param keys 主键集合
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/approved")
    public TwOutputUtil toApproved(Long[] keys) {
        pmsTimesheetService.toApproved(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 审批拒绝 只有审批中的单据才允许审批拒绝
     *
     * @param keys       主键集合
     * @param apprResult 拒绝原因
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/rejected")
    public TwOutputUtil rejected(Long[] keys, String apprResult) {
        pmsTimesheetService.rejected(Arrays.asList(keys), apprResult);
        return TwOutputUtil.ok();
    }

    /**
     * 高级审批 只有审批中或新建的单据才允许审批通过
     *
     * @param keys 主键集合
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/approving/approvedPro")
    public TwOutputUtil approvedPro(Long[] keys) {
        pmsTimesheetService.toAdvanced(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 删除 只能删除状态为创建或者退回的工时
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        // 新建、退回的 才能删除
        pmsTimesheetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 修复一月到六月的有项目无任务的工时
     */
    @GetMapping("/timesheet/repair")
    public TwOutputUtil repairTimesheet() {
        // pmsTimesheetService.repairTimesheet();
        return TwOutputUtil.ok();
    }

    /**
     * 月度员工工时统计分页查询
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/monthly/paging")
    @UdcNameClass
    public TwOutputUtil monthlyPaging(MonthlyTimesheetQuery query) {
        return TwOutputUtil.ok(pmsTimesheetService.monthlyPaging(query));
    }

    /**
     * 月度员工工时导出
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/monthly/export")
    @UdcNameClass
    public void monthlyExport(MonthlyTimesheetQuery query, HttpServletResponse response) {
        pmsTimesheetService.monthlyExport(query, response);
    }

    /**
     * 月度员工工时导出同步至JDE【上传文件】
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/monthly/syncJDE")
    @UdcNameClass
    public TwOutputUtil monthlySyncJDE(MonthlyTimesheetQuery query) {
        pmsTimesheetService.monthlySyncToJDE(query);
        return TwOutputUtil.ok();
    }

    /**
     * 根据 事由类型、是否工作日、周末现场是否考虑补助、项目补助规则 查询补助类型（出差类型）下拉选择
     * @param workDate
     * @param reasonType
     * @param reasonId
     * @param tsUserId
     * @return
     */
    @GetMapping("/listWorkTypeExt4")
    public TwOutputUtil<List<TimesheetSubsidySelectTypeVO>> listWorkTypeExt4(String workDate, String reasonType, Long reasonId, Long tsUserId) {
        LocalDate workDatePro = LocalDate.parse(workDate);
        return TwOutputUtil.ok(pmsTimesheetService.listWorkTypeExt4(workDatePro,reasonType,reasonId,tsUserId));
    }

    /**
     * 根据 事由类型、是否工作日、周末现场是否考虑补助、项目补助规则 查询可填写工时 下拉选择
     *
     * @param workDate
     * @param reasonType
     * @param reasonId
     * @param tsUserId
     */
    @GetMapping("/listWorkHourSelect")
    public TwOutputUtil<List<TimesheetSubsidySelectTypeVO>> listWorkHourSelect(String workDate, String reasonType, Long reasonId, Long tsUserId) {
        LocalDate workDatePro = LocalDate.parse(workDate);
        return TwOutputUtil.ok(pmsTimesheetService.listWorkHourSelect(workDatePro,reasonType,reasonId,tsUserId));
    }

}
