package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.AbnormalWorkApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QAbnormalWorkApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.AbnormalWorkApplyRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 远程办公申请
 *
 * @author carl
 * @date 2024-04-19
 */
@Repository
@RequiredArgsConstructor
public class AbnormalWorkApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AbnormalWorkApplyRepo repo;
    private final QAbnormalWorkApplyDO qdo = QAbnormalWorkApplyDO.abnormalWorkApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AbnormalWorkApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AbnormalWorkApplyVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 外出申请人id
                qdo.applyUserId,
                // 归属bu_id
                qdo.orgId,
                // base地id
                qdo.baseAddrId,
                // 直属领导id
                qdo.parentUserId,
                // 岗位
                qdo.jobs,
                // 级别
                qdo.grade,
                // 申请日期
                qdo.applyDate,
                // 远程办公日期开始
                qdo.abnormalWorkDateStart,
                // 远程办公日期结束
                qdo.abnormalWorkDateEnd,
                // 远程办公天数
                qdo.days,
                // 事由类型
                qdo.reasonType,
                // 事由id
                qdo.reasonId,
                // 事由名称
                qdo.reasonName,
                // 远程工作地
                qdo.abnormalWorkAddr,
                // 编号
                qdo.applyNo,
                // 名称
                qdo.applyName,
                // 任务状态
                qdo.applyStatus,
                // 审批状态
                qdo.procInstStatus,
                // 流程id
                qdo.procInstId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AbnormalWorkApplyVO> getJpaQueryWhere(AbnormalWorkApplyQuery query) {
        JPAQuery<AbnormalWorkApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AbnormalWorkApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AbnormalWorkApplyQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 外出申请人id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            list.add(qdo.applyUserId.eq(query.getApplyUserId()));
        }
        /** 归属bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            list.add(qdo.orgId.eq(query.getOrgId()));
        }
        /** base地id 精确 */
        if (!ObjectUtils.isEmpty(query.getBaseAddrId())) {
            list.add(qdo.baseAddrId.eq(query.getBaseAddrId()));
        }
        /** 直属领导id 精确 */
        if (!ObjectUtils.isEmpty(query.getParentUserId())) {
            list.add(qdo.parentUserId.eq(query.getParentUserId()));
        }
        /** 岗位 精确 */
        if (!ObjectUtils.isEmpty(query.getJobs())) {
            list.add(qdo.jobs.eq(query.getJobs()));
        }
        /** 级别 精确 */
        if (!ObjectUtils.isEmpty(query.getGrade())) {
            list.add(qdo.grade.eq(query.getGrade()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStartDate())) {
            list.add(qdo.applyDate.goe(query.getApplyStartDate()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyEndDate())) {
            list.add(qdo.applyDate.loe(query.getApplyEndDate()));
        }
        /** 远程办公日期开始 精确 */
        if (!ObjectUtils.isEmpty(query.getAbnormalWorkStartDate())) {
            list.add(qdo.abnormalWorkDateStart.goe(query.getAbnormalWorkStartDate()));
        }
        /** 远程办公日期结束 精确 */
        if (!ObjectUtils.isEmpty(query.getAbnormalWorkEndDate())) {
            list.add(qdo.abnormalWorkDateEnd.loe(query.getAbnormalWorkEndDate()));
        }
        /** 远程办公天数 精确 */
        if (!ObjectUtils.isEmpty(query.getDays())) {
            list.add(qdo.days.eq(query.getDays()));
        }
        /** 事由类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));
        }

        /** 远程工作地 精确 */
        if (!ObjectUtils.isEmpty(query.getAbnormalWorkAddr())) {
            list.add(qdo.abnormalWorkAddr.eq(query.getAbnormalWorkAddr()));
        }
        /** 编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            list.add(qdo.applyNo.like(SqlUtil.toSqlLikeString(query.getApplyNo())));
        }
        /** 名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getApplyName())) {
            list.add(qdo.applyName.like(SqlUtil.toSqlLikeString(query.getApplyName())));
        }
        /** 任务状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            list.add(qdo.applyStatus.eq(query.getApplyStatus()));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 流程id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AbnormalWorkApplyVO queryByKey(Long id) {
        JPAQuery<AbnormalWorkApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AbnormalWorkApplyVO> queryListDynamic(AbnormalWorkApplyQuery query) {
        JPAQuery<AbnormalWorkApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AbnormalWorkApplyVO> queryPaging(AbnormalWorkApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AbnormalWorkApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<AbnormalWorkApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AbnormalWorkApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AbnormalWorkApplyDO save(AbnormalWorkApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AbnormalWorkApplyDO> saveAll(List<AbnormalWorkApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AbnormalWorkApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 外出申请人id
        if (payload.getApplyUserId() != null) {
            update.set(qdo.applyUserId, payload.getApplyUserId());
        }
        // 归属bu_id
        if (payload.getOrgId() != null) {
            update.set(qdo.orgId, payload.getOrgId());
        }
        // base地id
        if (payload.getBaseAddrId() != null) {
            update.set(qdo.baseAddrId, payload.getBaseAddrId());
        }
        // 直属领导id
        if (payload.getParentUserId() != null) {
            update.set(qdo.parentUserId, payload.getParentUserId());
        }
        // 岗位
        if (payload.getJobs() != null) {
            update.set(qdo.jobs, payload.getJobs());
        }
        // 级别
        if (payload.getGrade() != null) {
            update.set(qdo.grade, payload.getGrade());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 远程办公日期开始
        if (payload.getAbnormalWorkDateStart() != null) {
            update.set(qdo.abnormalWorkDateStart, payload.getAbnormalWorkDateStart());
        }
        // 远程办公日期结束
        if (payload.getAbnormalWorkDateEnd() != null) {
            update.set(qdo.abnormalWorkDateEnd, payload.getAbnormalWorkDateEnd());
        }

        // 天数
        if (payload.getDays() != null) {
            update.set(qdo.days, payload.getDays());
        }
        // 事由类型
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 事由id
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 事由名称
        if (payload.getReasonName() != null) {
            update.set(qdo.reasonName, payload.getReasonName());
        }
        // 远程工作地
        if (payload.getAbnormalWorkAddr() != null) {
            update.set(qdo.abnormalWorkAddr, payload.getAbnormalWorkAddr());
        }
        // 编号
        if (payload.getApplyNo() != null) {
            update.set(qdo.applyNo, payload.getApplyNo());
        }
        // 名称
        if (payload.getApplyName() != null) {
            update.set(qdo.applyName, payload.getApplyName());
        }
        // 任务状态
        if (payload.getApplyStatus() != null) {
            update.set(qdo.applyStatus, payload.getApplyStatus());
        }
        // 审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 流程id
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 外出申请人id
            if (nullFields.contains("applyUserId")) {
                update.setNull(qdo.applyUserId);
            }
            // 归属bu_id
            if (nullFields.contains("orgId")) {
                update.setNull(qdo.orgId);
            }
            // base地id
            if (nullFields.contains("baseAddrId")) {
                update.setNull(qdo.baseAddrId);
            }
            // 直属领导id
            if (nullFields.contains("parentUserId")) {
                update.setNull(qdo.parentUserId);
            }
            // 岗位
            if (nullFields.contains("jobs")) {
                update.setNull(qdo.jobs);
            }
            // 级别
            if (nullFields.contains("grade")) {
                update.setNull(qdo.grade);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 远程办公日期开始
            if (nullFields.contains("abnormalWorkDateStart")) {
                update.setNull(qdo.abnormalWorkDateStart);
            }

            // 远程办公日期结束
            if (nullFields.contains("abnormalWorkDateEnd")) {
                update.setNull(qdo.abnormalWorkDateEnd);
            }

            // 天数
            if (nullFields.contains("days")) {
                update.setNull(qdo.days);
            }
            // 事由类型
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 事由id
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 事由名称
            if (nullFields.contains("reasonName")) {
                update.setNull(qdo.reasonName);
            }
            // 远程工作地
            if (nullFields.contains("abnormalWorkAddr")) {
                update.setNull(qdo.abnormalWorkAddr);
            }
            // 编号
            if (nullFields.contains("applyNo")) {
                update.setNull(qdo.applyNo);
            }
            // 名称
            if (nullFields.contains("applyName")) {
                update.setNull(qdo.applyName);
            }
            // 任务状态
            if (nullFields.contains("applyStatus")) {
                update.setNull(qdo.applyStatus);
            }
            // 审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 流程id
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

