package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 远程办公申请
 *
 * @author carl
 * @date 2024-04-19
 */
@Entity
@Table(name = "abnormal_work_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "abnormal_work_apply", comment = "远程办公申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AbnormalWorkApplyDO extends BaseModel implements Serializable  {
    /** 外出申请人id */
    @Comment("外出申请人id")
    @Column()
    private Long applyUserId;
    /** 归属bu_id */
    @Comment("归属bu_id")
    @Column()
    private Long orgId;
    /** base地id */
    @Comment("base地id")
    @Column()
    private String baseAddrId;
    /** 直属领导id */
    @Comment("直属领导id")
    @Column()
    private Long parentUserId;
    /** 岗位 */
    @Comment("岗位")
    @Column()
    private String jobs;
    /** 级别 */
    @Comment("级别")
    @Column()
    private String grade;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 远程办公日期开始
     */
    @Comment("远程办公日期开始")
    @Column()
    private LocalDate abnormalWorkDateStart;

    /**
     * 远程办公日期结束
     */
    @Comment("远程办公日期结束")
    @Column()
    private LocalDate abnormalWorkDateEnd;
    /**
     * 远程办公天数
     */
    @Comment("远程办公天数")
    @Column()
    private BigDecimal days;

    /**
     * 事由类型
     */
    @Comment("事由类型")
    @Column()
    private String reasonType;
    /**
     * 事由名称
     */
    @Comment("事由名称")
    @Column()
    private String reasonName;

    /**
     *事由ID
     */
    @Comment("事由ID")
    @Column()
    private Long reasonId;
    /** 远程工作地 */
    @Comment("远程工作地")
    @Column()
    private String abnormalWorkAddr;
    /** 编号 */
    @Comment("编号")
    @Column()
    private String applyNo;
    /** 名称 */
    @Comment("名称")
    @Column()
    private String applyName;
    /** 任务状态 */
    @Comment("任务状态")
    @Column()
    private String applyStatus;
    /** 审批状态 */
    @Comment("审批状态")
    @Column()
    private String procInstStatus;
    /** 流程id */
    @Comment("流程id")
    @Column()
    private String procInstId;

    public void copy(AbnormalWorkApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
