package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "t_attendance_record")
@org.hibernate.annotations.Table(appliesTo = "t_attendance_record", comment = "打卡记录明细表 1个资源每天多次打卡时，记录每次打卡数据")
@Data
@Where(clause = "delete_flag= 0")
public class TAttendanceRecordDO extends BaseModel {

    @Comment("打卡人员")
    @Column()
    private Long attendanceResId;

    @Comment("规则ID")
    @Column()
    private Long attendanceRuleId;

    @Comment("打卡日期")
    @Column()
    private LocalDate attendanceDate;

    @Comment("打卡人员")
    @Column()
    private String attendanceTimeStart;

    @Comment("下班时间")
    @Column()
    private String attendanceTimeEnd;

    @Comment("打卡经度")
    @Column()
    private String attendanceSiteLongitude;

    @Comment("打卡维度")
    @Column()
    private String attendanceSiteLatitude;

    @Comment("打卡位置")
    @Column()
    private String attendanceLocation;

    @Comment("打卡结果 YES/NO")
    @Column()
    private String attendanceResult;

    @Comment("正常、迟到或早退、矿工")
    @Column()
    private String attendanceResultDetail;

    @Comment("特殊打卡原因")
    @Column()
    private String specialReason;

    @Comment("打卡设备")
    @Column()
    private String attendanceDevice;

    @Comment("4.0主键id")
    @Column(name = "attendance_record_id_v4")
    private Long attendanceRecordIdV4;

    public void copy(TAttendanceRecordDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
