package com.elitesland.tw.tw5.server.prd.partner.business.controller;

import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationEmployeesQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.service.BusinessOperationEmployeesService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 业务合作伙伴-企业主要人员
 *
 * @author wangly
 * @date 2023-05-18
 */
@Api(tags = "业务合作伙伴-企业主要人员")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessOperationEmployees")
@Slf4j
public class BusinessOperationEmployeesController {

    private final BusinessOperationEmployeesService businessOperationEmployeesService;

    /**
     * 业务合作伙伴-企业主要人员-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务合作伙伴-企业主要人员-新增")
    public TwOutputUtil insert(@RequestBody BusinessOperationEmployeesPayload payload){
        if (null == payload.getPartnerId()) {
            return TwOutputUtil.error("999", "partnerId参数缺失", payload);
        }
        return TwOutputUtil.ok(businessOperationEmployeesService.insert(payload));
    }

    /**
     * 业务合作伙伴-企业主要人员-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务合作伙伴-企业主要人员-更新")
    public TwOutputUtil update(@RequestBody BusinessOperationEmployeesPayload payload){
        return TwOutputUtil.ok(businessOperationEmployeesService.update(payload));
    }

    /**
     * 业务合作伙伴-企业主要人员-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务合作伙伴-企业主要人员-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessOperationEmployeesService.queryByKey(key));
    }

    /**
     * 业务合作伙伴-企业主要人员-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务合作伙伴-企业主要人员-分页")
    public TwOutputUtil paging(BusinessOperationEmployeesQuery query) {
        if (null == query.getPartnerId()) {
            return TwOutputUtil.error("999", "partnerId参数缺失", null);
        }
        return TwOutputUtil.ok(businessOperationEmployeesService.queryPaging(query));
    }

    /**
     * 业务合作伙伴-企业主要人员-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务合作伙伴-企业主要人员-查询列表")
    public TwOutputUtil queryList(BusinessOperationEmployeesQuery query) {
        if (null == query.getPartnerId()) {
            return TwOutputUtil.error("999", "partnerId参数缺失", null);
        }
        return TwOutputUtil.ok(businessOperationEmployeesService.queryListDynamic(query));
    }

    /**
     * 业务合作伙伴-企业主要人员-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务合作伙伴-企业主要人员-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessOperationEmployeesService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
