package com.elitesland.tw.tw5.server.prd.partner.constants;

import lombok.Getter;

public enum BusinessTeamRoleEnum {
    CREATOR("CREATOR","创建人",0),
    SALE_MANAGER("SALE_MANAGER","商务负责人",5),
    SERVICE_MANAGER("SERVICE_MANAGER","服务负责人",10),
    CARE("CARE", "关怀负责人",20),
    OPERATION("OPERATION", "运维售后负责人",30),
    PURCHASE_MANAGER("PURCHASE_MANAGER","采购负责人",40),
    CHANNEL_MANAGER("CHANNEL_MANAGER","渠道负责人",50),
    BASE("BASE","普通角色",100),
    ;
    @Getter
    private final String code;
    @Getter
    private final String desc;
    @Getter
    private final Integer sortNo;

    BusinessTeamRoleEnum(String code, String desc, Integer sortNo) {
        this.code = code;
        this.desc = desc;
        this.sortNo = sortNo;
    }

    public static String queryDescByCode(String code){
        BusinessTeamRoleEnum[] values = BusinessTeamRoleEnum.values();
        for(BusinessTeamRoleEnum temp:values){
            if(temp.getCode().equals(code)){
                return temp.getDesc();
            }
        }
        return null;
    }
}
