package com.elitesland.tw.tw5.server.prd.partner.identity.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCutomerManagePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerListSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessCutomerManageVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴-客户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-客户信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessCustomerInfo")
@Slf4j
public class BusinessCustomerInfoController {

    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final UdcUtil udcUtil;
    /**
     * 业务伙伴-客户信息-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-客户信息-新增")
    public TwOutputUtil insert(@RequestBody BusinessCustomerInfoPayload payload){
        return TwOutputUtil.ok(businessCustomerInfoService.insert(payload));
    }

    /**
     * 业务伙伴-更新客户管理的团队成员
     *
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/updateCustomerManageTeamMember")
    @UdcNameClass
    @ApiOperation("业务伙伴-更新客户管理的团队成员")
    public TwOutputUtil updateCustomerManageTeamMember(@RequestBody BusinessCutomerManagePayload businessCutomerManagePayload) {
        businessCustomerInfoService.updateCustomerManageTeamMember(businessCutomerManagePayload);
        return TwOutputUtil.ok();
    }

    /**
     * 业务伙伴-客户信息-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-客户信息-更新")
    public TwOutputUtil<BusinessCustomerInfoVO> update(@RequestBody BusinessCustomerInfoPayload payload){
        return TwOutputUtil.ok(businessCustomerInfoService.update(payload));
    }

//    /**
//     * 业务伙伴-客户信息-主键查询 暂且没用 需要可放开
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//     @UdcNameClass
//    @ApiOperation("业务伙伴-客户信息-主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(businessCustomerInfoService.queryByKey(key));
//    }

//    /**
//     * 业务伙伴-客户信息-分页 暂且没用 需要可放开
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//     @UdcNameClass
//    @ApiOperation("业务伙伴-客户信息-分页")
//    public TwOutputUtil paging(BusinessCustomerInfoQuery query) {
//        return TwOutputUtil.ok(businessCustomerInfoService.queryPaging(query));
//    }

    /**
     * 业务伙伴-客户信息-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-客户信息-查询列表")
    public TwOutputUtil<List<BusinessCustomerInfoVO>> queryList(BusinessCustomerInfoQuery query) {
        return TwOutputUtil.ok(businessCustomerInfoService.queryListDynamic(query));
    }

    /**
     * 业务伙伴-客户信息-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-客户信息-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessCustomerInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 业务伙伴-客户信息-查询列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/listSimple")
    @UdcNameClass
    @ApiOperation("业务伙伴-客户信息-查询所有客户")
    public TwOutputUtil<List<BusinessCustomerSimpleVO>> listSimple(String identity, String customerStatus) {
        return TwOutputUtil.ok(businessCustomerInfoService.listSimple(identity,customerStatus));
    }

    /**
     * 业务伙伴-客户信息-查询列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/listSimplePaging")
    @UdcNameClass
    @ApiOperation("业务伙伴-客户信息分页-查询所有客户")
    public TwOutputUtil<PagingVO<BusinessCustomerSimpleVO>> listSimplePaging(BusinessPartnerListSimpleQuery query) {
        return TwOutputUtil.ok(businessCustomerInfoService.listSimplePaging(query));
    }


    /**
     * 业务伙伴-客户管理查询
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryCustomerManage")
    @UdcNameClass
    @ApiOperation("业务伙伴-客户管理查询")
    public TwOutputUtil<PagingVO<BusinessCutomerManageVO>> queryCustomerManage(BusinessCustomerInfoQuery query) {
        return TwOutputUtil.ok(businessCustomerInfoService.queryCustomerManage(query));
    }

    /**
     * 业务伙伴-客户管理查询
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryCustomerManageByPartnerId/{key}")
    @UdcNameClass
    @ApiOperation("业务伙伴-客户管理查询")
    public TwOutputUtil<BusinessCutomerManageVO> queryCustomerManageByPartnerId(@PathVariable Long key) {
        return TwOutputUtil.ok(businessCustomerInfoService.queryCustomerManageByPartnerId(key));
    }

    /**
     * 业务伙伴-客户管理导出
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/exportCustomerManage")
    @UdcNameClass
    @ApiOperation("业务伙伴-客户管理导出")
    public void exportCustomerManage(BusinessCustomerInfoQuery query, HttpServletRequest request, HttpServletResponse response) throws IOException {

        //定义文件名称
        String sheetName = "客户管理";
        List<BusinessCutomerManageVO> businessCutomerManageVOS = businessCustomerInfoService.queryCustomerManageList(query);
        if(!CollectionUtils.isEmpty(businessCutomerManageVOS)){
            businessCutomerManageVOS = udcUtil.translateList(businessCutomerManageVOS);
            //对文件名进行固定格式编码
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            //设置请求响应内容类型
            //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            //设置请求响应内容编码方式
            response.setCharacterEncoding("utf-8");
            //文件下载，指定默认名
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

            final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), BusinessCutomerManageVO.class)
                    .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                    .sheet(sheetName);
            // 列
            ExcelUtil.excelHelper(sheet, BusinessCutomerManageVO.class, null);
            //写入
            sheet.doWrite(businessCutomerManageVOS);
        }
    }

    /**
     * 客户管理-客户激活
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/activeCustomer")
    @ApiOperation("客户管理-客户激活")
    public TwOutputUtil activeCustomer(Long partnerId,String partnerName,Long bookId){
        businessCustomerInfoService.activeCustomer(partnerId,partnerName,bookId);
        return TwOutputUtil.ok();
    }


    /**
     * 客户管理-客户激活
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/activeCustomerWithWorkFlow")
    @ApiOperation("客户管理-客户激活无流程")
    public TwOutputUtil activeCustomerWithWorkFlow(Long partnerId,String partnerName,Long bookId){
        businessCustomerInfoService.activeCustomerWithWorkFlow(partnerId,partnerName,bookId);
        return TwOutputUtil.ok();
    }
    /**
     * 客户管理-客户激活前校验
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/activeCustomer/check")
    @ApiOperation("客户管理-客户激活前校验 true通过false不通过")
    public TwOutputUtil activeCustomerCheck(Long bookId){
        Boolean res = businessCustomerInfoService.activeCustomerCheck(bookId);
        return TwOutputUtil.ok(res);
    }

}
