package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexRecordPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexRecordQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyIndexRecordService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexRecordVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyIndexRecordConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyIndexRecordDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyIndexRecordDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyIndexRecordRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 分级策略-分级记录
 *
 * @author wangly
 * @date 2023-06-28
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessStrategyIndexRecordServiceImpl extends BaseServiceImpl implements BusinessStrategyIndexRecordService {

    private final BusinessStrategyIndexRecordRepo businessStrategyIndexRecordRepo;
    private final BusinessStrategyIndexRecordDAO businessStrategyIndexRecordDAO;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    @Override
    public PagingVO<BusinessStrategyIndexRecordVO> queryPaging(BusinessStrategyIndexRecordQuery query){
        return businessStrategyIndexRecordDAO.queryPaging(query);
    }

    @Override
    public List<BusinessStrategyIndexRecordVO> queryListDynamic(BusinessStrategyIndexRecordQuery query){
        return businessStrategyIndexRecordDAO.queryListDynamic(query);
    }

    @Override
    public BusinessStrategyIndexRecordVO queryByKey(Long key) {
        BusinessStrategyIndexRecordDO entity = businessStrategyIndexRecordRepo.findById(key).orElseGet(BusinessStrategyIndexRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyIndexRecordVO vo = BusinessStrategyIndexRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyIndexRecordVO insert(BusinessStrategyIndexRecordPayload payload) {
        BusinessStrategyIndexRecordDO entityDo = BusinessStrategyIndexRecordConvert.INSTANCE.toDo(payload);
        return BusinessStrategyIndexRecordConvert.INSTANCE.toVo(businessStrategyIndexRecordRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyIndexRecordVO update(BusinessStrategyIndexRecordPayload payload) {
        BusinessStrategyIndexRecordDO entity = businessStrategyIndexRecordRepo.findById(payload.getId()).orElseGet(BusinessStrategyIndexRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyIndexRecordDO entityDo = BusinessStrategyIndexRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyIndexRecordConvert.INSTANCE.toVo(businessStrategyIndexRecordRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessStrategyIndexRecordPayload payload) {
        BusinessStrategyIndexRecordDO entity = businessStrategyIndexRecordRepo.findById(payload.getId()).orElseGet(BusinessStrategyIndexRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessStrategyIndexRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessStrategyIndexRecordDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<BusinessStrategyIndexRecordVO> queryListByCustomerId(Long customerId) {
        BusinessCustomerInfoVO businessCustomerInfoVO = businessCustomerInfoService.queryByKey(customerId);
        String indexInfo = businessCustomerInfoVO.getIndexInfo();
        if(StringUtils.isEmpty(indexInfo)){
            return null;
        }
        List<BusinessStrategyIndexRecordVO> businessStrategyIndexRecordVOS = JSON.parseArray(indexInfo, BusinessStrategyIndexRecordVO.class);
        return businessStrategyIndexRecordVOS;
    }

}
