package com.elitesland.tw.tw5.server.prd.pay.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.BkPayDetailRecordQuery;
import com.elitesland.tw.tw5.api.prd.pay.vo.BkPayDetailRecordVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pay.entity.BkPayDetailRecordDO;
import com.elitesland.tw.tw5.server.prd.pay.entity.QBkPayDetailRecordDO;
import com.elitesland.tw.tw5.server.prd.pay.repo.BkPayDetailRecordRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 支付管理-付款发送记录
 *
 * @author wangly
 * @date 2023-12-12
 */
@Repository
@RequiredArgsConstructor
public class BkPayDetailRecordDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BkPayDetailRecordRepo repo;
    private final QBkPayDetailRecordDO qdo = QBkPayDetailRecordDO.bkPayDetailRecordDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BkPayDetailRecordVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BkPayDetailRecordVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 付款明细表id
                qdo.bkPayDetailId,
                // 流程实例号
                qdo.reqnbr,
                // 事件实例号
                qdo.evtlst,
                // 批次编号
                qdo.bthnbr,
                // 业务参考号
                qdo.yurref,
                // 交易流水号
                qdo.refnbr,
                // 请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。
                qdo.reqsta,
                // 交易序号
                qdo.trxseq,
                // 保留字段
                qdo.rsv100,
                // 付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票
                qdo.payStatus,
                // 单据类型：1.代发 2.支付（用于接口区分数据）
                qdo.orderType,
                // 交易状态：E：失败 A: 登记 S: 成功
                qdo.stscod,
                // 收方开户行名称
                qdo.crtbnk,
                // 收方开户行地址
                qdo.crtadr,
                // 收方行联行号
                qdo.brdnbr,
                // 交易金额
                qdo.trsamt,
                // 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账
                qdo.ftnflg,
                // 银行失败码
                qdo.errorCode,
                // 批量标识:1.单条 2.批量  （用于支付接口）
                qdo.batchFlag,
                // 失败原因
                qdo.errorReason
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BkPayDetailRecordVO> getJpaQueryWhere(BkPayDetailRecordQuery query) {
        JPAQuery<BkPayDetailRecordVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BkPayDetailRecordQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BkPayDetailRecordQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 主键id 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 付款明细表id 精确 */
        if (!ObjectUtils.isEmpty(query.getBkPayDetailId())) {
            list.add(qdo.bkPayDetailId.eq(query.getBkPayDetailId()));
        }
        /** 流程实例号 精确 */
        if (!ObjectUtils.isEmpty(query.getReqnbr())) {
            list.add(qdo.reqnbr.eq(query.getReqnbr()));
        }
        /** 事件实例号 精确 */
        if (!ObjectUtils.isEmpty(query.getEvtlst())) {
            list.add(qdo.evtlst.eq(query.getEvtlst()));
        }
        /** 批次编号 精确 */
        if (!ObjectUtils.isEmpty(query.getBthnbr())) {
            list.add(qdo.bthnbr.eq(query.getBthnbr()));
        }
        /** 业务参考号 精确 */
        if (!ObjectUtils.isEmpty(query.getYurref())) {
            list.add(qdo.yurref.eq(query.getYurref()));
        }
        /** 交易流水号 精确 */
        if (!ObjectUtils.isEmpty(query.getRefnbr())) {
            list.add(qdo.refnbr.eq(query.getRefnbr()));
        }
        /** 请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。 精确 */
        if (!ObjectUtils.isEmpty(query.getReqsta())) {
            list.add(qdo.reqsta.eq(query.getReqsta()));
        }
        /** 交易序号 精确 */
        if (!ObjectUtils.isEmpty(query.getTrxseq())) {
            list.add(qdo.trxseq.eq(query.getTrxseq()));
        }
        /** 保留字段 精确 */
        if (!ObjectUtils.isEmpty(query.getRsv100())) {
            list.add(qdo.rsv100.eq(query.getRsv100()));
        }
        /** 付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票 精确 */
        if (!ObjectUtils.isEmpty(query.getPayStatus())) {
            list.add(qdo.payStatus.eq(query.getPayStatus()));
        }
        /** 单据类型：1.代发 2.支付（用于接口区分数据） 精确 */
        if (!ObjectUtils.isEmpty(query.getOrderType())) {
            list.add(qdo.orderType.eq(query.getOrderType()));
        }
        /** 交易状态：E：失败 A: 登记 S: 成功 精确 */
        if (!ObjectUtils.isEmpty(query.getStscod())) {
            list.add(qdo.stscod.eq(query.getStscod()));
        }
        /** 收方开户行名称 精确 */
        if (!ObjectUtils.isEmpty(query.getCrtbnk())) {
            list.add(qdo.crtbnk.eq(query.getCrtbnk()));
        }
        /** 收方开户行地址 精确 */
        if (!ObjectUtils.isEmpty(query.getCrtadr())) {
            list.add(qdo.crtadr.eq(query.getCrtadr()));
        }
        /** 收方行联行号 精确 */
        if (!ObjectUtils.isEmpty(query.getBrdnbr())) {
            list.add(qdo.brdnbr.eq(query.getBrdnbr()));
        }
        /** 交易金额 精确 */
        if (!ObjectUtils.isEmpty(query.getTrsamt())) {
            list.add(qdo.trsamt.eq(query.getTrsamt()));
        }
        /** 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账 精确 */
        if (!ObjectUtils.isEmpty(query.getFtnflg())) {
            list.add(qdo.ftnflg.eq(query.getFtnflg()));
        }
        /** 银行失败码 精确 */
        if (!ObjectUtils.isEmpty(query.getErrorCode())) {
            list.add(qdo.errorCode.eq(query.getErrorCode()));
        }
        /** 批量标识:1.单条 2.批量  （用于支付接口） 精确 */
        if (!ObjectUtils.isEmpty(query.getBatchFlag())) {
            list.add(qdo.batchFlag.eq(query.getBatchFlag()));
        }
        /** 失败原因 精确 */
        if (!ObjectUtils.isEmpty(query.getErrorReason())) {
            list.add(qdo.errorReason.eq(query.getErrorReason()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BkPayDetailRecordVO queryByKey(Long id) {
        JPAQuery<BkPayDetailRecordVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BkPayDetailRecordVO> queryListDynamic(BkPayDetailRecordQuery query) {
        JPAQuery<BkPayDetailRecordVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BkPayDetailRecordVO> queryPaging(BkPayDetailRecordQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BkPayDetailRecordVO> jpaQuery = getJpaQueryWhere(query);
        List<BkPayDetailRecordVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BkPayDetailRecordVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BkPayDetailRecordDO save(BkPayDetailRecordDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BkPayDetailRecordDO> saveAll(List<BkPayDetailRecordDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BkPayDetailRecordPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 主键id
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 付款明细表id
        if (payload.getBkPayDetailId() != null) {
            update.set(qdo.bkPayDetailId, payload.getBkPayDetailId());
        }
        // 流程实例号
        if (payload.getReqnbr() != null) {
            update.set(qdo.reqnbr, payload.getReqnbr());
        }
        // 事件实例号
        if (payload.getEvtlst() != null) {
            update.set(qdo.evtlst, payload.getEvtlst());
        }
        // 批次编号
        if (payload.getBthnbr() != null) {
            update.set(qdo.bthnbr, payload.getBthnbr());
        }
        // 业务参考号
        if (payload.getYurref() != null) {
            update.set(qdo.yurref, payload.getYurref());
        }
        // 交易流水号
        if (payload.getRefnbr() != null) {
            update.set(qdo.refnbr, payload.getRefnbr());
        }
        // 请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。
        if (payload.getReqsta() != null) {
            update.set(qdo.reqsta, payload.getReqsta());
        }
        // 交易序号
        if (payload.getTrxseq() != null) {
            update.set(qdo.trxseq, payload.getTrxseq());
        }
        // 保留字段
        if (payload.getRsv100() != null) {
            update.set(qdo.rsv100, payload.getRsv100());
        }
        // 付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票
        if (payload.getPayStatus() != null) {
            update.set(qdo.payStatus, payload.getPayStatus());
        }
        // 单据类型：1.代发 2.支付（用于接口区分数据）
        if (payload.getOrderType() != null) {
            update.set(qdo.orderType, payload.getOrderType());
        }
        // 交易状态：E：失败 A: 登记 S: 成功
        if (payload.getStscod() != null) {
            update.set(qdo.stscod, payload.getStscod());
        }
        // 收方开户行名称
        if (payload.getCrtbnk() != null) {
            update.set(qdo.crtbnk, payload.getCrtbnk());
        }
        // 收方开户行地址
        if (payload.getCrtadr() != null) {
            update.set(qdo.crtadr, payload.getCrtadr());
        }
        // 收方行联行号
        if (payload.getBrdnbr() != null) {
            update.set(qdo.brdnbr, payload.getBrdnbr());
        }
        // 交易金额
        if (payload.getTrsamt() != null) {
            update.set(qdo.trsamt, payload.getTrsamt());
        }
        // 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账
        if (payload.getFtnflg() != null) {
            update.set(qdo.ftnflg, payload.getFtnflg());
        }
        // 银行失败码
        if (payload.getErrorCode() != null) {
            update.set(qdo.errorCode, payload.getErrorCode());
        }
        // 批量标识:1.单条 2.批量  （用于支付接口）
        if (payload.getBatchFlag() != null) {
            update.set(qdo.batchFlag, payload.getBatchFlag());
        }
        // 失败原因
        if (payload.getErrorReason() != null) {
            update.set(qdo.errorReason, payload.getErrorReason());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键id
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 付款明细表id
            if (nullFields.contains("bkPayDetailId")) {
                update.setNull(qdo.bkPayDetailId);
            }
            // 流程实例号
            if (nullFields.contains("reqnbr")) {
                update.setNull(qdo.reqnbr);
            }
            // 事件实例号
            if (nullFields.contains("evtlst")) {
                update.setNull(qdo.evtlst);
            }
            // 批次编号
            if (nullFields.contains("bthnbr")) {
                update.setNull(qdo.bthnbr);
            }
            // 业务参考号
            if (nullFields.contains("yurref")) {
                update.setNull(qdo.yurref);
            }
            // 交易流水号
            if (nullFields.contains("refnbr")) {
                update.setNull(qdo.refnbr);
            }
            // 请求状态:OPR.数据接收中;AUT.等待审批;NTE.终审完毕;APW.银行人工审批;WRF.可疑;BNK.银行处理中。
            if (nullFields.contains("reqsta")) {
                update.setNull(qdo.reqsta);
            }
            // 交易序号
            if (nullFields.contains("trxseq")) {
                update.setNull(qdo.trxseq);
            }
            // 保留字段
            if (nullFields.contains("rsv100")) {
                update.setNull(qdo.rsv100);
            }
            // 付款 状态：1.待发送 2.待查询 3.待支付 4,支付中  5.成功 6.失败 7.支付退票
            if (nullFields.contains("payStatus")) {
                update.setNull(qdo.payStatus);
            }
            // 单据类型：1.代发 2.支付（用于接口区分数据）
            if (nullFields.contains("orderType")) {
                update.setNull(qdo.orderType);
            }
            // 交易状态：E：失败 A: 登记 S: 成功
            if (nullFields.contains("stscod")) {
                update.setNull(qdo.stscod);
            }
            // 收方开户行名称
            if (nullFields.contains("crtbnk")) {
                update.setNull(qdo.crtbnk);
            }
            // 收方开户行地址
            if (nullFields.contains("crtadr")) {
                update.setNull(qdo.crtadr);
            }
            // 收方行联行号
            if (nullFields.contains("brdnbr")) {
                update.setNull(qdo.brdnbr);
            }
            // 交易金额
            if (nullFields.contains("trsamt")) {
                update.setNull(qdo.trsamt);
            }
            // 业务处理结果  ：S 成功 银行支付成功；F 失败 银行支付失败；B 退票 银行支付被退票；R 否决 企业审批否决；D 过期 企业过期不审批；C 撤消 企业撤销；U 银行挂账
            if (nullFields.contains("ftnflg")) {
                update.setNull(qdo.ftnflg);
            }
            // 银行失败码
            if (nullFields.contains("errorCode")) {
                update.setNull(qdo.errorCode);
            }
            // 批量标识:1.单条 2.批量  （用于支付接口）
            if (nullFields.contains("batchFlag")) {
                update.setNull(qdo.batchFlag);
            }
            // 失败原因
            if (nullFields.contains("errorReason")) {
                update.setNull(qdo.errorReason);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

