package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectEventLogPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectEventLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectEventLogService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectEventLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * 项目事件日志功能管理
 *
 * @author carl
 * @date 2023-09-18
 */
@Api(tags = "项目事件日志功能管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectEventLog")
@Slf4j
public class PmsProjectEventLogController {

    private final PmsProjectEventLogService pmsProjectEventLogService;

    /**
     * 项目事件日志功能管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目事件日志功能管理-新增或修改")
    public TwOutputUtil<PmsProjectEventLogVO> insertOrUpdate(@RequestBody PmsProjectEventLogPayload payload) {
        return TwOutputUtil.ok(pmsProjectEventLogService.insertOrUpdate(payload));
    }

    /**
     * 项目事件日志功能管理-修改状态
     *
     * @param id 主键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/updateStatus")
    @ApiOperation("项目事件日志功能管理-修改状态")
    public TwOutputUtil<PmsProjectEventLogVO> updateStatus(Long id) {
        pmsProjectEventLogService.updateStatus(id);
        return TwOutputUtil.ok();
    }

    /**
     * 项目事件日志功能管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("项目事件日志功能管理-主键查询")
    public TwOutputUtil<PmsProjectEventLogVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectEventLogService.queryByKey(key));
    }

    /**
     * 项目事件日志功能管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("项目事件日志功能管理-分页")
    public TwOutputUtil<PagingVO<PmsProjectEventLogVO>> paging(PmsProjectEventLogQuery query) {
        return TwOutputUtil.ok(pmsProjectEventLogService.queryPaging(query));
    }

    /**
     * 项目事件日志功能管理-事件推送分页
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryPushPaging")
    @UdcNameClass
    @ApiOperation("项目事件日志功能管理-事件推送分页")
    public TwOutputUtil<PagingVO<PmsProjectEventLogVO>> queryPushPaging(PmsProjectEventLogQuery query) {
        return TwOutputUtil.ok(pmsProjectEventLogService.queryPushPaging(query));
    }


    /**
     * 项目事件日志功能管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目事件日志功能管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectEventLogService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 下载模板
     *
     * @return result
     */
    @ApiOperation("下载模板")
    @GetMapping("/batchExport")
    public void batchExport(HttpServletResponse response) {
        pmsProjectEventLogService.downloadPlus(response);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport/{projectId}", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    @GlobalTransactional
    public TwOutputUtil batchImport(MultipartFile file, @PathVariable Long projectId) {
        pmsProjectEventLogService.importEmployees(file, projectId);
        return TwOutputUtil.ok();
    }

    /**
     * 导出excel
     *
     * @return result
     */
    @ApiOperation("导出excel")
    @GetMapping(value = "/exportExcel")
    public void exportExcel(PmsProjectEventLogQuery query, HttpServletResponse response) {
        pmsProjectEventLogService.exportExcel(query, response);
    }
}

