package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummaryPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummaryQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSummaryService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummaryVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目会议纪要
 *
 * @author zoey
 * @date 2024-05-28
 */
@Api(tags = "项目会议纪要")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectSummary")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.PMS_PROJECT_SUMMARY)
public class PmsProjectSummaryController {

    private final PmsProjectSummaryService pmsProjectSummaryService;

    /**
     * 项目会议纪要-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目会议纪要-新增")
    public TwOutputUtil<PmsProjectSummaryVO> insert(@RequestBody PmsProjectSummaryPayload payload) {
        return TwOutputUtil.ok(pmsProjectSummaryService.insert(payload));
    }

    /**
     * 项目会议纪要-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("项目会议纪要-更新")
    public TwOutputUtil<PmsProjectSummaryVO> update(@RequestBody PmsProjectSummaryPayload payload) {
        return TwOutputUtil.ok(pmsProjectSummaryService.update(payload));
    }

    /**
     * 项目会议纪要-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("项目会议纪要-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsProjectSummaryPayload payload) {
        return TwOutputUtil.ok(pmsProjectSummaryService.updateByKeyDynamic(payload));
    }

    /**
     * 项目会议纪要-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("项目会议纪要-主键查询")
    public TwOutputUtil<PmsProjectSummaryVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectSummaryService.queryByKey(key));
    }

    /**
     * 项目会议纪要-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/paging")
    @UdcNameClass
    @ApiOperation("项目会议纪要-分页")
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.PROJECT_SUMMARHY_PAGE, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<PmsProjectSummaryVO>> paging(@RequestBody PmsProjectSummaryQuery query) {
//        return TwOutputUtil.ok(pmsProjectSummaryService.queryPaging(query));
        final PagingVO<PmsProjectSummaryVO> paging = pmsProjectSummaryService.pagingPermission(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 项目会议纪要-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/list")
    @UdcNameClass
    @ApiOperation("项目会议纪要-查询列表")
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.PROJECT_SUMMARHY_LIST, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<List<PmsProjectSummaryVO>> queryList(@RequestBody PmsProjectSummaryQuery query) {
//        return TwOutputUtil.ok(pmsProjectSummaryService.queryListDynamic(query));
        List<PmsProjectSummaryVO> pmsProjectSummaryVOS = pmsProjectSummaryService.listPermissionDynamic(query);
        return TwOutputUtil.ok(pmsProjectSummaryVOS);
    }

    /**
     * 项目会议纪要-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目会议纪要-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectSummaryService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

