package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummarySettingPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummarySettingQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSummarySettingService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummarySettingVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 会议纪要配置
 *
 * @author zoey
 * @date 2024-05-28
 */
@Api(tags = "会议纪要配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectSummarySetting")
@Slf4j
public class PmsProjectSummarySettingController {

    private final PmsProjectSummarySettingService pmsProjectSummarySettingService;

    /**
     * 会议纪要配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("会议纪要配置-新增")
    public TwOutputUtil<PmsProjectSummarySettingVO> insert(@RequestBody PmsProjectSummarySettingPayload payload) {
        return TwOutputUtil.ok(pmsProjectSummarySettingService.insert(payload));
    }

    /**
     * 会议纪要配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("会议纪要配置-更新")
    public TwOutputUtil<PmsProjectSummarySettingVO> update(@RequestBody PmsProjectSummarySettingPayload payload) {
        return TwOutputUtil.ok(pmsProjectSummarySettingService.update(payload));
    }

    /**
     * 会议纪要配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("会议纪要配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsProjectSummarySettingPayload payload) {
        return TwOutputUtil.ok(pmsProjectSummarySettingService.updateByKeyDynamic(payload));
    }

    /**
     * 会议纪要配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("会议纪要配置-主键查询")
    public TwOutputUtil<PmsProjectSummarySettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectSummarySettingService.queryByKey(key));
    }

    /**
     * 会议纪要配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("会议纪要配置-分页")
    public TwOutputUtil<PagingVO<PmsProjectSummarySettingVO>> paging(PmsProjectSummarySettingQuery query) {
        return TwOutputUtil.ok(pmsProjectSummarySettingService.queryPaging(query));
    }

    /**
     * 会议纪要配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("会议纪要配置-查询列表")
    public TwOutputUtil<List<PmsProjectSummarySettingVO>> queryList(PmsProjectSummarySettingQuery query) {
        return TwOutputUtil.ok(pmsProjectSummarySettingService.queryListDynamic(query));
    }

    /**
     * 会议纪要配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("会议纪要配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectSummarySettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 项目会议纪要-查询当前登陆人权限下的项目列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("project/list")
    @UdcNameClass
    @ApiOperation("项目会议纪要-查询当前登陆人权限下的项目列表")
    public TwOutputUtil<List<PmsProjectVO>> queryList(Long pmResId, String workType) {
        return TwOutputUtil.ok(pmsProjectSummarySettingService.queryProjList(pmResId, workType));
    }

}

