package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectMembersVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.BuProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QBuProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.BuProjectMembersRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * BU项目成员管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Repository
@RequiredArgsConstructor
public class BuProjectMembersDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BuProjectMembersRepo repo;
    private final QBuProjectMembersDO qdo = QBuProjectMembersDO.buProjectMembersDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BuProjectMembersVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BuProjectMembersVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 项目ID
                qdo.projId,
                // 角色
                qdo.role,
                // 复合能力ID
                qdo.capasetLevelId,
                // 资源id
                qdo.resId,
                // 预计开始日期
                qdo.planStartDate,
                // 预计结束日期
                qdo.planEndDate,
                // 规划当量
                qdo.planEqva,
                // 工作台默认显示
                qdo.workbenchFlag,
                // 客户结算价
                qdo.customerPrice,
                // 工种子类1
                qdo.jobType1,
                // 工种子类2
                qdo.jobType2,
                // 复合能力级别
                qdo.leveldId,
                // 复合能力级别
                qdo.leveldName
//                // 任务包ID
//                qdo.taskPackageId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BuProjectMembersVO> getJpaQueryWhere(BuProjectMembersQuery query) {
        JPAQuery<BuProjectMembersVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BuProjectMembersQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BuProjectMembersQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 项目ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            list.add(qdo.projId.eq(query.getProjId()));
        }
        /** 角色 精确 */
        if (!ObjectUtils.isEmpty(query.getRole())) {
            list.add(qdo.role.eq(query.getRole()));
        }
        /** 复合能力ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCapasetLevelId())) {
            list.add(qdo.capasetLevelId.eq(query.getCapasetLevelId()));
        }
        /** 资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getResId())) {
            list.add(qdo.resId.eq(query.getResId()));
        }
        /** 预计开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanStartDate())) {
            list.add(qdo.planStartDate.eq(query.getPlanStartDate()));
        }
        /** 预计结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEndDate())) {
            list.add(qdo.planEndDate.eq(query.getPlanEndDate()));
        }
        /** 规划当量 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEqva())) {
            list.add(qdo.planEqva.eq(query.getPlanEqva()));
        }
        /** 工作台默认显示 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkbenchFlag())) {
            list.add(qdo.workbenchFlag.eq(query.getWorkbenchFlag()));
        }
        /** 客户结算价 精确 */
        if (!ObjectUtils.isEmpty(query.getCustomerPrice())) {
            list.add(qdo.customerPrice.eq(query.getCustomerPrice()));
        }
        /** 工种子类1 精确 */
        if (!ObjectUtils.isEmpty(query.getJobType1())) {
            list.add(qdo.jobType1.eq(query.getJobType1()));
        }
        /** 工种子类2 精确 */
        if (!ObjectUtils.isEmpty(query.getJobType2())) {
            list.add(qdo.jobType2.eq(query.getJobType2()));
        }
        /** 复合能力级别 精确 */
        if (!ObjectUtils.isEmpty(query.getLeveldId())) {
            list.add(qdo.leveldId.eq(query.getLeveldId()));
        }
        /** 复合能力级别 精确 */
        if (!ObjectUtils.isEmpty(query.getLeveldName())) {
            list.add(qdo.leveldName.eq(query.getLeveldName()));
        }
//        /** 任务包ID 精确 */
//        if (!ObjectUtils.isEmpty(query.getTaskPackageId())) {
//            list.add(qdo.taskPackageId.eq(query.getTaskPackageId()));
//        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BuProjectMembersVO queryByKey(Long id) {
        JPAQuery<BuProjectMembersVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BuProjectMembersVO> queryListDynamic(BuProjectMembersQuery query) {
        JPAQuery<BuProjectMembersVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BuProjectMembersVO> queryPaging(BuProjectMembersQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<BuProjectMembersVO> jpaQuery = getJpaQueryWhere(query);
        List<BuProjectMembersVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BuProjectMembersVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BuProjectMembersDO save(BuProjectMembersDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BuProjectMembersDO> saveAll(List<BuProjectMembersDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BuProjectMembersPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 项目ID
        if (payload.getProjId() != null) {
            update.set(qdo.projId, payload.getProjId());
        }
        // 角色
        if (payload.getRole() != null) {
            update.set(qdo.role, payload.getRole());
        }
        // 复合能力ID
        if (payload.getCapasetLevelId() != null) {
            update.set(qdo.capasetLevelId, payload.getCapasetLevelId());
        }
        // 资源id
        if (payload.getResId() != null) {
            update.set(qdo.resId, payload.getResId());
        }
        // 预计开始日期
        if (payload.getPlanStartDate() != null) {
            update.set(qdo.planStartDate, payload.getPlanStartDate());
        }
        // 预计结束日期
        if (payload.getPlanEndDate() != null) {
            update.set(qdo.planEndDate, payload.getPlanEndDate());
        }
        // 规划当量
        if (payload.getPlanEqva() != null) {
            update.set(qdo.planEqva, payload.getPlanEqva());
        }
        // 工作台默认显示
        if (payload.getWorkbenchFlag() != null) {
            update.set(qdo.workbenchFlag, payload.getWorkbenchFlag());
        }
        // 客户结算价
        if (payload.getCustomerPrice() != null) {
            update.set(qdo.customerPrice, payload.getCustomerPrice());
        }
        // 工种子类1
        if (payload.getJobType1() != null) {
            update.set(qdo.jobType1, payload.getJobType1());
        }
        // 工种子类2
        if (payload.getJobType2() != null) {
            update.set(qdo.jobType2, payload.getJobType2());
        }
        // 复合能力级别
        if (payload.getLeveldId() != null) {
            update.set(qdo.leveldId, payload.getLeveldId());
        }
        // 复合能力级别
        if (payload.getLeveldName() != null) {
            update.set(qdo.leveldName, payload.getLeveldName());
        }
//        // 任务包ID
//        if (payload.getTaskPackageId() != null) {
//            update.set(qdo.taskPackageId, payload.getTaskPackageId());
//        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 项目ID
            if (nullFields.contains("projId")) {
                update.setNull(qdo.projId);
            }
            // 角色
            if (nullFields.contains("role")) {
                update.setNull(qdo.role);
            }
            // 复合能力ID
            if (nullFields.contains("capasetLevelId")) {
                update.setNull(qdo.capasetLevelId);
            }
            // 资源id
            if (nullFields.contains("resId")) {
                update.setNull(qdo.resId);
            }
            // 预计开始日期
            if (nullFields.contains("planStartDate")) {
                update.setNull(qdo.planStartDate);
            }
            // 预计结束日期
            if (nullFields.contains("planEndDate")) {
                update.setNull(qdo.planEndDate);
            }
            // 规划当量
            if (nullFields.contains("planEqva")) {
                update.setNull(qdo.planEqva);
            }
            // 工作台默认显示
            if (nullFields.contains("workbenchFlag")) {
                update.setNull(qdo.workbenchFlag);
            }
            // 客户结算价
            if (nullFields.contains("customerPrice")) {
                update.setNull(qdo.customerPrice);
            }
            // 工种子类1
            if (nullFields.contains("jobType1")) {
                update.setNull(qdo.jobType1);
            }
            // 工种子类2
            if (nullFields.contains("jobType2")) {
                update.setNull(qdo.jobType2);
            }
            // 复合能力级别
            if (nullFields.contains("leveldId")) {
                update.setNull(qdo.leveldId);
            }
            // 复合能力级别
            if (nullFields.contains("leveldName")) {
                update.setNull(qdo.leveldName);
            }
//            // 任务包ID
//            if (nullFields.contains("taskPackageId")) {
//                update.setNull(qdo.taskPackageId);
//            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<BuProjectMembersVO> queryByKeys(List<Long> ids) {
        JPAQuery<BuProjectMembersVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    public BuProjectMembersVO queryByProjAndRes(Long projId, Long resId) {
        JPAQuery<BuProjectMembersVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.projId.eq(projId));
        jpaQuery.where(qdo.resId.eq(resId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }
}

