package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
@Entity
@Table(name = "pms_distribute", indexes = {
        @Index(name = "reason_id_index", columnList = "reason_id"),
        @Index(name = "reason_type_index", columnList = "reason_type")
})
@org.hibernate.annotations.Table(appliesTo = "pms_distribute", comment = "派发")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsDistributeDO extends BaseModel implements Serializable  {
    /** 派发类型 */
    @Comment("派发类型")
    @Column(name = "reason_type")
    private String reasonType;
    /** 派发事由ID */
    @Comment("派发事由ID")
    @Column(name = "reason_id")
    private Long reasonId;
    @Comment("派发事由")
    @Column()
    private String reasonName;
    /** 派发编号 */
    @Comment("派发编号")
    @Column()
    private String distNo;
    /** 指派资源ID */
    @Comment("指派资源ID")
    @Column()
    private Long disterResId;
    /** 接收资源ID */
    @Comment("接收资源ID")
    @Column()
    private Long receiverResId;
    /** 派发状态 */
    @Comment("派发状态")
    @Column()
    private String distStatus;
    /** 审批状态 */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /** 派发方式 */
    @Comment("派发方式")
    @Column()
    private String distMethod;
    /** 派发说明 */
    @Comment("派发说明")
    @Column()
    private String distDesc;
    /** 复合能力 */
    @Comment("复合能力")
    @Column()
    private Long capasetLevelId;
    @Comment("单项能力")
    @Column()
    private String capaIds;
    /** 预计开始日期 */
    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;
    /** 预计结束日期 */
    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;




    @Comment("流程定义的KEY")
    @Column()
    private String procDefKey;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("工作地国家")
    @Column()
    private String workCountry;

    @Comment("工作地省")
    @Column()
    private String workProvince;

    @Comment("现场远程")
    @Column()
    private String workStyle;


    @Comment("时间要求")
    @Column()
    private String timeRequirement;


    @Comment("兼职|全职")
    @Column()
    private String workMethod;


    @Comment("工作地")
    @Column()
    private String workPlace;

    @Comment("最低信用级别")
    @Column()
    private String minSecurityLevel;


    public void copy(PmsDistributeDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
