package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 项目事件日志功能管理
 *
 * @author carl
 * @date 2023-09-18
 */
@Entity
@Table(name = "pms_project_event_log", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_event_log", comment = "项目事件日志功能管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectEventLogDO extends BaseModel implements Serializable {
    /**
     * 项目主键
     */
    @Comment("项目主键")
    @Column()
    private Long projectId;
    /**
     * 事件内容及来源
     */
    @Comment("事件内容及来源")
    @Column()
    private String eventContentSource;
    /**
     * 可能产生的影响
     */
    @Comment("可能产生的影响")
    @Column()
    private String possibleImpacts;
    /**
     * 所属类型
     */
    @Comment("所属类型")
    @Column()
    private String type;
    /**
     * 严重程度
     */
    @Comment("严重程度")
    @Column()
    private String severity;
    /**
     * 发生几率
     */
    @Comment("发生几率")
    @Column()
    private String probabilityOfOccurrence;
    /**
     * 风险程度
     */
    @Comment("风险程度")
    @Column()
    private String riskLevel;
    /**
     * 应对策略
     */
    @Comment("应对策略")
    @Column(columnDefinition = "text")
    private String copingStrategy;
    /**
     * 预计结束时间
     */
    @Comment("预计结束时间")
    @Column()
    private LocalDate expectedEndDate;
    /**
     * 负责人
     */
    @Comment("负责人")
    @Column()
    private Long headResId;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String status;
    /**
     * 完成时间
     */
    @Comment("完成时间")
    @Column()
    private LocalDateTime finishTime;

    public void copy(PmsProjectEventLogDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
