package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 资源计划人天明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Entity
@Table(name = "pms_resource_plan_days", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_resource_plan_days", comment = "资源计划人天明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsResourcePlanDaysDO extends BaseModel implements Serializable  {
    /** 关联资源计划ID */
    @Comment("关联资源计划ID")
    @Column()
    private Long planId;
    /** 规划角色明细ID */
    @Comment("规划角色明细ID")
    @Column()
    private Long roleDetailId;
    /** 年周 */
    @Comment("年周")
    @Column()
    private String yearWeek;
    /** 规划工作天数 */
    @Comment("规划工作天数")
    @Column()
    private BigDecimal days;

    @Comment("开始时间")
    @Column()
    private LocalDate startDate;

    public void copy(PmsResourcePlanDaysDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
