package com.elitesland.tw.tw5.server.prd.purchase.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.TPurchaseContractOverPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.TPurchaseContractOverQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QTPurchaseContractOverDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.TPurchaseContractOverDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.TPurchaseContractOverRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 采购合同终止
 *
 * @author lemon
 * @date 2023-10-19
 */
@Repository
@RequiredArgsConstructor
public class TPurchaseContractOverDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TPurchaseContractOverRepo repo;
    private final QTPurchaseContractOverDO qdo = QTPurchaseContractOverDO.tPurchaseContractOverDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TPurchaseContractOverVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TPurchaseContractOverVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.cre   ator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 合同终止编号
                qdo.overNo,
                // 申请人资源ID
                qdo.applyResId,
                // 合同终止状态
                qdo.overStatus,
                // 采购合同ID
                qdo.contractId,
                // 采购合同编号
                qdo.contractNo,
                // 终止原因
                qdo.overWhy,
                // 终止日期
                qdo.overTime,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TPurchaseContractOverVO> getJpaQueryWhere(TPurchaseContractOverQuery query) {
        JPAQuery<TPurchaseContractOverVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TPurchaseContractOverQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TPurchaseContractOverQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 合同终止编号 精确 */
        if (!ObjectUtils.isEmpty(query.getOverNo())) {
            list.add(qdo.overNo.eq(query.getOverNo()));
        }
        /** 申请人资源ID 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 合同终止状态 精确 */
        if (!ObjectUtils.isEmpty(query.getOverStatus())) {
            list.add(qdo.overStatus.eq(query.getOverStatus()));
        }
        /** 采购合同ID 精确 */
        if (!ObjectUtils.isEmpty(query.getContractId())) {
            list.add(qdo.contractId.eq(query.getContractId()));
        }
        /** 采购合同编号 精确 */
        if (!ObjectUtils.isEmpty(query.getContractNo())) {
            list.add(qdo.contractNo.eq(query.getContractNo()));
        }
        /** 终止原因 精确 */
        if (!ObjectUtils.isEmpty(query.getOverWhy())) {
            list.add(qdo.overWhy.eq(query.getOverWhy()));
        }
        /** 终止日期 精确 */
        if (!ObjectUtils.isEmpty(query.getOverTime())) {
            list.add(qdo.overTime.eq(query.getOverTime()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TPurchaseContractOverVO queryByKey(Long id) {
        JPAQuery<TPurchaseContractOverVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据合同id查询
     *
     * @param contractId
     * @return 结果
     */
    public TPurchaseContractOverVO queryByConId(Long contractId) {
        JPAQuery<TPurchaseContractOverVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.contractId.eq(contractId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TPurchaseContractOverVO> queryListDynamic(TPurchaseContractOverQuery query) {
        JPAQuery<TPurchaseContractOverVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TPurchaseContractOverVO> queryPaging(TPurchaseContractOverQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TPurchaseContractOverVO> jpaQuery = getJpaQueryWhere(query);
        List<TPurchaseContractOverVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TPurchaseContractOverVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TPurchaseContractOverDO save(TPurchaseContractOverDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TPurchaseContractOverDO> saveAll(List<TPurchaseContractOverDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TPurchaseContractOverPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 合同终止编号
        if (payload.getOverNo() != null) {
            update.set(qdo.overNo, payload.getOverNo());
        }
        // 申请人资源ID
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 合同终止状态
        if (payload.getOverStatus() != null) {
            update.set(qdo.overStatus, payload.getOverStatus());
        }
        // 采购合同ID
        if (payload.getContractId() != null) {
            update.set(qdo.contractId, payload.getContractId());
        }
        // 采购合同编号
        if (payload.getContractNo() != null) {
            update.set(qdo.contractNo, payload.getContractNo());
        }
        // 终止原因
        if (payload.getOverWhy() != null) {
            update.set(qdo.overWhy, payload.getOverWhy());
        }
        // 终止日期
        if (payload.getOverTime() != null) {
            update.set(qdo.overTime, payload.getOverTime());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 合同终止编号
            if (nullFields.contains("overNo")) {
                update.setNull(qdo.overNo);
            }
            // 申请人资源ID
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 合同终止状态
            if (nullFields.contains("overStatus")) {
                update.setNull(qdo.overStatus);
            }
            // 采购合同ID
            if (nullFields.contains("contractId")) {
                update.setNull(qdo.contractId);
            }
            // 采购合同编号
            if (nullFields.contains("contractNo")) {
                update.setNull(qdo.contractNo);
            }
            // 终止原因
            if (nullFields.contains("overWhy")) {
                update.setNull(qdo.overWhy);
            }
            // 终止日期
            if (nullFields.contains("overTime")) {
                update.setNull(qdo.overTime);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

