package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.CostUndertakeDepartmentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.CostUndertakeDepartmentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.CostUndertakeDepartmentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.CostUndertakeDepartmentVO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.CostUndertakeDepartmentConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.CostUndertakeDepartmentDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.CostUndertakeDepartmentDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.CostUndertakeDepartmentRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 费用承担部门
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CostUndertakeDepartmentServiceImpl extends BaseServiceImpl implements CostUndertakeDepartmentService {

    private final CostUndertakeDepartmentRepo costUndertakeDepartmentRepo;
    private final CostUndertakeDepartmentDAO costUndertakeDepartmentDAO;

    @Override
    public PagingVO<CostUndertakeDepartmentVO> queryPaging(CostUndertakeDepartmentQuery query) {
        return costUndertakeDepartmentDAO.queryPaging(query);
    }

    @Override
    public List<CostUndertakeDepartmentVO> queryListDynamic(CostUndertakeDepartmentQuery query) {
        return costUndertakeDepartmentDAO.queryListDynamic(query);
    }

    @Override
    public CostUndertakeDepartmentVO queryByKey(Long key) {
        CostUndertakeDepartmentDO entity = costUndertakeDepartmentRepo.findById(key).orElseGet(CostUndertakeDepartmentDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CostUndertakeDepartmentVO vo = CostUndertakeDepartmentConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CostUndertakeDepartmentVO insert(CostUndertakeDepartmentPayload payload) {
        CostUndertakeDepartmentDO entityDo = CostUndertakeDepartmentConvert.INSTANCE.toDo(payload);
        return CostUndertakeDepartmentConvert.INSTANCE.toVo(costUndertakeDepartmentRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CostUndertakeDepartmentVO update(CostUndertakeDepartmentPayload payload) {
        CostUndertakeDepartmentDO entity = costUndertakeDepartmentRepo.findById(payload.getId()).orElseGet(CostUndertakeDepartmentDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CostUndertakeDepartmentDO entityDo = CostUndertakeDepartmentConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CostUndertakeDepartmentConvert.INSTANCE.toVo(costUndertakeDepartmentRepo.save(entity));
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByPaymentApplyId(Long paymentApplyId) {
        costUndertakeDepartmentDAO.deleteByPaymentApplyId(paymentApplyId);
    }

    @Override
    public List<CostUndertakeDepartmentVO> queryListByPaymentApplyId(Long paymentApplyId) {
        return costUndertakeDepartmentDAO.queryListByPaymentApplyId(paymentApplyId);
    }


    @Override
    public List<CostUndertakeDepartmentVO> queryListByInvoiceNo(String invoiceNo) {
        return costUndertakeDepartmentDAO.queryListByJdeInvoiceNo(invoiceNo);
    }

    public List<CostUndertakeDepartmentVO> queryListByInvoiceNos(PaymentSlipPayload payload) {
        return costUndertakeDepartmentDAO.queryListByJdeInvoiceNos(payload);
    }

    @Override
    public List<CostUndertakeDepartmentVO> queryListByJdePaymentApplyIdOrInvoiceNo(String invoiceNo, Long paymentApplyId) {
        return costUndertakeDepartmentDAO.queryListByJdePaymentApplyIdOrInvoiceNo(invoiceNo, paymentApplyId);
    }

    @Override
    public void updateCostUndertakeDepartmentIds(List<Long> ids) {
         costUndertakeDepartmentDAO.queryTW4IdsByIdsupdateCostUndertakeDepartmentIds(ids);
    }


}
