package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementDetailsVO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementDetailsRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 采购协议明细
 *
 * @author Echo
 * @date 2023-06-08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchaseAgreementDetailsServiceImpl extends BaseServiceImpl implements PurchaseAgreementDetailsService {

    private final PurchaseAgreementDetailsRepo purchaseAgreementDetailsRepo;
    private final PurchaseAgreementRepo purchaseAgreementRepo;
    private final PurchaseAgreementDetailsDAO purchaseAgreementDetailsDAO;
    @Autowired
    private PurchaseAgreementServiceImpl purchaseAgreementService;

    private final PrdProductClassRepo productClassRepo;
    private final PrdProductRepo productRepo;

    @Override
    public PagingVO<PurchaseAgreementDetailsVO> queryPaging(PurchaseAgreementDetailsQuery query) {
        PagingVO<PurchaseAgreementDetailsVO> paging = purchaseAgreementDetailsDAO.queryPaging(query);
        List<PurchaseAgreementDetailsVO> records = paging.getRecords();
        transfer(records);
        return paging;
    }

    @Override
    public List<PurchaseAgreementDetailsVO> queryListDynamic(PurchaseAgreementDetailsQuery query) {
        List<PurchaseAgreementDetailsVO> vos = purchaseAgreementDetailsDAO.queryListDynamic(query);
        transfer(vos);
        return vos;
    }

    @Override
    public PurchaseAgreementDetailsVO queryByKey(Long key) {
        PurchaseAgreementDetailsDO entity = purchaseAgreementDetailsRepo.findById(key).orElseGet(PurchaseAgreementDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchaseAgreementDetailsVO vo = PurchaseAgreementDetailsConvert.INSTANCE.toVo(entity);
        transfer(Collections.singletonList(vo));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementDetailsVO insert(PurchaseAgreementDetailsPayload payload) {
        PurchaseAgreementDetailsDO entityDo = PurchaseAgreementDetailsConvert.INSTANCE.toDo(payload);
        //插入子表
        PurchaseAgreementDetailsDO save = purchaseAgreementDetailsRepo.save(entityDo);

        //修改主表的金额、税率、税额
        extracted(payload);

        return PurchaseAgreementDetailsConvert.INSTANCE.toVo(save);
    }

    private void extracted(PurchaseAgreementDetailsPayload payload) {
        //1. 查询所有子表
        PurchaseAgreementDetailsQuery purchaseAgreementDetailsQuery = new PurchaseAgreementDetailsQuery();
        purchaseAgreementDetailsQuery.setAgreementId(payload.getAgreementId());
        List<PurchaseAgreementDetailsVO> vos = queryListDynamic(purchaseAgreementDetailsQuery);
        List<PurchaseAgreementDetailsPayload> purchaseAgreementDetailsPayloads = PurchaseAgreementDetailsConvert.INSTANCE.toPayloadList(vos);
        //2. 查询主表
        PurchaseAgreementPayload purchaseAgreementPayload = PurchaseAgreementConvert.INSTANCE.toPayload(purchaseAgreementService.queryByKey(payload.getAgreementId()));
        PurchaseAgreementDO purchaseAgreementDO = PurchaseAgreementConvert.INSTANCE.toDo(purchaseAgreementPayload);
        //3. 修改金额
        purchaseAgreementService.countTax(purchaseAgreementDetailsPayloads, purchaseAgreementDO);
        //4. 插入
        purchaseAgreementRepo.save(purchaseAgreementDO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementDetailsVO update(PurchaseAgreementDetailsPayload payload) {
        PurchaseAgreementDetailsDO entity = purchaseAgreementDetailsRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchaseAgreementDetailsDO entityDo = PurchaseAgreementDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PurchaseAgreementDetailsDO save = purchaseAgreementDetailsRepo.save(entity);
        //修改主表的金额、税率、税额
        extracted(payload);
        return PurchaseAgreementDetailsConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PurchaseAgreementDetailsPayload payload) {
        PurchaseAgreementDetailsDO entity = purchaseAgreementDetailsRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = purchaseAgreementDetailsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {

        if (!keys.isEmpty()) {
            PurchaseAgreementDetailsVO purchaseAgreementDetailsVO = purchaseAgreementDetailsDAO.queryByKey(keys.get(0));
            Long agreementId = purchaseAgreementDetailsVO.getAgreementId();
            keys.stream().forEach(id -> {
                Optional<PurchaseAgreementDetailsDO> optional = purchaseAgreementDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    PurchaseAgreementDetailsDO entity = optional.get();
                }
            });
            purchaseAgreementDetailsDAO.deleteSoft(keys);
            //1. 查询所有子表
            PurchaseAgreementDetailsQuery purchaseAgreementDetailsQuery = new PurchaseAgreementDetailsQuery();
            purchaseAgreementDetailsQuery.setAgreementId(agreementId);
            List<PurchaseAgreementDetailsVO> vos = queryListDynamic(purchaseAgreementDetailsQuery);
            List<PurchaseAgreementDetailsPayload> purchaseAgreementDetailsPayloads = PurchaseAgreementDetailsConvert.INSTANCE.toPayloadList(vos);
            //2. 查询主表
            PurchaseAgreementPayload purchaseAgreementPayload = PurchaseAgreementConvert.INSTANCE.toPayload(purchaseAgreementService.queryByKey(agreementId));
            PurchaseAgreementDO purchaseAgreementDO = PurchaseAgreementConvert.INSTANCE.toDo(purchaseAgreementPayload);
            //3. 修改金额
            purchaseAgreementService.countTax(purchaseAgreementDetailsPayloads, purchaseAgreementDO);
            //4. 插入
            purchaseAgreementRepo.save(purchaseAgreementDO);
        }

    }

    @Override
    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        purchaseAgreementDetailsDAO.deleteSoftByDocumentIdList(documentIdList);
    }

    @Override
    public List<PurConOrAgreementDetailsSimpleVO> queryByPurAgreementId(Long purAgreementId) {
        return purchaseAgreementDetailsDAO.queryByPurAgreementId(purAgreementId);
    }


    private void transfer(List<PurchaseAgreementDetailsVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Long, String> productClassMap = productClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getId, PrdProductClassDO::getClassName, (key1, key2) -> key2));
        Map<Long, String> productMap = productRepo.findAll().stream().collect(Collectors.toMap(PrdProductDO::getId, PrdProductDO::getProdName, (key1, key2) -> key2));
        for (PurchaseAgreementDetailsVO vo : list) {
            Long relatedProductId = vo.getRelatedProductId();
            if (!ObjectUtils.isEmpty(relatedProductId)) {
                String relatedProductDesc = productMap.get(relatedProductId);
                if (StringUtils.hasText(relatedProductDesc)) {
                    vo.setRelatedProductName(relatedProductDesc);
                }
            }
            String classId = vo.getClassId();
            if (StringUtils.hasText(classId)) {
                String className = productClassMap.get(Long.parseLong(classId));
                if (StringUtils.hasText(className)) {
                    vo.setClassName(className);
                }
            }
            String subClassId = vo.getSubClassId();
            if (StringUtils.hasText(subClassId)) {
                String subClassName = productClassMap.get(Long.parseLong(subClassId));
                if (StringUtils.hasText(subClassName)) {
                    vo.setSubClassName(subClassName);
                }
            }

        }
    }

}
