package com.elitesland.tw.tw5.server.prd.purchase.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceVerDetailService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVerDetailVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.*;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentDefaultQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.*;
import com.elitesland.tw.tw5.api.prd.purchase.vo.*;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.CostUndertakeDepartmentConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchasePaymentConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.CostUndertakeDepartmentDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.CostUndertakeDepartmentRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchasePaymentRepo;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.Tuple;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 付款申请单
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchasePaymentServiceImpl extends BaseServiceImpl implements PurchasePaymentService {

    private final CostUndertakeDepartmentService costUndertakeDepartmentService;
    private final PurchasePaymentRepo purchasePaymentRepo;
    private final PurchasePaymentDAO purchasePaymentDAO;
    private final CostUndertakeDepartmentRepo costUndertakeDepartmentRepo;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final SaleConContractService saleConContractService;
    private final SaleConContractRepo saleConContractRepo;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    @Autowired
    private PurchaseContractManagerService purchaseContractManagerService;
    private final CrmOpportunityService crmOpportunityService;
    private final PurchaseAgreementRepo purchaseAgreementRepo;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final FileUtil fileUtil;
    private final PurchasePaymentPlanService purchasePaymentPlanService;
    private final PurchaseAgreementService purchaseAgreementService;
    private final PrdSystemRoleService systemRoleService;
    private final PaymentPlanReferService paymentPlanReferService;
    private final PaymentSlipService paymentSlipService;
    private final PmsProjectService pmsProjectService;
    private final ExcelUtil excelUtil;
    private final CacheUtil cacheUtil;
    @Value("${tw5.workflow.administrationBu}")
    private Long administrationBuId;
    private final BusinessPartnerService businessPartnerService;
    private final BookAccountService bookAccountService;
    private final ResWithdrawApplyService resWithdrawApplyService;
    private final InvInvoiceService invInvoiceService;
    private final InvInvoiceVerDetailService invInvoiceVerDetailService;
    private final BillVerDetailService billVerDetailService;
    private BeanSearcher beanSearcher;
    private final PurchaseContractDetailsService purchaseContractDetailsService;
    private final PurchaseAgreementDetailsService purchaseAgreementDetailsService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    @Override
    public PagingVO<PurchasePaymentVO> queryPaging(PurchasePaymentQuery query) {
        PagingVO<PurchasePaymentVO> purchasePaymentVOPagingVO = purchasePaymentDAO.queryPaging(query);
        // 翻译业务伙伴
        this.translateBusinessPartner(purchasePaymentVOPagingVO.getRecords());
        return purchasePaymentVOPagingVO;
    }


    @Override
    public PagingVO<PurchasePaymentVO> permissionPaging(PurchasePaymentQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PurchasePaymentVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List<PurchasePaymentVO> purchasePaymentVOS = beanSearcher.searchList(PurchasePaymentVO.class, mapBuilder.build());
        // 翻译
        this.translateBusinessPartner(purchasePaymentVOS);
        return PagingVO.<PurchasePaymentVO>builder().records(purchasePaymentVOS).total((Long) totalNum).build();
    }

    @Override
    public Map<String, List<WriteOffPaymentApplyVO>> findWriteOffByPrePaymentNoList(List<String> prePaymentApplyNoList) {
        List<WriteOffPaymentApplyVO> writeOffPaymentApplyVOList = purchasePaymentDAO.findWriteOffByPrePaymentNoList(prePaymentApplyNoList);
        return writeOffPaymentApplyVOList.stream().collect(Collectors.groupingBy(WriteOffPaymentApplyVO::getPrePaymentNo));
    }

    @Override
    public List<PurConOrAgreementDetailsSimpleVO> queryByPurConOrAgreementId(Long purConOrAgreementId, String docType) {
        // 采购合同采购明细
        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(docType)) {
            return purchaseContractDetailsService.queryByPurConId(purConOrAgreementId);
            // 采购协议采购明细
        } else if (PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode().equals(docType)) {
            return purchaseAgreementDetailsService.queryByPurAgreementId(purConOrAgreementId);
        }
        return null;
    }

    /**
     * @param invoiceNo 发票号
     * @return
     */
    @Override
    public List<CostUndertakeDepartmentVO> queryByPurConOrInvoiceNo(String invoiceNo) {
        List<CostUndertakeDepartmentVO> costUndertakeDepartmentVOS = costUndertakeDepartmentService.queryListByInvoiceNo(invoiceNo);
        return costUndertakeDepartmentVOS;
    }

    @Override
    public List<CostUndertakeDepartmentVO> queryByPurConOrInvoiceNos(PaymentSlipPayload payload) {
        List<CostUndertakeDepartmentVO> costUndertakeDepartmentVOS = costUndertakeDepartmentService.queryListByInvoiceNos(payload);
        return costUndertakeDepartmentVOS;
    }


    /**
     * 拼装where条件
     *
     * @param query 查询条件
     * @return 检索参数构建器
     */
    private MapBuilder pageWhereBuilder(PurchasePaymentQuery query) {
        MapBuilder builder = MapUtils.builder();
        // 付款申请单名称/编号
        if (!ObjectUtils.isEmpty(query.getPaymentNameOrNo())) {
            String likeStr = "%" + query.getPaymentNameOrNo() + "%";
            builder.field(PurchasePaymentVO::getPurchaseName, PurchasePaymentVO::getPaymentNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        // 付款申请单类型
        if (!ObjectUtils.isEmpty(query.getPaymentApplicationType())) {
            builder.field(PurchasePaymentVO::getPaymentApplicationType, query.getPaymentApplicationType()).op(FieldOps.Equal);
        }
        // 付款公司地址簿Id
        if (!ObjectUtils.isEmpty(query.getPayCompanyBookId())) {
            builder.field(PurchasePaymentVO::getPayCompanyBookId, query.getPayCompanyBookId()).op(FieldOps.Equal);
        }
        // 供应商
        if (!ObjectUtils.isEmpty(query.getSupplierLegalBookId())) {
            builder.field(PurchasePaymentVO::getSupplierLegalBookId, query.getSupplierLegalBookId()).op(FieldOps.Equal);
        }
        // 付款申请单状态
        if (!ObjectUtils.isEmpty(query.getState())) {
            builder.field(PurchasePaymentVO::getState, query.getState()).op(FieldOps.Equal);
        }
        // 验收方式
        if (!ObjectUtils.isEmpty(query.getAcceptanceType())) {
            builder.field(PurchasePaymentVO::getAcceptanceType, query.getAcceptanceType()).op(FieldOps.Equal);
        }
        // 关联销售合同
        if (!ObjectUtils.isEmpty(query.getRelatedSalesContract())) {
            builder.field(PurchasePaymentVO::getRelatedSalesContract, query.getRelatedSalesContract()).op(FieldOps.Equal);
        }
        // 关联项目号
        if (!ObjectUtils.isEmpty(query.getRelatedProjectNo())) {
            builder.field(PurchasePaymentVO::getRelatedProjectNo, query.getRelatedProjectNo()).op(FieldOps.Equal);
        }
        // ids
        if (!ObjectUtils.isEmpty(query.getIds())) {
            builder.field(PurchasePaymentVO::getId, query.getIds()).op(FieldOps.InList);
        }
        builder.field(PurchasePaymentVO::getDeleteFlag, 0).op(FieldOps.Equal);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    @Override
    public PurchasePaymentVO queryByKey(Long key) {
        // result
        PurchasePaymentVO purchasePaymentVO = purchasePaymentDAO.queryByKey(key);
        if (purchasePaymentVO == null) {
            return null;
        }
        // 查询费用承担部门
        List<CostUndertakeDepartmentVO> costUndertakeDepartmentVOS = costUndertakeDepartmentService.queryListByPaymentApplyId(key);
        purchasePaymentVO.setCostUndertakeDepartmentVOS(costUndertakeDepartmentVOS);
        // 设置付款计划
        purchasePaymentPlanService.setPaymentApplyVOPlanList(purchasePaymentVO);
        // 查询付款计划参考
        List<PaymentPlanReferVO> paymentPlanReferVOS = paymentPlanReferService.queryListByPaymentApplyId(key);
        if (!paymentPlanReferVOS.isEmpty()) {
            purchasePaymentVO.setPaymentPlanReferVOS(paymentPlanReferVOS);
        }
        // 查询付款单记录
        List<PaymentSlipVO> paymentSlipVOS = paymentSlipService.queryListByPaymentApplyId(key);
        if (!paymentSlipVOS.isEmpty()) {
            purchasePaymentVO.setPaymentSlipVOS(paymentSlipVOS);
        }
        // 查询提现申请单列表
        List<ResWithdrawApplyVO> resWithdrawApplyVOS = resWithdrawApplyService.queryListByPaymentApplyId(key);
        if (!resWithdrawApplyVOS.isEmpty()) {
            purchasePaymentVO.setResWithdrawApplyVOS(resWithdrawApplyVOS);
        }
        // 查询发票核销明细
        List<InvInvoiceVerDetailVO> invInvoiceVerDetailVOS = invInvoiceVerDetailService.queryListByPaymentApplyId(purchasePaymentVO.getDocType(), key);
        if (!invInvoiceVerDetailVOS.isEmpty()) {
            purchasePaymentVO.setInvInvoiceVerDetailVOS(invInvoiceVerDetailVOS);
        }

        // 查询票据核销明细
        List<BillVerDetailVO> billVerDetailPayloads = billVerDetailService.queryListByPaymentApplyId(purchasePaymentVO.getDocType(), key);
        if (!billVerDetailPayloads.isEmpty()) {
            for (BillVerDetailVO billVerDetailVO : billVerDetailPayloads) {
                //附件信息
                if (!ObjectUtils.isEmpty(billVerDetailVO.getFileCode())) {
                    Object fileData = fileUtil.getFileDatas(billVerDetailVO.getFileCode());
                    billVerDetailVO.setFileData(fileData);
                }
            }
            purchasePaymentVO.setBillVerDetailPayloads(billVerDetailPayloads);
        }
        // 付款依据附件数据
        purchasePaymentVO.setBasisFileDates(fileUtil.getFileDatas(purchasePaymentVO.getBasisFileCodes()));

        //附件
        if (StringUtils.isEmpty(purchasePaymentVO.getFileCode())) {
            purchasePaymentVO.setFileDate(fileUtil.getFileDatas(purchasePaymentVO.getFileCode()));
        }
        // 紧急付款凭证附件数据
        purchasePaymentVO.setUrgentPaymentDates(fileUtil.getFileDatas(purchasePaymentVO.getUrgentPaymentCodes()));

        //app要求返回付款申请单的创建人和级别
        if (purchasePaymentVO.getCreateUserId() != null) {
            Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(purchasePaymentVO.getCreateUserId());
            if (defaultOrgIdByUserId != null) {
                String orgName = cacheUtil.getOrgName(defaultOrgIdByUserId);
                purchasePaymentVO.setBuName(orgName);
            }
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(purchasePaymentVO.getCreateUserId());
            if (employee != null) {
                purchasePaymentVO.setGrade(employee.getExtString1());
            }
        }
        // 设置关联单据的Id
        this.setDocumentId(purchasePaymentVO);
        this.translateBusinessPartner(purchasePaymentVO);
        return purchasePaymentVO;
    }

    @Override
    public PurchasePaymentVO queryMainInfoByKey(Long key) {
        return purchasePaymentDAO.queryByKey(key);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchasePaymentVO insertOrUpdate(PurchasePaymentPayload payload) {
        // 校验
        this.check(payload);
        PurchasePaymentDO entityDo = PurchasePaymentConvert.INSTANCE.toDo(payload);
        // 新增Or修改标识
        boolean isInsert = false;
        // 发票核销明细
        List<InvInvoiceVerDetailPayload> invInvoiceVerDetailPayloads = payload.getInvInvoiceVerDetailPayloads();
        // 计算税额（根据发票号查询发票的明细拿出总金额amount_tax、税额deduct_tax，按照比例计算出选中发票的等比例税额）
        // 现在前端算
//        BigDecimal sumTaxAmount = this.countTaxAmt(invInvoiceVerDetailPayloads);
//        payload.setTaxAmount(sumTaxAmount);
//        entityDo.setTaxAmount(sumTaxAmount);
        // 操作记录
        String changeLog;
        // 主键
        Long id = payload.getId();
        // 新增
        if (id == null || id < 0) {
            isInsert = true;
            // 编号
            entityDo.setPaymentNo(generateSeqNum(GenerateSeqNumConstants.PURCHASE_PAYMENT_NO));
            // 保存申请单
            PurchasePaymentDO save = purchasePaymentRepo.save(entityDo);
            id = save.getId();
            entityDo.setId(id);
            payload.setId(id);
            entityDo.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
            changeLog = "新建付款申请单";
        } else {
            if (!payload.getIsSubmit() && !PurchasePaymentEnum.PaymentStatus.CREATE.getCode().equals(entityDo.getState())) {
                throw TwException.error("", "只有新建状态的单据才允许编辑！");
            }
            // 操作记录
            PurchasePaymentDO entity = purchasePaymentRepo.findById(id).orElseGet(PurchasePaymentDO::new);
            changeLog = changeFieldLogUtil.getFieldsUpdateLog(entityDo, entity);
            // 修改
            this.updateByKeyDynamic(payload);
        }
        // 设置scene--用于控制流程
        Triple<String, PurchaseContractManagerDO, PurchaseAgreementDO> scene = this.getScene(entityDo.getPaymentApplicationType(), entityDo.getDocType(), entityDo.getDocNo());
        entityDo.setScene(scene.getLeft());
        // 保存付款计划
        this.savePaymentPlan(payload, scene, isInsert);
        // 保存付款计划参考
        this.savePaymentPlanRefer(payload);
        // 保存操作记录
        if (StringUtils.hasText(changeLog)) {
            logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.PAYMENT_APPLY.getCode(), changeLog);
        }
        // 保存保存费用承担部门，如果为提交，那么校验金额
        this.saveCostUndertakeBu(payload, isInsert, payload.getIsSubmit());
        // 保存付款申请单记录
        this.savePaymentSlip(payload);
        // 保存发票核销明细，如果为提交，那么校验金额
        this.saveInvInvoiceVerDetail(payload, isInsert, payload.getIsSubmit());

        // 保存票据核销明细，如果为提交，那么校验金额
        this.saveBillVerDetail(payload, isInsert, payload.getIsSubmit());

        // 根据付款申请单类型做额外逻辑处理
        switch (PurchasePaymentEnum.PaymentType.match(entityDo.getPaymentApplicationType())) {
            // 如果场景是预付款核销单，则需要把前置预付款单的状态改为核销中
            case ADVANCE_PAY_WRITE_OFF -> {
                String prePaymentNo = entityDo.getPrePaymentNo();
                if (prePaymentNo != null) {
                    purchasePaymentDAO.updatePaymentStatus(prePaymentNo, PurchasePaymentEnum.PaymentStatus.WRITE_OFF_PROCESS);
                }
            }
            // 如果为预付款/采购协议 （2023-12-21 验收方式为提现申请单时，前端页面只有提交，没有保存，后端不需要考虑修改操作）
            case ADVANCE_PAY, AGREEMENT -> {
                // 更新提现单中的体现单状态为：发起付款处理，付款申请单id为业务id
                if (PurchasePaymentEnum.AcceptanceMethod.WITHDRAW.getCode().equals(payload.getAcceptanceType()) &&
                        !CollectionUtils.isEmpty(payload.getResWithdrawApplyPayloads())) {
                    List<Long> withdrawIds = payload.getResWithdrawApplyPayloads().stream().map(ResWithdrawApplyPayload::getId).toList();
                    resWithdrawApplyService.updateWithdrawStatusAndPaymentApplyIdByIds(id, withdrawIds, PurchasePaymentEnum.WithdrawStatus.APPROVING.getCode());
                }
            }
        }
        PurchasePaymentVO result = this.queryByKey(id);
        // 提交流程，非保存添加接口校验
        if (payload.getIsSubmit()) {
            this.submitPayment(result);
        }
        return result;
    }

    /**
     * 计算税额
     *
     * @param invInvoiceVerDetailPayloads payloads
     * @return 税额
     */
    private BigDecimal countTaxAmt(List<InvInvoiceVerDetailPayload> invInvoiceVerDetailPayloads) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(invInvoiceVerDetailPayloads)) {
            List<String> invoiceNos = invInvoiceVerDetailPayloads.stream().map(InvInvoiceVerDetailPayload::getInvoiceNo).toList();
            // 根据发票号查询 抵扣税额/价税合计
            Map<String, BigDecimal> decimalMap = invInvoiceService.findDeductTaxDeviceAmountTaxByNoIn(invoiceNos);
            for (InvInvoiceVerDetailPayload invInvoiceVerDetailPayload : invInvoiceVerDetailPayloads) {
                // 本次核销金额
                BigDecimal theAmt = invInvoiceVerDetailPayload.getTheAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getTheAmt();
                // 抵扣税额/价税合计
                String invoiceCode = invInvoiceVerDetailPayload.getInvoiceCode() == null ? "" : invInvoiceVerDetailPayload.getInvoiceCode();
                BigDecimal deductTaxDeviceAmountTax = decimalMap.get(invInvoiceVerDetailPayload.getInvoiceNo() + "-" + invoiceCode);
                deductTaxDeviceAmountTax = deductTaxDeviceAmountTax == null ? BigDecimal.ZERO : deductTaxDeviceAmountTax;
                BigDecimal taxAmount = deductTaxDeviceAmountTax.multiply(theAmt).setScale(2, RoundingMode.HALF_UP);
                sumTaxAmount = sumTaxAmount.add(taxAmount);
            }
        }
        return sumTaxAmount;
    }

    /**
     * 保存校验
     *
     * @param payload 数据
     */
    private void check(PurchasePaymentPayload payload) {
        if (payload.getCurrPaymentAmt() == null || payload.getCurrPaymentAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw TwException.error("", "本次付款/核销金额必须大于0");
        }
    }

    /**
     * 保存付款计划
     *
     * @param payload payload
     */
    private void savePaymentPlan(PurchasePaymentPayload payload, Triple<String, PurchaseContractManagerDO, PurchaseAgreementDO> scene, Boolean isInsert) {
        // 关联的合同
        PurchaseContractManagerDO purchaseContractManagerDO = scene.getMiddle();
        // 关联的协议
        PurchaseAgreementDO purchaseAgreementDO = scene.getRight();
        // 付款明细、计划
        List<PurchasePaymentPlanPayload> purchasePaymentPlanPayloads = payload.getPurchasePaymentPlanPayloads();
        // 付款金额不为（0或者null）的付款计划、明细（只有本次付款金额大于0时才更新）
        List<PurchasePaymentPlanPayload> eligiblePlanPayloads = new ArrayList<>();
        // 设置付款明细的付款申请单Id
        if (!CollectionUtils.isEmpty(purchasePaymentPlanPayloads)) {
            for (PurchasePaymentPlanPayload purchasePaymentPlanPayload : purchasePaymentPlanPayloads) {
                purchasePaymentPlanPayload.setPaymentApplyId(payload.getId());
                // 只有本次付款金额大于0时才更新
                if (purchasePaymentPlanPayload.getCurrentPaymentAmt() != null && purchasePaymentPlanPayload.getCurrentPaymentAmt().compareTo(BigDecimal.ZERO) > 0) {
                    eligiblePlanPayloads.add(purchasePaymentPlanPayload);
                }
            }
        }
        // 设置付款计划的关联单据id、编号（主要是为了将预付款时新建的付款计划与对应的合同关联上）
        if (!CollectionUtils.isEmpty(eligiblePlanPayloads)) {
            if (purchaseContractManagerDO != null) {
                eligiblePlanPayloads.forEach(purchasePaymentPlanPayload -> {
                    purchasePaymentPlanPayload.setContractNo(purchaseContractManagerDO.getPurchaseContractNo());
                    purchasePaymentPlanPayload.setContractId(purchaseContractManagerDO.getId());
                    purchasePaymentPlanPayload.setDocType(PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode());
                });
            } else if (purchaseAgreementDO != null) {
                eligiblePlanPayloads.forEach(purchasePaymentPlanPayload -> {
                    purchasePaymentPlanPayload.setContractNo(purchaseAgreementDO.getPurchaseAgreementNo());
                    purchasePaymentPlanPayload.setContractId(purchaseAgreementDO.getId());
                    purchasePaymentPlanPayload.setDocType(PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode());
                });
            }
            // 判断是新增还是更新
            boolean isPaymentPlanInsert = this.judgePaymentPlanIsInsert(payload.getPaymentApplicationType(), payload.getDocType());
            if (isPaymentPlanInsert) {
                if (!isInsert) {
                    purchasePaymentPlanService.deleteByPaymentId(payload.getId());
                }
                purchasePaymentPlanService.insertAll(eligiblePlanPayloads);
            } else {
                purchasePaymentPlanService.updatePlans(eligiblePlanPayloads);
            }
        }
    }

    /**
     * 保存付款申请单记录
     *
     * @param payload payload
     */
    private void savePaymentSlip(PurchasePaymentPayload payload) {
        List<PaymentSlipPayload> paymentSlipPayloads = payload.getPaymentSlipPayloads();
        // 预付款核销这里没有付款单记录
        if (!CollectionUtils.isEmpty(paymentSlipPayloads)
                && !Objects.equals(payload.getPaymentApplicationType(), PurchasePaymentEnum.PaymentType.ADVANCE_PAY_WRITE_OFF.getCode())) {
            paymentSlipPayloads.forEach(paymentSlipPayload -> paymentSlipPayload.setPaymentApplyId(payload.getId()));
            paymentSlipService.deleteByPaymentApplyId(payload.getId());
            paymentSlipService.insertAll(paymentSlipPayloads);
        }
    }

    /**
     * 保存付款计划参考（付款计划参考前端不能删除，故不用全删全插）
     *
     * @param payload payload
     */
    private void savePaymentPlanRefer(PurchasePaymentPayload payload) {
        List<PaymentPlanReferPayload> paymentPlanReferPayloads = payload.getPaymentPlanReferPayloads();
        // 只有预付款有付款计划参考
        if (!CollectionUtils.isEmpty(paymentPlanReferPayloads)
                && PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(payload.getPaymentApplicationType())) {
            paymentPlanReferPayloads.forEach(paymentPlanReferPayload -> paymentPlanReferPayload.setPaymentApplyId(payload.getId()));
            paymentPlanReferService.saveAll(paymentPlanReferPayloads);
        }
    }

    /**
     * 保存发票核销明细
     *
     * @param payload  payload
     * @param isInsert 是否为新增
     * @param isCheck  是否校验
     */
    private void saveInvInvoiceVerDetail(PurchasePaymentPayload payload, Boolean isInsert, Boolean isCheck) {
        // 预付款时无发票核销
        if (PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode().equals(payload.getPaymentApplicationType())) {
            return;
        }
        Map<String, BigDecimal> oldTheAmtMap = new HashMap<>();
        if (!isInsert) {
            // 查询原发票核销明细
            List<InvInvoiceVerDetailVO> invInvoiceVerDetailVOS = invInvoiceVerDetailService.queryListByPaymentApplyId(payload.getDocType(), payload.getId());
            if (!CollectionUtils.isEmpty(invInvoiceVerDetailVOS)) {
                invInvoiceVerDetailVOS.forEach(invInvoiceVerDetailVO -> {
                    // 键：发票号-发票代码
                    String invoiceCode = invInvoiceVerDetailVO.getInvoiceCode() == null ? "" : invInvoiceVerDetailVO.getInvoiceCode();
                    String key = invInvoiceVerDetailVO.getInvoiceNo() + "-" + invoiceCode;
                    // 值：本次核销金额
                    BigDecimal oldTheAmt = invInvoiceVerDetailVO.getTheAmt();
                    oldTheAmt = oldTheAmt == null ? BigDecimal.ZERO : oldTheAmt;
                    oldTheAmtMap.put(key, oldTheAmt);
                });
            }
            // 删除发票核销明细
            invInvoiceVerDetailService.deleteByPaymentApplyId(payload.getId());
        }
        List<InvInvoiceVerDetailPayload> invInvoiceVerDetailPayloads = payload.getInvInvoiceVerDetailPayloads();
        // 发票核销总金额
        final BigDecimal[] allTheAmt = {BigDecimal.ZERO};
        // 保存发票核销明细
        if (!CollectionUtils.isEmpty(invInvoiceVerDetailPayloads)) {
            Map<String, BigDecimal> newTheAmtMap = new HashMap<>();
            invInvoiceVerDetailPayloads.forEach(invInvoiceVerDetailPayload -> {
                // 本次核销金额
                BigDecimal theAmt = invInvoiceVerDetailPayload.getTheAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getTheAmt();
                // 键：发票号-发票代码，发票代码可能为null
                String invoiceCode = invInvoiceVerDetailPayload.getInvoiceCode() == null ? "" : invInvoiceVerDetailPayload.getInvoiceCode();
                String key = invInvoiceVerDetailPayload.getInvoiceNo() + "-" + invoiceCode;
                newTheAmtMap.put(key, theAmt);
                allTheAmt[0] = allTheAmt[0].add(theAmt);
                // 发票金额
                BigDecimal invoiceAmt = invInvoiceVerDetailPayload.getInvoiceAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getInvoiceAmt();
                // 已存核销金额
                BigDecimal writtenOffAmt = invInvoiceVerDetailPayload.getWrittenOffAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailPayload.getWrittenOffAmt();
                // 该条数据之前已保存的核销金额
                BigDecimal oldTheAmt = oldTheAmtMap.get(key) == null ? BigDecimal.ZERO : oldTheAmtMap.get(key);
                // 校验发票金额及核销金额发票金额需大于等于核销金额（已存核销金额+本次核销金额-该条数据之前已保存的核销金额）< 发票金额）
                if (writtenOffAmt.add(theAmt.subtract(oldTheAmt)).compareTo(invoiceAmt) > 0) {
                    throw TwException.error("", "发票号码为【" + invInvoiceVerDetailPayload.getInvoiceNo() + "】的发票总核销金额需小于发票金额");
                }
                // 设置付款申请单ID
                invInvoiceVerDetailPayload.setPaymentApplyId(payload.getId());
            });
            // 校验发票号+发票代码是否有重复的
            if (newTheAmtMap.size() < invInvoiceVerDetailPayloads.size()) {
                throw TwException.error("", "发票核销明细所选发票不可重复");
            }
            invInvoiceVerDetailService.insertAll(invInvoiceVerDetailPayloads);
            // 修改发票的已核销金额
            invInvoiceService.updateWrittenOffAmtByNo(newTheAmtMap, oldTheAmtMap);
        }
        // 薪酬福利支付时发票核销明细，可以不填写 当提交时或非薪酬福利支付时校验
//        if (isCheck && !PurchasePaymentEnum.PaymentType.SALARY_PAYMENT.getCode().equals(payload.getPaymentApplicationType())) {
//            // 校验发票核销金额 选中的发票核销金额与付款明细金额必须一致
//            BigDecimal currPaymentAmt = payload.getCurrPaymentAmt() == null ? BigDecimal.ZERO : payload.getCurrPaymentAmt();
//            if (allTheAmt[0].compareTo(currPaymentAmt) != 0 && (payload.getNoInvoiceVerification() != null && payload.getNoInvoiceVerification() != 1)) {
//                throw TwException.error("", "付款金额应与发票核销金额一致！");
//            }
//        }
    }

    /**
     * 保存费用承担部门
     *
     * @param payload  payload
     * @param isInsert 是否为新增
     * @param isCheck  是否校验
     */
    private void saveCostUndertakeBu(PurchasePaymentPayload payload, Boolean isInsert, Boolean isCheck) {
        // 预付款 + 薪酬福利支付时无费用承担部门
//        switch (PurchasePaymentEnum.PaymentType.match(payload.getPaymentApplicationType())) {
//            case ADVANCE_PAY, SALARY_PAYMENT -> {
//                return;
//            }
//        }
        if (!isInsert) {
            // 删除费用承担部门
            costUndertakeDepartmentService.deleteByPaymentApplyId(payload.getId());
        }
        // 保存费用承担部门
        List<CostUndertakeDepartmentPayload> costUndertakeDepartmentPayloads = payload.getCostUndertakeDepartmentPayloads();
        // 总费用承担金额
        final BigDecimal[] allBearAmt = {BigDecimal.ZERO};
        if (costUndertakeDepartmentPayloads != null) {
            List<CostUndertakeDepartmentDO> costUndertakeDepartmentDOS = new ArrayList<>(costUndertakeDepartmentPayloads.size());
            costUndertakeDepartmentPayloads.forEach(costUndertakeDepartmentPayload -> {
                costUndertakeDepartmentPayload.setId(null);
                costUndertakeDepartmentPayload.setPaymentApplyId(payload.getId());
                costUndertakeDepartmentDOS.add(CostUndertakeDepartmentConvert.INSTANCE.toDo(costUndertakeDepartmentPayload));
                BigDecimal bearAmt = costUndertakeDepartmentPayload.getBearAmt() == null ? BigDecimal.ZERO : costUndertakeDepartmentPayload.getBearAmt();
                allBearAmt[0] = allBearAmt[0].add(bearAmt);
            });
            costUndertakeDepartmentRepo.saveAll(costUndertakeDepartmentDOS);
        }
        if (isCheck) {
            // 校验费用承担部门 若有BU分摊金额，需要（付款金额-税额）与BU分摊金额一致;
            BigDecimal currPaymentAmt = payload.getCurrPaymentAmt() == null ? BigDecimal.ZERO : payload.getCurrPaymentAmt();
            // 税额
            BigDecimal taxAmount = payload.getTaxAmount() == null ? BigDecimal.ZERO : payload.getTaxAmount();
//            if (!CollectionUtils.isEmpty(costUndertakeDepartmentPayloads) && allBearAmt[0].compareTo(currPaymentAmt.subtract(taxAmount)) != 0
//                    && PurchasePaymentEnum.AccountModuleType.LEDGER.getCode().equals(payload.getAccountModuleType()) ) {
//                throw TwException.error("", "付款金额应与BU分摊金额一致！");
//            }
        }
    }


    @Override
    @Transactional
    public PurchasePaymentVO accountantApprove(PaymentAccountantApprovePayload payload) {
        PurchasePaymentPayload paymentPayload = new PurchasePaymentPayload();
        BeanUtil.copyProperties(payload, paymentPayload, CopyOptions.create().setIgnoreNullValue(true));
        // 修改主表信息
        this.updateByKeyDynamic(paymentPayload);
        // 保存付款申请单记录
        this.savePaymentSlip(paymentPayload);
        // 保存费用承担部门
        this.saveCostUndertakeBu(paymentPayload, false, true);
        // result
        PurchasePaymentVO purchasePaymentVO = this.queryByKey(payload.getId());
        // 提交流程
        this.submitPayment(purchasePaymentVO);
        return purchasePaymentVO;
    }

    /**
     * 设置scene--用于控制流程
     *
     * @param paymentApplicationType 付款申请单类型
     * @param docType                关联单据类型
     * @param docNo                  关联单据编号
     */
    private Triple<String, PurchaseContractManagerDO, PurchaseAgreementDO> getScene(String paymentApplicationType, String docType, String docNo) {
        // 采购合同
        PurchaseContractManagerDO purchaseContractManagerDO = null;
        // 采购合同类型
        String purchaseContractType = null;
        // 采购合同业务性质类型
        String businessType = null;
        // 采购协议
        PurchaseAgreementDO purchaseAgreementDO = null;
        // 采购协议类型
        String agreementType = null;
        // 采购协议签约BU
        Long signBuId = null;
        // 流程编号
        String scene = null;
        // 关联单据类型
        switch (PurchasePaymentEnum.PaymentDocType.match(docType)) {
            // 采购合同
            case CONTRACT -> {
                if (docNo == null) {
                    throw TwException.error("", "未找到相关的采购合同，请检查");
                }
                Optional<PurchaseContractManagerDO> purchaseContractDO = purchaseContractManagerRepo.findByPurchaseContractNo(docNo);
                if (purchaseContractDO.isEmpty()) {
                    throw TwException.error("", "未找到相关的采购合同，请检查");
                }
                purchaseContractManagerDO = purchaseContractDO.get();
//                purchaseContractType = purchaseContractManagerDO.getPurchaseContractType();
//                businessType = purchaseContractManagerDO.getBusinessType();
            }
            // 采购协议
            case AGREEMENT -> {
                if (docNo == null) {
                    throw TwException.error("", "未找到相关的采购协议，请检查");
                }
                Optional<PurchaseAgreementDO> purAgreementDO = purchaseAgreementRepo.findByPurchaseAgreementNo(docNo);
                if (purAgreementDO.isEmpty()) {
                    throw TwException.error("", "未找到相关的采购协议，请检查");
                }
                purchaseAgreementDO = purAgreementDO.get();
//                agreementType = purchaseAgreementDO.getAgreementType();
//                signBuId = purchaseAgreementDO.getSignBuId();
            }
        }
        // 付款申请单类型
        switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
            // 按照采购合同付款
            case CONTRACT -> {
                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_PAYMENT_PAY.getCode();
//                // 采购合同类型（合同类别）
//                switch (PurchaseContractEnum.PurchaseConType.match(purchaseContractType)) {
//                    // 资源赋能类采购(付款申请单资源赋能类流程)
//                    case RESOURCE -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_RESOURCE.getCode();
//                    // 公司管理类采购(付款申请单公司管理类流程)
//                    case COMPANY -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_COMPANY.getCode();
//                    // 行政运营类采购(付款申请单行政运营类采购流程)
//                    case OPERATE -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_OPERATE.getCode();
//                    // 研发类采购(付款申请单研发采购流程)
//                    case RESEARCH -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_RESEARCH.getCode();
//                    // 市场渠道(付款申请单市场渠道流程)
//                    case MARKET -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_MARKET.getCode();
//                    // 项目采购
//                    case PROJECT_PURCHASE -> {
//                        // 业务性质类型
//                        switch (PurchaseContractEnum.PurchaseBusinessType.match(businessType)) {
//                            // 房屋租赁(付款申请单房屋租赁流程)
//                            case HOUSE_RENTAL ->
//                                    scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_HOUSE_RENTAL.getCode();
//                            // 杂项采购(付款申请单杂项采购流程)
//                            case MIS_PURCHASE ->
//                                    scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_MIS_PURCHASE.getCode();
//                            // 其他业务性质
//                            default ->
//                                    throw TwException.error("", "采购合同类型为项目采购时业务性质类型为【" + PurchaseContractEnum.PurchaseBusinessType.match(businessType).getDesc() + "】时无法发起付款");
//                        }
//                    }
//                    // 合同采购
//                    case CON_PURCHASE -> {
//                        // 业务性质类型
//                        switch (PurchaseContractEnum.PurchaseBusinessType.match(businessType)) {
//                            // 服务贸易(付款申请单服务贸易流程)
//                            case TRADE_SERVICES ->
//                                    scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_TRADE_SERVICE.getCode();
//                            // 产品贸易(付款申请单产品贸易流程)
//                            case TRADE_PRODUCT ->
//                                    scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_TRADE_PRODUCT.getCode();
//                            // 外包(付款申请单外包流程)
//                            case OUTSOURCING -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_OUTSOURCING.getCode();
//                            // 其他业务性质
//                            default ->
//                                    throw TwException.error("", "采购合同类型为合同采购时业务性质类型为【" + PurchaseContractEnum.PurchaseBusinessType.match(businessType).getDesc() + "】时无法发起付款");
//                        }
//                    }
//                }
            }
            // 按照采购协议付款
            case AGREEMENT -> {
                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_PAYMENT_PAY.getCode();
//                // 采购协议类型
//                switch (PurchasePaymentEnum.AgreementType.match(agreementType)) {
//                    // 对公资源外包(付款申请单对公资源外包流程)
//                    case PUBLIC_OUTSOURCING ->
//                            scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_PUBLIC_OUTSOURCE.getCode();
//                    // 其他类协议(付款申请单行政运营类采购（协议）流程)
//                    case OTHER -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_AGREEMENT.getCode();
//                    // 个体资源外包及合同协议不允许发起付款
//                    default ->
//                            throw TwException.error("", "采购协议类型为【" + PurchasePaymentEnum.AgreementType.match(agreementType).getDesc() + "】时无法发起付款");
//                }
            }
            // 预付款
            case ADVANCE_PAY -> {
                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY.getCode();

                // 采购合同类型
//                if (purchaseContractType != null) {
//                    switch (PurchaseContractEnum.PurchaseConType.match(purchaseContractType)) {
//                        // 公司管理类采购 || 合同采购 （付款申请单预付款（合同采购及公司管理类采购）流程）
//                        case COMPANY, CON_PURCHASE ->
//                                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_ONE.getCode();
//                        // 项目采购(付款申请单预付款流程（项目采购预付款）)
//                        case PROJECT_PURCHASE ->
//                                scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_T.getCode();
//                        // 行政运营类采购(付款申请单预付款流程（行政类预付款）)
//                        case OPERATE -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_FOUR.getCode();
//                        // 其他(付款申请单预付款流程)
//                        default -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_TWO.getCode();
//                    }
//                    // 采购协议类型
//                } else if (agreementType != null) {
//                    if (Objects.equals(signBuId, administrationBuId)) {
//                        // 签约BU为行政BU(付款申请单预付款流程（行政类预付款）)
//                        scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_FOUR.getCode();
//                    } else {
//                        // 非行政BU(付款申请单预付款流程)
//                        scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_TWO.getCode();
//                    }
//                } else {
//                    // 采购合同投标保证金流程
//                    scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_BID_SECURITY.getCode();
//                }
            }
            // 预付款核销(预付款核销流程)
            case ADVANCE_PAY_WRITE_OFF -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_W_O.getCode();
            // 薪酬福利支付(付款申请单薪资福利流程)
      //      case SALARY_PAYMENT -> scene = PurchasePaymentEnum.PaymentProcDefKey.PUR_SALARY_PAYMENT.getCode();
        }
        return new ImmutableTriple<>(scene, purchaseContractManagerDO, purchaseAgreementDO);
    }


    /**
     * 提交流程
     *
     * @param purchasePaymentVO vo
     */
    private void submitPayment(PurchasePaymentVO purchasePaymentVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = PurchasePaymentEnum.PaymentStatus.APPROVING.getCode();
        if (workflow_enabled) {
            // 发起流程审批
            status = PurchasePaymentEnum.PaymentStatus.APPROVING.getCode();
            // 流程标识（流程定义key）
            String scene = purchasePaymentVO.getScene();
            // 获取流程节点处理人
            HashMap<String, Object> variables = this.getVariables(purchasePaymentVO);
            // 是否是驳回后再提交
            variables.put("isResubmit", purchasePaymentVO.getIsResubmit() != null && purchasePaymentVO.getIsResubmit());
            // 紧急付款标志
            variables.put("urgentPaymentFlag", purchasePaymentVO.getUrgentPaymentFlag() != null && purchasePaymentVO.getUrgentPaymentFlag());
            // 流程名称：申请单类型+验收方式+申请单名称+付款公司+本次付款核销金额
            StringBuilder paymentApplyName = new StringBuilder();
            // 申请单类型
            paymentApplyName.append(PurchasePaymentEnum.PaymentType.match(purchasePaymentVO.getPaymentApplicationType()).getDesc()).append("-");
            // 验收方式
            PurchasePaymentEnum.AcceptanceMethod acceptanceMethod = PurchasePaymentEnum.AcceptanceMethod.match(purchasePaymentVO.getAcceptanceType());
            if (acceptanceMethod != null) {
                paymentApplyName.append(acceptanceMethod.getDesc()).append("-");
            }
            // 申请单名称
            paymentApplyName.append(purchasePaymentVO.getPurchaseName()).append("-");
            // 付款公司
            if (purchasePaymentVO.getPayCompanyName() != null) {
                paymentApplyName.append(purchasePaymentVO.getPayCompanyName()).append("-");
            }
            // 本次付款金额
            paymentApplyName.append(purchasePaymentVO.getCurrPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentVO.getCurrPaymentAmt());

            // 1.销售BU负责人（关联子合同销售BU负责人）
            Long relatedSalesContractId = purchasePaymentVO.getRelatedSalesContractId();
            if (relatedSalesContractId != null) {
                SaleConContractVO saleConContractVO = saleConContractService.queryByKey(relatedSalesContractId);
                purchasePaymentVO.setSaleSignBuId(saleConContractVO.getSignBuId());
            }
            // 2.项目经理
            Long relatedProjectId = purchasePaymentVO.getRelatedProjectId();
            if (relatedProjectId != null) {
                PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(relatedProjectId);
                purchasePaymentVO.setPmResId(pmsProjectVO.getPmResId());
            }
            // 3.提交人BU
            Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(purchasePaymentVO.getPurchaseInchargeResId());
            purchasePaymentVO.setSubmitBuId(defaultOrgIdByUserId);

            // 启动流程
            if (purchasePaymentVO.getProcInstId() == null) {
                processInfo = workflowUtil.simpleStartProcess(StartProcessPayload.of(
                        PurchasePaymentEnum.PaymentProcDefKey.match(scene).getCode(),
                        String.valueOf(paymentApplyName),
                        purchasePaymentVO.getId() + "",
                        variables),purchasePaymentVO
                );
            } else {
                // 修改节点处理人
                workflowUtil.setVariables(SetVariablesPayload.of(purchasePaymentVO.getProcInstId(), variables));
            }
        }
        // 是否是紧急付款，如果为紧急付款，手动将流程推向下一个节点(目前由前端推)
        if (purchasePaymentVO.getUrgentPaymentFlag()) {
            // 变更付款申请单状态为“待应付会计提交”
            transactionUtilService.executeWithRunnable(() -> paymentSlipService.updateStatusByPaymentApplyId(purchasePaymentVO.getId(), PurchasePaymentEnum.PaymentSlipStatus.READY.getCode()));
        }
        // 流程启动成功后，回写业务表数据
        PurchasePaymentPayload payload = new PurchasePaymentPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(purchasePaymentVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setState(status);
        // 开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> purchasePaymentDAO.updateByKeyDynamic(payload));

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PurchasePaymentPayload payload) {
        PurchasePaymentDO entity = purchasePaymentRepo.findById(payload.getId()).orElseGet(PurchasePaymentDO::new);
        Assert.notNull(entity.getId(), "不存在");
        return purchasePaymentDAO.updateByKeyDynamic(payload);
    }

    @Override
    public PurchasePaymentVO getDefaultByTypeAndDocNo(PurchasePaymentDefaultQuery defaultQuery) {
        // 付款申请单类型
        String paymentApplicationType = defaultQuery.getPaymentApplicationType();
        // 关联单据类型
        String docType = defaultQuery.getDocType();
        // 关联单据号
        String docNo = defaultQuery.getDocNo();
        // result
        PurchasePaymentVO purchasePaymentVO = new PurchasePaymentVO();
        // 前置数据
        PurchasePaymentDefaultVO paymentDefaultByDocNo = new PurchasePaymentDefaultVO();
        // 付款申请单类型
        switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
            // 按照采购合同付款
            case CONTRACT -> {
                // 根据单据号查询前置信息（合同）
                paymentDefaultByDocNo = purchaseContractManagerService.findPaymentDefaultByDocNo(docNo);
                // 设置采购合同类型
                purchasePaymentVO.setPurchaseContractType(paymentDefaultByDocNo.getPurchaseContractType());
                // 付款明细/计划
                purchasePaymentVO.setPurchasePaymentPlanVOS(purchasePaymentPlanService.findListByConNo(docNo, true));
                // 申请单名称
                purchasePaymentVO.setPurchaseName(paymentDefaultByDocNo.getDocName() + LocalDate.now().toString().replace("-", "") + "付款");
            }
            // 按照采购协议付款（包含薪资福利结算单）
            case AGREEMENT, SALARY_PAYMENT -> {
                // 根据单据号查询前置信息（采购协议）
                paymentDefaultByDocNo = purchaseAgreementService.findPaymentDefaultByDocNo(docNo);
                // 提现申请单
                List<ResWithdrawApplyVO> withdrawByAgreementNo = resWithdrawApplyService.findWithdrawByAgreementNo(docNo);
                // 如果验收方式为“提现申请单”，应付金额为提现申请总金额*费率
                if (PurchasePaymentEnum.AcceptanceMethod.WITHDRAW.getCode().equals(paymentDefaultByDocNo.getAcceptanceType())) {
                    // 提现申请单金额（调整提现金额）
                    BigDecimal adjWithdrawAmtTotal = withdrawByAgreementNo.stream()
                            .map(resWithdrawApplyVO -> resWithdrawApplyVO.getAdjWithdrawAmt() == null ? BigDecimal.ZERO : resWithdrawApplyVO.getAdjWithdrawAmt())
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    // 获取费率（如果获取费率异常赋应付金额值为0）
                    try {
                        BigDecimal rate = purchaseAgreementService.getRateByAgreementId(paymentDefaultByDocNo.getDocId(), adjWithdrawAmtTotal);
                        // 计算申请付款金额合计（该付款单应付金额）
                        BigDecimal paymentAmt = adjWithdrawAmtTotal.multiply(rate)
                                .divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                        paymentDefaultByDocNo.setPaymentAmt(paymentAmt);
                    } catch (TwException e) {
                        paymentDefaultByDocNo.setPaymentAmt(BigDecimal.ZERO);
                    }
                }
                purchasePaymentVO.setResWithdrawApplyVOS(withdrawByAgreementNo);
                // 申请单名称
                purchasePaymentVO.setPurchaseName(paymentDefaultByDocNo.getDocName() + LocalDate.now().toString().replace("-", "") + "付款");
            }
            // 预付款
            case ADVANCE_PAY -> {
                switch (PurchasePaymentEnum.PaymentDocType.match(docType)) {
                    case CONTRACT ->
                            paymentDefaultByDocNo = purchaseContractManagerService.findPaymentDefaultByDocNo(docNo);
                    case AGREEMENT -> paymentDefaultByDocNo = purchaseAgreementService.findPaymentDefaultByDocNo(docNo);
                    case OPPORTUNITY -> {
                        // 根据单据号查询前置信息（商机）
                        paymentDefaultByDocNo = crmOpportunityService.findPaymentDefaultByDocNo(docNo);
                        // 申请单名称
                        purchasePaymentVO.setPurchaseName(paymentDefaultByDocNo.getDocName() + LocalDate.now().toString().replace("-", "") + "投标保证金");
                        // 商机名称
                        purchasePaymentVO.setOpportunityName(paymentDefaultByDocNo.getDocName());
                        purchasePaymentVO.setOpportunity(paymentDefaultByDocNo.getDocId() != null ? paymentDefaultByDocNo.getDocId().toString() : null);
                    }
                }
                // 查询付款计划
                List<PurchasePaymentPlanVO> paymentPlanVOS = purchasePaymentPlanService.findListByConNo(docNo, true);
                if (!CollectionUtils.isEmpty(paymentPlanVOS)) {
                    // 付款计划参考
                    List<PaymentPlanReferVO> paymentPlanReferVOS = new ArrayList<>(paymentPlanVOS.size());
                    paymentPlanVOS.forEach(purchasePaymentPlanVO -> {
                        PaymentPlanReferVO paymentPlanReferVO = new PaymentPlanReferVO();
                        paymentPlanReferVO.setPaymentStage(purchasePaymentPlanVO.getPaymentStage());
                        paymentPlanReferVO.setPaymentAmt(purchasePaymentPlanVO.getPaymentAmt());
                        paymentPlanReferVO.setEstimatedPaymentDate(purchasePaymentPlanVO.getEstimatedPaymentDate());
                        paymentPlanReferVOS.add(paymentPlanReferVO);
                    });
                    purchasePaymentVO.setPaymentPlanReferVOS(paymentPlanReferVOS);
                    // 2023-12-20 预付款需默认带出付款计划
                    purchasePaymentVO.setPurchasePaymentPlanVOS(purchasePaymentPlanService.findListByConNo(docNo, true));
                }
            }
        }
        // 设置前置单据属性
        this.setPaymentVO(purchasePaymentVO, paymentDefaultByDocNo);
        // 设置付款申请单类型
        purchasePaymentVO.setPaymentApplicationType(paymentApplicationType);
        // 设置单据类型
        purchasePaymentVO.setDocType(docType);
        // 设置本次付款金额为0.00
        purchasePaymentVO.setCurrPaymentAmt(BigDecimal.ZERO);
        return purchasePaymentVO;
    }

    /**
     * 设置前置的单据属性
     *
     * @param purchasePaymentVO     设置
     * @param paymentDefaultByDocNo 源数据
     */
    private void setPaymentVO(PurchasePaymentVO purchasePaymentVO, PurchasePaymentDefaultVO paymentDefaultByDocNo) {
        BeanUtil.copyProperties(paymentDefaultByDocNo, purchasePaymentVO, CopyOptions.create().setIgnoreNullValue(true));
        purchasePaymentVO.setSupplierLegalBookId(paymentDefaultByDocNo.getSupplierBookId());
        purchasePaymentVO.setPayCompanyBookId(paymentDefaultByDocNo.getPaymentCompanyBooKId());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(Long id, Boolean isInvalid) {
        // 获取标识、申请单创建人、状态、付款申请单类型、关联单据类型
        Tuple sceneAndCreatorAndState = purchasePaymentDAO.getSceneAndCreatorAndState(id);
        if (sceneAndCreatorAndState == null) {
            log.error("付款申请单删除失败，id不存在{}", id);
            return;
        }
        // 付款申请单类型
        String paymentApplicationType = sceneAndCreatorAndState.get(3, String.class);
        // 关联单据类型
        String docType = sceneAndCreatorAndState.get(4, String.class);
        if (!isInvalid) {
            // 获取当前登录人
            GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
            if (!(
                    (Objects.equals(sceneAndCreatorAndState.get(1, Long.class), loginGeneralUser.getUserId()) || loginGeneralUser.isSystemAdmin())
                            && PurchasePaymentEnum.PaymentStatus.CREATE.getCode().equals(sceneAndCreatorAndState.get(2, String.class))
            )) {
                throw TwException.error("", "当前登录用户为系统管理员或创建人并且付款申请单状态为新建时才允许删除");
            }
        }
        // 预付款核销修改付款申请单状态
        if (PurchasePaymentEnum.PaymentProcDefKey.PUR_ADVANCE_PAY_W_O.getCode().equals(sceneAndCreatorAndState.get(0, String.class))) {
            // 获取前置预付款申请单id
            Tuple prePaymentIdAndAmt = purchasePaymentDAO.findPrePaymentId(id);
            if (prePaymentIdAndAmt != null) {
                // 查询预付款单据下有无除“已付款”外其他付款申请单记录的状态，如果有，将预付款申请单状态修改为部分付款，否则为已付款
                PurchasePaymentEnum.PaymentStatus newStatus = paymentSlipService.isOtherStatusByPaymentApplyId(prePaymentIdAndAmt.get(0, Long.class)) ?
                        PurchasePaymentEnum.PaymentStatus.PARTIAL_PAY : PurchasePaymentEnum.PaymentStatus.PAID;
                purchasePaymentDAO.updatePaymentStatus(prePaymentIdAndAmt.get(0, Long.class), newStatus);
            }
        }
        // 将提现申请单的数据恢复
        resWithdrawApplyService.updateWithdrawStatusByPaymentApplyId(id, null);
        // 删除费用承担部门
        costUndertakeDepartmentService.deleteByPaymentApplyId(id);
        // 回滚发票数据
        List<InvInvoiceVerDetailVO> invInvoiceVerDetailVOS = invInvoiceVerDetailService.queryListByPaymentApplyId(docType, id);
        invInvoiceVerDetailVOS.forEach(invInvoiceVerDetailVO -> {
            BigDecimal subTheAmt = invInvoiceVerDetailVO.getTheAmt() == null ? BigDecimal.ZERO : invInvoiceVerDetailVO.getTheAmt();
            String invoiceCode = invInvoiceVerDetailVO.getInvoiceCode() == null ? "" : invInvoiceVerDetailVO.getInvoiceCode();
            invInvoiceService.subtractWrittenOffAmt(invInvoiceVerDetailVO.getInvoiceNo() + "-" + invoiceCode, subTheAmt);
        });
        // 删除发票核销明细
        invInvoiceVerDetailService.deleteByPaymentApplyId(id);
        // 删除付款申请单
        purchasePaymentDAO.deleteSoft(id);
        // 判断是恢复付款计划的数据还是删除
        if (this.judgePaymentPlanIsInsert(paymentApplicationType, docType)) {
            // 删除付款计划
            purchasePaymentPlanService.deleteByPaymentId(id);
            // 删除预付款申请单-付款计划参考
            paymentPlanReferService.deleteByPaymentId(id);
        } else {
            // 将付款计划中的本次付款金额（current_payment_amt）重制为 0  payment_apply_id 置为 null
            purchasePaymentPlanService.resettingPlanByPaymentId(id);
        }
    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long key) {
        return logService.queryLogList(key, PrdSystemObjectEnum.PAYMENT_APPLY.getCode());
    }


    @Override
    public HashMap<String, Object> getVariables(PurchasePaymentVO purchasePaymentVO) {
        HashMap<String, Object> variables = new HashMap<>();
        // 流程标识（流程定义key）
        String scene = purchasePaymentVO.getScene();
//        // 签单BULeader（关联销售子合同签单BULeader，如果是投标保证金的话取商机的签单Bu）
//        Long signBuLeader = null;
//        // 交付负责人（关联的销售合同的交付负责人）
//        Long deliverManager = null;
//        // 交付BU Leader（关联的销售合同的交付BU的leader）
//        Long deliverBuLeader = null;
//        // 采购BU负责人（付款单关联的采购合同的采购BU的负责人；如果关联的是采购协议，取采购协议签约BU的负责人；如果是无单据核销，取当前登录人所在组织负责人）
//        Long purManager = null;
//        // 采购合同关联项目ID
//        Long associationPrjId = null;
//        // 系统角色Map
//        Map<String, List<Long>> roleCodeMap = this.getRoleCodeMap();
//        // 关联销售合同
//        String relatedSalesContract = purchasePaymentVO.getRelatedSalesContract();
//        Optional<SaleConContractDO> saleConContractDO = relatedSalesContract == null ? Optional.empty() : saleConContractRepo.findByDeleteFlagAndCode(0, relatedSalesContract);
//        if (saleConContractDO.isPresent()) {
//            SaleConContractDO saleConDO = saleConContractDO.get();
//            deliverManager = saleConDO.getDeliUserId();
//            deliverBuLeader = prdOrgOrganizationService.queryManageIdById(saleConDO.getDeliBuId());
//            signBuLeader = prdOrgOrganizationService.queryManageIdById(saleConDO.getSignBuId());
//        }
//        // 关联采购合同
//        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) {
//            if (purchasePaymentVO.getDocNo() == null) {
//                throw TwException.error("", "未找到相关的采购合同，请检查");
//            }
//            Optional<PurchaseContractManagerDO> purchaseContractDO = purchaseContractManagerRepo.findByPurchaseContractNo(purchasePaymentVO.getDocNo());
//            if (purchaseContractDO.isEmpty()) {
//                throw TwException.error("", "未找到相关的采购合同，请检查");
//            }
//            purManager = prdOrgOrganizationService.queryManageIdById(purchaseContractDO.get().getPurchaseBuId());
//            associationPrjId = purchaseContractDO.get().getRelatedProjectId();
//            // 如果关联的是采购协议，取采购协议签约BU的负责人
//        } else if (PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode().equals(purchasePaymentVO.getDocType())) {
//            if (purchasePaymentVO.getDocNo() == null) {
//                throw TwException.error("", "未找到相关的采购协议，请检查");
//            }
//            Optional<PurchaseAgreementDO> purAgreementDO = purchaseAgreementRepo.findByPurchaseAgreementNo(purchasePaymentVO.getDocNo());
//            if (purAgreementDO.isEmpty()) {
//                throw TwException.error("", "未找到相关的采购协议，请检查");
//            }
//            purManager = prdOrgOrganizationService.queryManageIdById(purAgreementDO.get().getSignBuId());
//            // 如果是无单据核销，取当前登录人所在组织负责人
//        } else if (purchasePaymentVO.getNoDocVerification() != null && purchasePaymentVO.getNoDocVerification() == 1) {
//            // 当前登录人所在组织
//            Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(GlobalUtil.getLoginUserId());
//            if (defaultOrgIdByUserId != null) {
//                purManager = prdOrgOrganizationService.queryManageIdById(defaultOrgIdByUserId);
//            }
//        }

        switch (PurchasePaymentEnum.PaymentProcDefKey.match(scene)) {
            // 付款申请单
            case PUR_PAYMENT_PAY -> {
                dealPurcahsePaymentPayVariables(variables, purchasePaymentVO);
            }
            // 预付款申请单
            case PUR_ADVANCE_PAY -> {
                dealPurAdvancPayVariables(variables, purchasePaymentVO);
            }
            // 预付款核销
            case PUR_ADVANCE_PAY_W_O -> {
                dealAdvancePayWriteoffVariables(variables, purchasePaymentVO);
            }

//            // 付款申请单服务贸易流程
//            case PUR_TRADE_SERVICE -> {
//                // 交付负责人
//                variables.put("Activity_0acgfpz", deliverManager);
//                // 交付BULeader
//                variables.put("Activity_1p8s9lq", deliverBuLeader);
//                // 应付会计
//                variables.put("Activity_1y7rd7q", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_0hgem4i", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_1p07h6g", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_13rkctw", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_1vw0zs3", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0mf1yt5", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单产品贸易流程
//            case PUR_TRADE_PRODUCT -> {
//                // 签单BULeader
//                variables.put("Activity_0jvu0ja", signBuLeader);
//                // 应付会计
//                variables.put("Activity_0957mvm", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_0fdfrr3", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_1xx72aq", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_1xfk4oq", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_1auoq9y", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0dhpjob", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单外包流程
//            case PUR_OUTSOURCING -> {
//                // 应付会计
//                variables.put("Activity_1qavs1s", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_1sm010d", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_0rguu0r", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_0r8ebia", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0rye68j", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0yg7k51", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单投标保证金流程
//            case PUR_BID_SECURITY -> {
//                // 查询商机的签单BuLeader
//                signBuLeader = prdOrgOrganizationService.queryManageIdById(crmOpportunityService.findOrgIdByDocNo(purchasePaymentVO.getDocNo()));
//                // 签单BULeader
//                variables.put("Activity_1szj9rs", signBuLeader);
//                // 应付会计
//                variables.put("Activity_0ejrdnd", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_0bdr7s1", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_03p4xlc", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_1qn9msr", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0m1euk3", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_1iix5xs", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单房屋租赁流程
//            case PUR_HOUSE_RENTAL -> {
//                // 行政负责人
//                variables.put("Activity_0ymau01", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));
//                // 交付负责人
//                variables.put("Activity_1pdasuq", deliverManager);
//                // 应付会计
//                variables.put("Activity_07lgu4u", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_1dk803v", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_0aoxds8", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_1iiz9av", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0zeqeaa", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_1vsr5vw", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单杂项采购流程
//            case PUR_MIS_PURCHASE -> {
//                // 行政负责人
//                variables.put("Activity_0i67706", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));
//                // 交付负责人
//                variables.put("Activity_1ftfof4", deliverManager);
//                // 应付会计
//                variables.put("Activity_06u0c4i", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_1yw63i8", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_0eu8msb", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_1x3nhd0", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0982mtj", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0djs312", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单对公资源外包流程
//            case PUR_PUBLIC_OUTSOURCE -> {
//                // 采购BU负责人
//                variables.put("Activity_16699j9", purManager);
//                // 应付会计
//                variables.put("Activity_0uxe8le", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_1yggyms", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 平台总体负责人
//                variables.put("Activity_1ems1n6", roleCodeMap.get(RoleEnum.PLAT_ALL_PIC.getCode()));
//                // 财务经理
//                variables.put("Activity_0szmz6a", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0st65uc", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_1v6lkgq", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单市场渠道流程
//            case PUR_MARKET -> {
//                // 采购BU负责人
//                variables.put("Activity_1dej7f1", purManager);
//                // 应付会计
//                variables.put("Activity_07z8vdf", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台总体负责人
//                variables.put("Activity_04zpo1z", roleCodeMap.get(RoleEnum.PLAT_ALL_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_1cq32rs", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_10pv5wj", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0tsyu18", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0dtkif5", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单研发采购流程（如果关联项目了，取项目Leader）
//            case PUR_RESEARCH -> {
//                if (associationPrjId != null) {
//                    // 是否关联项目
//                    variables.put("associationPrj", true);
//                    // 所关联的项目
//                    PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(associationPrjId);
//                    // 交付BULeader
//                    Long deliBuLeader = prdOrgOrganizationService.queryManageIdById(pmsProjectVO.getDeliBuId());
//                    variables.put("Activity_0cnbm14", deliBuLeader);
//                } else {
//                    variables.put("associationPrj", false);
//                    variables.put("Activity_0cnbm14", null);
//                }
//                // 采购BU负责人
//                variables.put("Activity_155cy3h", purManager);
//                // 应付会计
//                variables.put("Activity_1ml7jkx", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台总体负责人
//                variables.put("Activity_1w03sw0", roleCodeMap.get(RoleEnum.PLAT_ALL_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_0fofbqf", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_0d2sgzv", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_1esavfg", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0cz6syb", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单行政运营类采购流程
//            case PUR_OPERATE -> {
//                // 采购BU负责人
//                variables.put("Activity_18cs4fu", purManager);
//                // 应付会计
//                variables.put("Activity_0phv9la", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_128ic99", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_1tpzykk", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_0ydxypl", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_1cg2tu3", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_1v4n1lp", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单公司管理类流程
//            case PUR_COMPANY -> {
//                // 采购BU负责人
//                variables.put("Activity_1usakk5", purManager);
//                // 应付会计
//                variables.put("Activity_0wxyy6h", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_1c51prt", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_100xejv", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_06q92or", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_05brvq4", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0bqqora", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单资源赋能类流程
//            case PUR_RESOURCE -> {
//                // 应付会计
//                variables.put("Activity_0r5rf8z", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_13k8j7y", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_0xznue0", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_08mvmjc", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0dfc6q7", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0r0ys3x", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单行政运营类采购（协议）流程
//            case PUR_AGREEMENT -> {
//                // 采购BU负责人
//                variables.put("Activity_1ts13il", purManager);
//                // 应付会计
//                variables.put("Activity_1upqjom", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_14467mj", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_1pm26b9", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_1pk9svv", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_1jn9aiu", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0u3fzyw", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单薪资福利流程
//            case PUR_SALARY_PAYMENT -> {
//                // 平台薪酬负责人（平台薪酬绩效主管 + 平台薪酬绩效专员）
//                List<Long> userIds = new ArrayList<>(roleCodeMap.get(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
//                if(roleCodeMap.containsKey(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()) && !CollectionUtils.isEmpty(roleCodeMap.get(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()))){
//                    userIds.addAll(roleCodeMap.get(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
//                }
//                variables.put("Activity_0axnmb5", userIds);
//                // 平台人力资源总监
//                variables.put("Activity_0q5u3l8", roleCodeMap.get(RoleEnum.PLAT_HRD.getCode()));
//                // 出纳
//                variables.put("Activity_0rbkhez", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单预付款核销流程
//            case PUR_ADVANCE_PAY_W_O -> {
//                // 采购BU负责人
//                variables.put("Activity_0n2kdri", purManager);
//                // 应付会计
//                variables.put("Activity_0ajv04n", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//            }
//            // 付款申请单预付款（合同采购及公司管理类采购）流程
//            case PUR_ADVANCE_PAY_ONE -> {
//                // 采购BU负责人
//                variables.put("Activity_05skq0r", purManager);
//                // 应付会计
//                variables.put("Activity_09bumwb", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_12d24us", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_0iqoj2d", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_0vqbpuv", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_1uu6c6c", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0wyypz8", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单预付款流程
//            case PUR_ADVANCE_PAY_TWO -> {
//                // 采购BU负责人
//                variables.put("Activity_1v87now", purManager);
//                // 应付会计
//                variables.put("Activity_01zvnzb", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 运营总裁
//                variables.put("Activity_0n97i35", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 平台总体负责人
//                variables.put("Activity_0mgw840", roleCodeMap.get(RoleEnum.PLAT_ALL_PIC.getCode()));
//                // 财务经理
//                variables.put("Activity_01rbp0d", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0dyhrvi", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_1293qp1", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单预付款流程（项目采购预付款）
//            case PUR_ADVANCE_PAY_T -> {
//                // 行政负责人
//                variables.put("Activity_0ldfqbe", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));
//                // 交付负责人
//                variables.put("Activity_1rqfcw8", deliverManager);
//                // 交付BULeader
//                variables.put("Activity_0jvcv19", deliverBuLeader);
//                // 应付会计
//                variables.put("Activity_1j6xa32", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_00ixi5m", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_1aqnk95", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_1mtz65b", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0toq0dh", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_0my8y42", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
//            // 付款申请单预付款流程（行政类预付款）
//            case PUR_ADVANCE_PAY_FOUR -> {
//                // 行政负责人
//                variables.put("Activity_170ys4l", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));
//                // 采购BU负责人
//                variables.put("Activity_05ax1da", purManager);
//                // 应付会计
//                variables.put("Activity_1b33las", roleCodeMap.get(RoleEnum.PLAT_AP_ACCOUNTANT.getCode()));
//                // 平台采购主管（平台业务总负责人）
//                variables.put("Activity_025nttw", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
//                // 运营总裁
//                variables.put("Activity_0u5fhaw", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
//                // 财务经理
//                variables.put("Activity_1wlcxyj", roleCodeMap.get(RoleEnum.PLAT_FIN_MANAGER.getCode()));
//                // CFO
//                variables.put("Activity_0d9dxxe", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
//                // 出纳
//                variables.put("Activity_1q8av5u", roleCodeMap.get(RoleEnum.PLAT_FIN_CASHIER.getCode()));
//            }
        }
        return variables;
    }

    private void dealPurcahsePaymentPayVariables(HashMap<String, Object> variables,PurchasePaymentVO purchasePaymentVO){
        // 是否是采购合同
        Boolean purContractFlag = false;
        // 是否是代理费/代理采购/外包
        Boolean agentOrOutFlag = false;
        // 是否是项目成本/房租
        Boolean projectFlag = false;
        // 子合同是否关联项目
        Boolean relateProjectFlag = false;
        // 是否是代理费
        Boolean agentFeeFlag = false;
        // 金额是否大于30000
        Boolean amtFlag = false;
        // 关联的是采购合同
        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) {
            if (purchasePaymentVO.getDocNo() == null) {
                throw TwException.error("", "未找到相关的采购合同，请检查");
            }
            Optional<PurchaseContractManagerDO> purchaseContractDO = purchaseContractManagerRepo.findByPurchaseContractNo(purchasePaymentVO.getDocNo());
            if (purchaseContractDO.isEmpty()) {
                throw TwException.error("", "未找到相关的采购合同，请检查");
            }
            PurchaseContractManagerDO purchaseContractManagerDO = purchaseContractDO.get();
            purContractFlag = true;

            if(PurchaseContractEnum.PurchaseConType.PURCHASING_AGENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.OUTSOURCING.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())){
                agentOrOutFlag = true;
                // 关联销售合同
                String relatedSalesContract = purchasePaymentVO.getRelatedSalesContract();
                Optional<SaleConContractDO> saleConContractDO = relatedSalesContract == null ? Optional.empty() : saleConContractRepo.findByDeleteFlagAndCode(0, relatedSalesContract);
                if (saleConContractDO.isPresent()) {
                    PmsProjectVO pmsProjectVO = pmsProjectService.queryByContractId(saleConContractDO.get().getId());
                    if(pmsProjectVO!=null){
                        relateProjectFlag = true;
                    }
                }
            }

            if(PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())){
                projectFlag = true;
            }

            if(PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())){
                agentFeeFlag = true;
            }

            if(purchasePaymentVO.getCurrPaymentAmt()!=null && purchasePaymentVO.getCurrPaymentAmt().compareTo(new BigDecimal(30000))>=0){
                amtFlag = true;
            }
        }
        variables.put("purContractFlag",purContractFlag);
        variables.put("agentOrOutFlag",agentOrOutFlag);
        variables.put("projectFlag",projectFlag);
        variables.put("relateProjectFlag",relateProjectFlag);
        variables.put("agentFeeFlag",agentFeeFlag);
        variables.put("amtFlag",amtFlag);
    }


    private void dealPurAdvancPayVariables(HashMap<String, Object> variables,PurchasePaymentVO purchasePaymentVO){
        // 是否是采购合同
        Boolean purContractFlag = false;
        // 是否是采购协议
        Boolean purAgreementFlag = false;
        // 是否是代理费/代理采购/外包
        Boolean agentOrOutFlag = false;
        // 是否是项目成本/房租
        Boolean projectFlag = false;
        // 子合同是否关联项目
        Boolean relateProjectFlag = false;
        // 是否是代理费
        Boolean agentFeeFlag = false;
        // 金额是否大于30000
        Boolean amtFlag = false;
        // 关联的是采购合同
        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) {
            if (purchasePaymentVO.getDocNo() == null) {
                throw TwException.error("", "未找到相关的采购合同，请检查");
            }
            Optional<PurchaseContractManagerDO> purchaseContractDO = purchaseContractManagerRepo.findByPurchaseContractNo(purchasePaymentVO.getDocNo());
            if (purchaseContractDO.isEmpty()) {
                throw TwException.error("", "未找到相关的采购合同，请检查");
            }
            PurchaseContractManagerDO purchaseContractManagerDO = purchaseContractDO.get();
            purContractFlag = true;

            if(PurchaseContractEnum.PurchaseConType.PURCHASING_AGENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.OUTSOURCING.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())){
                agentOrOutFlag = true;
                // 关联销售合同
                String relatedSalesContract = purchasePaymentVO.getRelatedSalesContract();
                Optional<SaleConContractDO> saleConContractDO = relatedSalesContract == null ? Optional.empty() : saleConContractRepo.findByDeleteFlagAndCode(0, relatedSalesContract);
                if (saleConContractDO.isPresent()) {
                    PmsProjectVO pmsProjectVO = pmsProjectService.queryByContractId(saleConContractDO.get().getId());
                    if(pmsProjectVO!=null){
                        relateProjectFlag = true;
                    }
                }
            }

            if(PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())){
                projectFlag = true;
            }

            if(PurchaseContractEnum.PurchaseConType.AGENCY_FEE.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())){
                agentFeeFlag = true;
            }

            if(purchasePaymentVO.getCurrPaymentAmt()!=null && purchasePaymentVO.getCurrPaymentAmt().compareTo(new BigDecimal(30000))>=0){
                amtFlag = true;
            }
        }else if(PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode().equals(purchasePaymentVO.getDocType())){
            purAgreementFlag = true;
        }
        variables.put("purContractFlag",purContractFlag);
        variables.put("purAgreementFlag",purAgreementFlag);
        variables.put("agentOrOutFlag",agentOrOutFlag);
        variables.put("projectFlag",projectFlag);
        variables.put("relateProjectFlag",relateProjectFlag);
        variables.put("agentFeeFlag",agentFeeFlag);
        variables.put("amtFlag",amtFlag);
    }
    private void dealAdvancePayWriteoffVariables(HashMap<String, Object> variables,PurchasePaymentVO purchasePaymentVO){
        Boolean noInvoiceFlag = false ;
        if(purchasePaymentVO.getNoInvoiceVerification()!=null && purchasePaymentVO.getNoInvoiceVerification()==1 && purchasePaymentVO.getNoDocVerification()!=null && purchasePaymentVO.getNoDocVerification()==1){
            noInvoiceFlag = true;
        }
        variables.put("noInvoiceFlag",noInvoiceFlag);
    }

    @Override
    public void exportPaymentApply(HttpServletResponse response, PurchasePaymentQuery query) {
        this.export(this.queryPaging(query), response);
    }

    @Override
    public void permissionExportPaymentApply(HttpServletResponse response, PurchasePaymentQuery query) {
        this.export(this.permissionPaging(query), response);
    }

    /**
     * 导出
     *
     * @param purchasePaymentVOPagingVO 数据
     */
    private void export(PagingVO<PurchasePaymentVO> purchasePaymentVOPagingVO, HttpServletResponse response) {
        List<PurchasePaymentVO> result = purchasePaymentVOPagingVO.getRecords();
        if (!CollectionUtils.isEmpty(result)) {
            // 翻译
            this.translate(result);
            ClassPathResource classPathResource = new ClassPathResource("template/purPaymentApply.xlsx");
            try {
                InputStream inputStream = classPathResource.getInputStream();
                Workbook workbook = WorkbookFactory.create(inputStream);
                XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("付款申请单");
                if (!CollectionUtils.isEmpty(result) && batchProjectSheet != null) {
                    int nextRow = 1;
                    for (PurchasePaymentVO purchasePaymentVO : result) {
                        Row row = batchProjectSheet.createRow(nextRow);
                        excelUtil.setCellValue(row, 0, purchasePaymentVO.getPaymentNo());       // 申请单单号
                        excelUtil.setCellValue(row, 1, purchasePaymentVO.getPurchaseName());    // 申请单名称
                        excelUtil.setCellValue(row, 2, purchasePaymentVO.getPaymentApplicationTypeDesc());  // 申请单类型
                        excelUtil.setCellValue(row, 3, purchasePaymentVO.getFinalPaymentCompanyName()); // 付款公司
                        excelUtil.setCellValue(row, 4, purchasePaymentVO.getSupplierLegalName()); // 供应商
                        excelUtil.setCellValue(row, 5, purchasePaymentVO.getDocTypeDesc());     // 关联单据类型
                        excelUtil.setCellValue(row, 6, purchasePaymentVO.getDocNo());           // 关联单据号
                        excelUtil.setCellValue(row, 7, purchasePaymentVO.getStateDesc());       // 付款申请单状态
                        excelUtil.setCellValue(row, 8, purchasePaymentVO.getCurrPaymentAmt());  // 金额
                        excelUtil.setCellValue(row, 9, purchasePaymentVO.getRateDesc());        // 税率
                        excelUtil.setCellValue(row, 10, purchasePaymentVO.getApplicationDate());    // 申请日期
                        excelUtil.setCellValue(row, 11, purchasePaymentVO.getRelatedSalesContract());   // 关联销售合同
                        excelUtil.setCellValue(row, 12, purchasePaymentVO.getRelatedProjectNo());   // 相关项目号
                        excelUtil.setCellValue(row, 13, purchasePaymentVO.getCreateUserName());  // 创建人
                        excelUtil.setCellValue(row, 14, purchasePaymentVO.getCreateTime());  // 创建日期
                        nextRow++;
                    }
                }
                String fileName = "付款申请单-" + LocalDate.now();
                ExcelUtil.writeResponse(response, fileName, workbook);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PurchasePaymentVO findUrgentPaymentByProcInstId(String procInstId) {
        Optional<PurchasePaymentDO> byProcInstIdAndDeleteFlag = purchasePaymentRepo.findByProcInstIdAndDeleteFlag(procInstId, 0);
        if (byProcInstIdAndDeleteFlag.isEmpty()) {
            throw TwException.error("", "此流程不能进行紧急付款！");
        }
        PurchasePaymentDO purchasePaymentDO = byProcInstIdAndDeleteFlag.get();
        if (!PurchasePaymentEnum.PaymentStatus.APPROVING.getCode().equals(purchasePaymentDO.getState())) {
            throw TwException.error("", "付款申请单状态为审批中时，才能进行紧急付款");
        }
        // 查询付款申请单是否有付款记录
        List<PaymentSlipVO> paymentSlipVOS = paymentSlipService.queryListByPaymentApplyId(purchasePaymentDO.getId());
        if (!CollectionUtils.isEmpty(paymentSlipVOS)) {
            throw TwException.error("", "付款申请已有付款记录！");
        }
        return queryByKey(purchasePaymentDO.getId());
    }

    @Override
    public List<PurchasePaymentVO> queryByDocNo(String docNo, List<String> statusLis) {
        return purchasePaymentDAO.queryByDocNo(docNo, statusLis);
    }

    @Override
    public List<PurchasePaymentVO> queryListDynamic(PurchasePaymentQuery query) {
        return purchasePaymentDAO.queryListDynamic(query);
    }

    /**
     * 获取角色Code
     */
    private Map<String, List<Long>> getRoleCodeMap() {
        // 查询系统角色
        List<String> roleCodes = new ArrayList<>();
        // 行政负责人
        roleCodes.add(RoleEnum.PLAT_OFFI_AM.getCode());
        // 平台薪酬绩效主管
        roleCodes.add(RoleEnum.PLAT_SALARY_MANAGER.getCode());
        // 平台薪酬绩效专员
        roleCodes.add(RoleEnum.PLAT_SALARY_SPECIALIST.getCode());
        // 平台人力资源总监
        roleCodes.add(RoleEnum.PLAT_HRD.getCode());
        // 应付会计
        roleCodes.add(RoleEnum.PLAT_AP_ACCOUNTANT.getCode());
        // 平台业务总负责人
        roleCodes.add(RoleEnum.PLAT_BUSINESS_PIC.getCode());
        // 运营总裁
        roleCodes.add(RoleEnum.OPERATION_PRESIDENT.getCode());
        // 平台总体负责人
        roleCodes.add(RoleEnum.PLAT_ALL_PIC.getCode());
        // 财务经理
        roleCodes.add(RoleEnum.PLAT_FIN_MANAGER.getCode());
        // CFO
        roleCodes.add(RoleEnum.PLAT_CFO.getCode());
        // 出纳
        roleCodes.add(RoleEnum.PLAT_FIN_CASHIER.getCode());
        return systemRoleService.queryUserIdMapByRoleCodes(roleCodes);
    }


    /**
     * 翻译
     *
     * @param result 要翻译的集合
     */
    private void translate(List<PurchasePaymentVO> result) {
        result.forEach(purchasePaymentVO -> {
            // 付款申请单类型
            purchasePaymentVO.setPaymentApplicationTypeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.PAYMENT_APPLY_TYPE.getCode(), purchasePaymentVO.getPaymentApplicationType()));
            // 关联单据类型
            purchasePaymentVO.setDocTypeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ASSOCIATION_DOC_TYPE.getCode(), purchasePaymentVO.getDocType()));
            // 付款申请单状态
            purchasePaymentVO.setStateDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.PAYMENT_APPLY_STATUS.getCode(), purchasePaymentVO.getState()));
            // 税率
            purchasePaymentVO.setRateDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbTAX_RATE.getCode(), purchasePaymentVO.getRate()));
            // 创建人
            purchasePaymentVO.setCreateUserName(cacheUtil.getUserName(purchasePaymentVO.getCreateUserId()));
        });
        this.translateBusinessPartner(result);
    }

    /**
     * 翻译业务伙伴名称
     *
     * @param result 要翻译的集合
     */
    private void translateBusinessPartner(List<PurchasePaymentVO> result) {
        // 地址簿列表
        List<Long> bookIdList = new ArrayList<>();
        List<Long> receivingIdList = new ArrayList<>();
        result.forEach(purchasePaymentVO -> {
            bookIdList.add(purchasePaymentVO.getSupplierLegalBookId());
            bookIdList.add(purchasePaymentVO.getPayCompanyBookId());
            bookIdList.add(purchasePaymentVO.getFinalPaymentCompanyBookId());
            bookIdList.add(purchasePaymentVO.getReceivingUnitBookId());
            if (StringUtils.hasText(purchasePaymentVO.getReceivingId())) {
                receivingIdList.add(Long.valueOf(purchasePaymentVO.getReceivingId()));
            }
        });
        Map<Long, String> nameByBookIds = businessPartnerService.findNameByBookIds(bookIdList);
        Map<Long, List<BookAccountVO>> bookAccountMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(receivingIdList)) {
            bookAccountMap = bookAccountService.queryByIdList(receivingIdList);
        }

        for (PurchasePaymentVO purchasePaymentVO: result){
            purchasePaymentVO.setSupplierLegalName(nameByBookIds.get(purchasePaymentVO.getSupplierLegalBookId()));
            purchasePaymentVO.setPayCompanyName(nameByBookIds.get(purchasePaymentVO.getPayCompanyBookId()));
            purchasePaymentVO.setFinalPaymentCompanyName(nameByBookIds.get(purchasePaymentVO.getFinalPaymentCompanyBookId()));
            purchasePaymentVO.setReceivingUnitName(nameByBookIds.get(purchasePaymentVO.getReceivingUnitBookId()));
            // 翻译银行账号
            if (StringUtils.hasText(purchasePaymentVO.getReceivingId())) {
                List<BookAccountVO> bookAccountVOS = bookAccountMap.get(Long.valueOf(purchasePaymentVO.getReceivingId()));
                if (!CollectionUtils.isEmpty(bookAccountVOS)) {
                    purchasePaymentVO.setReceivingNo(bookAccountVOS.get(0).getAccountNo());
                }
            }
        }
    }

    /**
     * 翻译业务伙伴名称
     *
     * @param purchasePaymentVO 要翻译的Vo
     */
    private void translateBusinessPartner(PurchasePaymentVO purchasePaymentVO) {
        // 地址簿列表
        List<Long> bookIdList = new ArrayList<>();
        // 银行账号IdList
        List<Long> bankAccountIdList = new ArrayList<>();
        bookIdList.add(purchasePaymentVO.getPayCompanyBookId());
        bookIdList.add(purchasePaymentVO.getSupplierLegalBookId());
        bookIdList.add(purchasePaymentVO.getFinalPaymentCompanyBookId());
        bookIdList.add(purchasePaymentVO.getReceivingUnitBookId());
        // 银行账号
        if (StringUtils.hasText(purchasePaymentVO.getReceivingId())) {
            bankAccountIdList.add(Long.valueOf(purchasePaymentVO.getReceivingId()));
        }
        if (StringUtils.hasText(purchasePaymentVO.getPaymentId())) {
            bankAccountIdList.add(Long.valueOf(purchasePaymentVO.getPaymentId()));
        }
        if (StringUtils.hasText(purchasePaymentVO.getFinalPaymentId())) {
            bankAccountIdList.add(Long.valueOf(purchasePaymentVO.getFinalPaymentId()));
        }
        // 付款单记录
        List<PaymentSlipVO> paymentSlipVOS = purchasePaymentVO.getPaymentSlipVOS();
        if (!CollectionUtils.isEmpty(paymentSlipVOS)) {
            paymentSlipVOS.forEach(paymentSlipVO -> {
                bookIdList.add(paymentSlipVO.getReceivingCompanyBookId());
                bookIdList.add(paymentSlipVO.getPayCompanyBookId());
                // 收款账号
                if (StringUtils.hasText(paymentSlipVO.getReceivingAccount())) {
                    bankAccountIdList.add(Long.valueOf(paymentSlipVO.getReceivingAccount()));
                }
                // 付款账号
                if (StringUtils.hasText(paymentSlipVO.getPaymentAccount())) {
                    bankAccountIdList.add(Long.valueOf(paymentSlipVO.getPaymentAccount()));
                }
            });
        }
        Map<Long, String> nameByBookIds = businessPartnerService.findNameByBookIds(bookIdList);
        Map<Long, List<BookAccountVO>> bookAccountMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(bankAccountIdList)) {
            bookAccountMap = bookAccountService.queryByIdList(bankAccountIdList);
        }
        purchasePaymentVO.setSupplierLegalName(nameByBookIds.get(purchasePaymentVO.getSupplierLegalBookId()));
        purchasePaymentVO.setPayCompanyName(nameByBookIds.get(purchasePaymentVO.getPayCompanyBookId()));
        purchasePaymentVO.setFinalPaymentCompanyName(nameByBookIds.get(purchasePaymentVO.getFinalPaymentCompanyBookId()));
        purchasePaymentVO.setReceivingUnitName(nameByBookIds.get(purchasePaymentVO.getReceivingUnitBookId()));
        // 翻译银行账号
        if (StringUtils.hasText(purchasePaymentVO.getReceivingId())) {
            List<BookAccountVO> bookAccountVOS = bookAccountMap.get(Long.valueOf(purchasePaymentVO.getReceivingId()));
            if (!CollectionUtils.isEmpty(bookAccountVOS)) {
                purchasePaymentVO.setReceivingNo(bookAccountVOS.get(0).getAccountNo());
                // 收款打印字段
                purchasePaymentVO.setReceivingBankPrint(bookAccountVOS.get(0).getDepositBankOutlet());
                purchasePaymentVO.setReceivingNamePrint(bookAccountVOS.get(0).getAccountName());
            }
        }
        if (StringUtils.hasText(purchasePaymentVO.getPaymentId())) {
            List<BookAccountVO> bookAccountVOS = bookAccountMap.get(Long.valueOf(purchasePaymentVO.getPaymentId()));
            if (!CollectionUtils.isEmpty(bookAccountVOS)) {
                purchasePaymentVO.setPaymentIdDesc(bookAccountVOS.get(0).getAccountNo());
            }
        }
        if (StringUtils.hasText(purchasePaymentVO.getFinalPaymentId())) {
            List<BookAccountVO> bookAccountVOS = bookAccountMap.get(Long.valueOf(purchasePaymentVO.getFinalPaymentId()));
            if (!CollectionUtils.isEmpty(bookAccountVOS)) {
                purchasePaymentVO.setFinalPaymentIdDesc(bookAccountVOS.get(0).getAccountNo());
            }
        }
        // 翻译付款单记录
        if (!CollectionUtils.isEmpty(paymentSlipVOS)) {
            for (PaymentSlipVO paymentSlipVO : paymentSlipVOS) {
                // 地址簿Id
                paymentSlipVO.setPayCompanyBookIdDesc(nameByBookIds.get(paymentSlipVO.getPayCompanyBookId()));
                paymentSlipVO.setReceivingCompanyBookIdDesc(nameByBookIds.get(paymentSlipVO.getReceivingCompanyBookId()));
                // 银行账号
                if (StringUtils.hasText(paymentSlipVO.getReceivingAccount())) {
                    // 收款账号
                    List<BookAccountVO> receivingBookAccountVOS = bookAccountMap.get(Long.valueOf(paymentSlipVO.getReceivingAccount()));
                    if (!CollectionUtils.isEmpty(receivingBookAccountVOS)) {
                        paymentSlipVO.setReceivingAccountDesc(receivingBookAccountVOS.get(0).getAccountNo());
                    }
                    // 付款账号
                    List<BookAccountVO> paymentBookAccountVOS = bookAccountMap.get(Long.valueOf(paymentSlipVO.getPaymentAccount()));
                    if (!CollectionUtils.isEmpty(paymentBookAccountVOS)) {
                        paymentSlipVO.setPaymentAccountDesc(paymentBookAccountVOS.get(0).getAccountNo());
                    }
                }

            }
        }
    }

    /**
     * 设置相关联单据的Id
     *
     * @param purchasePaymentVO vo
     */
    private void setDocumentId(PurchasePaymentVO purchasePaymentVO) {
        // 关联单据
        if (purchasePaymentVO.getDocNo() != null) {
            switch (PurchasePaymentEnum.PaymentDocType.match(purchasePaymentVO.getDocType())) {
                // 采购合同
                case CONTRACT -> {
                    PurchaseContractManagerVO purchaseContractManagerVO = purchaseContractManagerService.queryByNo(purchasePaymentVO.getDocNo());
                    if (purchaseContractManagerVO != null) {
                        purchasePaymentVO.setDocId(purchaseContractManagerVO.getId());
                        purchasePaymentVO.setPurchaseContractType(purchaseContractManagerVO.getPurchaseContractType());
                    }
                }
                // 采购协议
                case AGREEMENT ->
                        purchasePaymentVO.setDocId(purchaseAgreementService.findIdByNo(purchasePaymentVO.getDocNo()));
            }
        }
        // 销售合同
        if (purchasePaymentVO.getRelatedSalesContract() != null) {
            purchasePaymentVO.setRelatedSalesContractId(saleConContractService.findIdByNo(purchasePaymentVO.getRelatedSalesContract()));
        }
        // 项目
        if (purchasePaymentVO.getRelatedProjectNo() != null) {
            PmsProjectVO pmsProjectVO = pmsProjectService.findIdByNo(purchasePaymentVO.getRelatedProjectNo());
            purchasePaymentVO.setRelatedProjectId(pmsProjectVO.getId());
            purchasePaymentVO.setRelatedSubjectTempId(pmsProjectVO.getSubjectTempId());
        }
    }

    /**
     * 判断付款计划是新增还是修改
     *
     * @param paymentApplicationType 付款申请单类型
     * @param docType                关联单据类型
     * @return 新增Or修改
     */
    private boolean judgePaymentPlanIsInsert(String paymentApplicationType, String docType) {
        switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
            // 按照采购合同付款、预付款--更新（修改付款明细、计划本次付款金额及付款申请单号）
            case CONTRACT -> {
                return false;
            }
            // 预付款（基于采购合同发起的预付款为修改，基于采购协议发起的需新增）
            case ADVANCE_PAY -> {
                return !PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(docType);
            }
            // 其他--新增
            default -> {
                return true;
            }
        }
    }


    /**
     * 保存票据核销明细
     *
     * @param payload  payload
     * @param isInsert 是否为新增
     * @param isCheck  是否校验
     */
    private void saveBillVerDetail(PurchasePaymentPayload payload, Boolean isInsert, Boolean isCheck) {
        List<BillVerDetailPayload> billVerDetailPayloads = payload.getBillVerDetailPayloads();
        Map<String, BigDecimal> oldTheAmtMap = new HashMap<>();
        if (!isInsert) {
            // 查询原票据核销明细
            List<BillVerDetailVO> billVerDetailVOS = billVerDetailService.queryListByPaymentApplyId(payload.getDocType(), payload.getId());
            if (!CollectionUtils.isEmpty(billVerDetailVOS)) {
                billVerDetailVOS.forEach(billVerDetailVO -> {
                    // 键：票据号码
                    String billCode = billVerDetailVO.getBillNo() == null ? "" : billVerDetailVO.getBillNo();
                    String key = billCode;
                    // 值：本次核销金额
                    BigDecimal oldTheAmt = billVerDetailVO.getTheAmt();
                    oldTheAmt = oldTheAmt == null ? BigDecimal.ZERO : oldTheAmt;
                    oldTheAmtMap.put(key, oldTheAmt);
                });
            }
            // 删除票据核销明细
            billVerDetailService.deleteByPaymentApplyId(payload.getId());
        }
        // 发票核销总金额
        final BigDecimal[] allTheAmt = {BigDecimal.ZERO};
        // 保存发票核销明细
        if (!CollectionUtils.isEmpty(billVerDetailPayloads)) {
            Map<String, BigDecimal> newTheAmtMap = new HashMap<>();
            billVerDetailPayloads.forEach(billVerDetailPayload -> {
                // 本次核销金额
                BigDecimal theAmt = billVerDetailPayload.getTheAmt() == null ? BigDecimal.ZERO : billVerDetailPayload.getTheAmt();
                // 键：票据号码
                String billCode = billVerDetailPayload.getBillNo() == null ? "" : billVerDetailPayload.getBillNo();
                String key = billCode;
                newTheAmtMap.put(key, theAmt);
                allTheAmt[0] = allTheAmt[0].add(theAmt);
                // 发票金额
                BigDecimal invoiceAmt = billVerDetailPayload.getInvoiceAmt() == null ? BigDecimal.ZERO : billVerDetailPayload.getInvoiceAmt();
                // 已存核销金额
                BigDecimal writtenOffAmt = billVerDetailPayload.getWrittenOffAmt() == null ? BigDecimal.ZERO : billVerDetailPayload.getWrittenOffAmt();
                // 该条数据之前已保存的核销金额
                BigDecimal oldTheAmt = oldTheAmtMap.get(key) == null ? BigDecimal.ZERO : oldTheAmtMap.get(key);
                // 校验发票金额及核销金额发票金额需大于等于核销金额（已存核销金额+本次核销金额-该条数据之前已保存的核销金额）< 发票金额）
                if (writtenOffAmt.add(theAmt.subtract(oldTheAmt)).compareTo(invoiceAmt) > 0) {
                    throw TwException.error("", "票据号码为【" + billVerDetailPayload.getBillNo() + "】的票据总核销金额需小于票据金额");
                }
                // 设置付款申请单ID
                billVerDetailPayload.setPaymentApplyId(payload.getId());
            });
            // 校验发票号+发票代码是否有重复的
            if (newTheAmtMap.size() < billVerDetailPayloads.size()) {
                throw TwException.error("", "票据号不可重复");
            }
            billVerDetailService.insertAll(billVerDetailPayloads);
        }
        // 薪酬福利支付时发票核销明细，可以不填写 当提交时或非薪酬福利支付时校验
//        if (!CollectionUtils.isEmpty(billVerDetailPayloads) && isCheck && !PurchasePaymentEnum.PaymentType.SALARY_PAYMENT.getCode().equals(payload.getPaymentApplicationType())) {
//            // 校验发票核销金额 选中的发票核销金额与付款明细金额必须一致
//            BigDecimal currPaymentAmt = payload.getCurrPaymentAmt() == null ? BigDecimal.ZERO : payload.getCurrPaymentAmt();
//            if (allTheAmt[0].compareTo(currPaymentAmt) != 0 && (payload.getNoInvoiceVerification() != null && payload.getNoInvoiceVerification() != 1)) {
//                throw TwException.error("", "付款金额应与票据金额一致！");
//            }
//        }
    }
}
