package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
@Entity
@Table(name = "con_inv_batch_invdtl", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_inv_batch_invdtl", comment = "invdtl")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConInvBatchInvdtlDO extends BaseModel implements Serializable  {
    /** 开票批次ID */
    @Comment("开票批次ID")
    @Column()
    private Long invbatchId;
    /** 发票号 */
    @Comment("发票号")
    @Column()
    private String invNo;
    /** 不含税金额 */
    @Comment("不含税金额")
    @Column()
    private BigDecimal netAmt;
    /** 税额 */
    @Comment("税额")
    @Column()
    private BigDecimal taxAmt;
    /** 发票金额 */
    @Comment("发票金额")
    @Column()
    private BigDecimal invAmt;
    /** 发票状态 */
    @Comment("发票状态")
    @Column()
    private String invStatus;
    /** 快递单号 */
    @Comment("快递单号")
    @Column()
    private String deliveryNo;
    /** 快递日期 */
    @Comment("快递日期")
    @Column()
    private LocalDate deliveryDate;
    /** 实际开票日期 */
    @Comment("实际开票日期")
    @Column()
    private LocalDate actualInvDate;

    /** 税率 */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;

    /** 发票来源（null:手工插入） */
    @Comment("发票来源（null:手工插入）")
    @Column()
    private String comeFrom;
    /** 发票下载地址（null:手工插入无地址） */
    @Comment("发票下载地址（null:手工插入无地址）")
    @Column()
    private String downloadUrl;

    /** 4.0的开票id */
    @Comment("4.0的开票id")
    @Column()
    private Long invBatchInvdtlIdV4;

    public void copy(ConInvBatchInvdtlDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
