package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchInvdtlPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchInvdtlService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlExcelExport;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchInvdtlVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvBatchInvdtlConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchInvdtlExport1DAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchInvdtlExportDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchInvdtlDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvBatchInvdtlRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConInvBatchInvdtlServiceImpl extends BaseServiceImpl implements ConInvBatchInvdtlService {

    private final ConInvBatchInvdtlRepo conInvBatchInvdtlRepo;
    private final ConInvBatchInvdtlExportDAO conInvBatchInvdtlDAO;
    private final ConInvBatchInvdtlExport1DAO conInvBatchInvdtlExport1DAO;
    private final UdcUtil udcUtil;

    @Override
    public PagingVO<ConInvBatchInvdtlVO> queryPaging(ConInvBatchInvdtlQuery query) {
        PagingVO<ConInvBatchInvdtlVO> conInvBatchInvdtlVOPagingVO = conInvBatchInvdtlDAO.queryPaging(query);
        List<ConInvBatchInvdtlVO> records = conInvBatchInvdtlVOPagingVO.getRecords();
        handleList(records);
        return conInvBatchInvdtlVOPagingVO;
    }

    @Override
    public void exportList(ConInvBatchInvdtlQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "开票报表";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS = queryListDynamic(query);
        handleList(conInvBatchInvdtlVOS);
        if (conInvBatchInvdtlVOS.size() > 50000) {
            throw TwException.error("500", "导出数据过大，请分批操作，目前导出数量：" + conInvBatchInvdtlVOS.size());
        }
        List<ConInvBatchInvdtlVO> resultList = udcUtil.translateList(conInvBatchInvdtlVOS);
        List<ConInvBatchInvdtlExcelExport> excelList = ConInvBatchInvdtlConvert.INSTANCE.voListVoExcelExport(resultList);
        for (ConInvBatchInvdtlExcelExport conInvBatchInvdtlExcelExport : excelList) {
            for (ConInvBatchInvdtlVO conInvBatchInvdtlVO : resultList) {
                if (conInvBatchInvdtlVO.getId().equals(conInvBatchInvdtlExcelExport.getId())) {
                    conInvBatchInvdtlExcelExport.setActualInvDate(conInvBatchInvdtlVO.getActualInvDate() + "");
                }
            }
        }
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), ConInvBatchInvdtlExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, ConInvBatchInvdtlExcelExport.class, null);
        //写入
        sheet.doWrite(excelList);
    }

    @Override
    public List<ConInvBatchInvdtlVO> queryListDynamic(ConInvBatchInvdtlQuery query) {
        List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS = conInvBatchInvdtlDAO.queryListDynamic(query);
        handleList(conInvBatchInvdtlVOS);
        return conInvBatchInvdtlVOS;
    }

    /**
     * 处理退票的那些记录
     *
     * @param conInvBatchInvdtlVOS
     */
    private void handleList(List<ConInvBatchInvdtlVO> conInvBatchInvdtlVOS) {
        List<Long> conInvBatchInvdts = new ArrayList<>();
        for (ConInvBatchInvdtlVO conInvBatchInvdtlVO : conInvBatchInvdtlVOS) {
            Long saleContractId = conInvBatchInvdtlVO.getSaleContractId();
            if (saleContractId != null) {
                conInvBatchInvdts.add(conInvBatchInvdtlVO.getId());
            }
        }
        // 单独查询退票的数据
        ConInvBatchInvdtlQuery query = new ConInvBatchInvdtlQuery();
        query.setIds(conInvBatchInvdts);
        List<ConInvBatchInvdtlVO> results = conInvBatchInvdtlExport1DAO.queryListDynamic(query);
        for (ConInvBatchInvdtlVO result : results) {
            for (int i = 0; i < conInvBatchInvdtlVOS.size(); i++) {
                ConInvBatchInvdtlVO conInvBatchInvdtlVO = conInvBatchInvdtlVOS.get(i);
                if (result.getId().equals(conInvBatchInvdtlVO.getId())) {
                    conInvBatchInvdtlVOS.set(i, result);
                    break;
                }
            }
        }
    }

    @Override
    public ConInvBatchInvdtlVO queryByKey(Long key) {
        ConInvBatchInvdtlDO entity = conInvBatchInvdtlRepo.findById(key).orElseGet(ConInvBatchInvdtlDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvBatchInvdtlVO vo = ConInvBatchInvdtlConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvBatchInvdtlVO insert(ConInvBatchInvdtlPayload payload) {
        ConInvBatchInvdtlDO entityDo = ConInvBatchInvdtlConvert.INSTANCE.toDo(payload);
        return ConInvBatchInvdtlConvert.INSTANCE.toVo(conInvBatchInvdtlRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConInvBatchInvdtlVO update(ConInvBatchInvdtlPayload payload) {
        ConInvBatchInvdtlDO entity = conInvBatchInvdtlRepo.findById(payload.getId()).orElseGet(ConInvBatchInvdtlDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConInvBatchInvdtlDO entityDo = ConInvBatchInvdtlConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConInvBatchInvdtlConvert.INSTANCE.toVo(conInvBatchInvdtlRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConInvBatchInvdtlPayload payload) {
        ConInvBatchInvdtlDO entity = conInvBatchInvdtlRepo.findById(payload.getId()).orElseGet(ConInvBatchInvdtlDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conInvBatchInvdtlDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conInvBatchInvdtlDAO.deleteSoft(keys);
        }
    }

}
