package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConServicePriceRepo;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConServicePriceDAO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConServicePriceConvert;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConServicePriceService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConServicePricePayload;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConServicePriceDO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConServicePriceVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConServicePriceQuery;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConServicePriceConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 销售合同-T&M-服务价格
 *
 * @author sam.li
 * @date 2024-05-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConServicePriceServiceImpl extends BaseServiceImpl implements ConServicePriceService {

    private final ConServicePriceRepo conServicePriceRepo;
    private final ConServicePriceDAO conServicePriceDAO;
    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<ConServicePriceVO> queryPaging(ConServicePriceQuery query){
        PagingVO<ConServicePriceVO> conServicePriceVOPagingVO = conServicePriceDAO.queryPaging(query);
        conServicePriceVOPagingVO.getRecords().forEach(this::transfer);
        return conServicePriceVOPagingVO;
    }

    @Override
    public List<ConServicePriceVO> queryListDynamic(ConServicePriceQuery query){
        List<ConServicePriceVO> conServicePriceVOS = conServicePriceDAO.queryListDynamic(query);
        conServicePriceVOS.forEach(this::transfer);
        return conServicePriceVOS;
    }

    @Override
    public ConServicePriceVO queryByKey(Long key) {
        ConServicePriceDO entity = conServicePriceRepo.findById(key).orElseGet(ConServicePriceDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConServicePriceVO vo = ConServicePriceConvert.INSTANCE.toVo(entity);
        transfer(vo);
        return vo;
    }

    private void transfer(ConServicePriceVO vo){
        vo.setSettlementMethodDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.Settlement_Method.getCode(), vo.getSettlementMethod()));
        vo.setSettlementCycleDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.Settlement_Period.getCode(), vo.getSettlementCycle()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConServicePriceVO insert(ConServicePricePayload payload) {
        ConServicePriceDO entityDo = ConServicePriceConvert.INSTANCE.toDo(payload);
        return ConServicePriceConvert.INSTANCE.toVo(conServicePriceRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConServicePriceVO update(ConServicePricePayload payload) {
        ConServicePriceDO entity = conServicePriceRepo.findById(payload.getId()).orElseGet(ConServicePriceDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConServicePriceDO entityDo = ConServicePriceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConServicePriceConvert.INSTANCE.toVo(conServicePriceRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConServicePricePayload payload) {
        ConServicePriceDO entity = conServicePriceRepo.findById(payload.getId()).orElseGet(ConServicePriceDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conServicePriceDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conServicePriceDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBySaleConId(Long saleConId, String settlementCycle, String settlementMethod) {
        if(!StringUtils.hasText(settlementCycle) && !StringUtils.hasText(settlementMethod)){
            throw TwException.error("","结算周期和结算方式不能同时为空");
        }
        conServicePriceDAO.updateBySaleConId(saleConId, settlementCycle, settlementMethod);
    }

}
