package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinYearPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinYearQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinYearDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFinYearDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinYearRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 财务年度
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemFinYearDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemFinYearRepo repo;
    private final QPrdSystemFinYearDO qdo = QPrdSystemFinYearDO.prdSystemFinYearDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFinYearVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemFinYearVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 财务年度
                qdo.finYear,
                // 开始日期
                qdo.beginDate,
                // 结束日期
                qdo.endDate,
                // 财年状态
                qdo.yearStatus
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFinYearVO> getJpaQueryWhere(PrdSystemFinYearQuery query) {
        JPAQuery<PrdSystemFinYearVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
            }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PrdSystemFinYearQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PrdSystemFinYearQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 财务年度 精确 */
        if (!ObjectUtils.isEmpty(query.getFinYear())) {
            list.add(qdo.finYear.eq(query.getFinYear()));
        }
        /** 开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getBeginDate())) {
            list.add(qdo.beginDate.eq(query.getBeginDate()));
        }
        /** 结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 财年状态 精确 */
        if (!ObjectUtils.isEmpty(query.getYearStatus())) {
            list.add(qdo.yearStatus.eq(query.getYearStatus()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemFinYearVO queryByKey(Long id) {
        JPAQuery<PrdSystemFinYearVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemFinYearVO> queryListDynamic(PrdSystemFinYearQuery query) {
        JPAQuery<PrdSystemFinYearVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemFinYearVO> queryPaging(PrdSystemFinYearQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<PrdSystemFinYearVO> jpaQuery = getJpaQueryWhere(query);
        List<PrdSystemFinYearVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemFinYearVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemFinYearDO save(PrdSystemFinYearDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdSystemFinYearDO> saveAll(List<PrdSystemFinYearDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PrdSystemFinYearPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 财务年度
        if (payload.getFinYear() != null) {
            update.set(qdo.finYear, payload.getFinYear());
        }
        // 开始日期
        if (payload.getBeginDate() != null) {
            update.set(qdo.beginDate, payload.getBeginDate());
        }
        // 结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 财年状态
        if (payload.getYearStatus() != null) {
            update.set(qdo.yearStatus, payload.getYearStatus());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 财务年度
            if (nullFields.contains("finYear")) {
                update.setNull(qdo.finYear);
            }
            // 开始日期
            if (nullFields.contains("beginDate")) {
                update.setNull(qdo.beginDate);
            }
            // 结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 财年状态
            if (nullFields.contains("yearStatus")) {
                update.setNull(qdo.yearStatus);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

