package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinPeriodPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinPeriodService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinYearService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFinPeriodConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFinPeriodDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinPeriodRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 财务期间
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemFinPeriodServiceImpl extends BaseServiceImpl implements PrdSystemFinPeriodService {

    private final PrdSystemFinPeriodRepo prdSystemFinPeriodRepo;
    private final PrdSystemFinPeriodDAO prdSystemFinPeriodDAO;
    private final PrdSystemFinYearService prdSystemFinYearService;

    @Override
    public PagingVO<PrdSystemFinPeriodVO> queryPaging(PrdSystemFinPeriodQuery query) {
        return prdSystemFinPeriodDAO.queryPaging(query);
    }

    @Override
    public List<PrdSystemFinPeriodVO> queryListDynamic(PrdSystemFinPeriodQuery query) {
        return prdSystemFinPeriodDAO.queryListDynamic(query);
    }

    @Override
    public PrdSystemFinPeriodVO queryByKey(Long key) {
        return prdSystemFinPeriodDAO.queryByKey(key);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemFinPeriodVO insert(PrdSystemFinPeriodPayload payload) {
        //检查是否存在该期间名称
        PrdSystemFinPeriodVO vo = prdSystemFinPeriodDAO.selectInspect(payload.getPeriodName());
        if (vo != null) {
            throw TwException.error("", "财务期间已存在！");
        }
        PrdSystemFinPeriodDO entityDo = PrdSystemFinPeriodConvert.INSTANCE.toDo(payload);
        //查询财务年度表有无此年度 如果没有就插入
        PrdSystemFinYearVO prdSystemFinYearVO = prdSystemFinYearService.findByFinYear(payload.getFinYear());
        entityDo.setFinYearId(prdSystemFinYearVO.getId());
        return PrdSystemFinPeriodConvert.INSTANCE.toVo(prdSystemFinPeriodRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemFinPeriodVO update(PrdSystemFinPeriodPayload payload) {
        PrdSystemFinPeriodDO entity = prdSystemFinPeriodRepo.findById(payload.getId()).orElseGet(PrdSystemFinPeriodDO::new);
        Assert.notNull(entity.getId(), "不存在");
        //检查是否存在该期间名称
        PrdSystemFinPeriodVO vo = prdSystemFinPeriodDAO.selectInspect(payload.getPeriodName());
        if (vo != null) {
            if (!vo.getId().equals(payload.getId())) {
                throw TwException.error("", "财务期间已存在！");
            }
        }
        PrdSystemFinPeriodDO entityDo = PrdSystemFinPeriodConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        //查询财务年度表有无此年度 如果没有就插入
        PrdSystemFinYearVO prdSystemFinYearVO = prdSystemFinYearService.findByFinYear(payload.getFinYear());
        entity.setFinYearId(prdSystemFinYearVO.getId());
        //执行修改
        return PrdSystemFinPeriodConvert.INSTANCE.toVo(prdSystemFinPeriodRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdSystemFinPeriodDAO.deleteSoft(keys);
        }
    }


}
